/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.desc;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;

public class HiveParserAlterDatabaseDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AlterDBType alterType;
    private final String databaseName;
    private final Map<String, String> dbProperties;
    private final PrincipalDesc ownerPrincipal;
    private final String location;

    private HiveParserAlterDatabaseDesc(AlterDBType alterType, String databaseName, Map<String, String> dbProperties, PrincipalDesc ownerPrincipal, String location) {
        this.alterType = alterType;
        this.databaseName = databaseName;
        this.dbProperties = dbProperties;
        this.ownerPrincipal = ownerPrincipal;
        this.location = location;
    }

    public AlterDBType getAlterType() {
        return this.alterType;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, String> getDbProperties() {
        return this.dbProperties;
    }

    public PrincipalDesc getOwnerPrincipal() {
        return this.ownerPrincipal;
    }

    public String getLocation() {
        return this.location;
    }

    public static HiveParserAlterDatabaseDesc alterProps(String databaseName, Map<String, String> dbProperties) {
        return new Builder(AlterDBType.ALTER_PROPERTY, databaseName).newProps(dbProperties).build();
    }

    public static HiveParserAlterDatabaseDesc alterOwner(String databaseName, PrincipalDesc ownerPrincipal) {
        return new Builder(AlterDBType.ALTER_OWNER, databaseName).newOwner(ownerPrincipal).build();
    }

    public static HiveParserAlterDatabaseDesc alterLocation(String databaseName, String location) {
        return new Builder(AlterDBType.ALTER_LOCATION, databaseName).newLocation(location).build();
    }

    private static class Builder {
        private final AlterDBType alterType;
        private final String databaseName;
        private Map<String, String> dbProperties;
        private PrincipalDesc ownerPrincipal;
        private String location;

        Builder(AlterDBType alterType, String databaseName) {
            this.alterType = alterType;
            this.databaseName = databaseName;
        }

        Builder newProps(Map<String, String> dbProperties) {
            this.dbProperties = dbProperties;
            return this;
        }

        Builder newOwner(PrincipalDesc ownerPrincipal) {
            this.ownerPrincipal = ownerPrincipal;
            return this;
        }

        Builder newLocation(String location) {
            this.location = location;
            return this;
        }

        HiveParserAlterDatabaseDesc build() {
            return new HiveParserAlterDatabaseDesc(this.alterType, this.databaseName, this.dbProperties, this.ownerPrincipal, this.location);
        }
    }

    public static enum AlterDBType {
        ALTER_PROPERTY,
        ALTER_OWNER,
        ALTER_LOCATION;

    }
}

