/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserUnparseTranslator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserTypeCheckCtx
implements NodeProcessorCtx {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveParserTypeCheckCtx.class);
    private HiveParserRowResolver inputRR;
    private HiveParserRowResolver outerRR;
    private Map<HiveParserASTNode, RelNode> subqueryToRelNode;
    private final boolean useCaching;
    private final boolean foldExpr;
    private HiveParserUnparseTranslator unparseTranslator;
    private String error;
    private HiveParserASTNode errorSrcNode;
    private boolean allowStatefulFunctions;
    private boolean allowDistinctFunctions;
    private final boolean allowGBExprElimination;
    private final boolean allowAllColRef;
    private final boolean allowFunctionStar;
    private final boolean allowWindowing;
    private final boolean allowIndexExpr;
    private final boolean allowSubQueryExpr;
    private final FrameworkConfig frameworkConfig;
    private final RelOptCluster cluster;

    public HiveParserTypeCheckCtx(HiveParserRowResolver inputRR, FrameworkConfig frameworkConfig, RelOptCluster cluster) {
        this(inputRR, true, false, frameworkConfig, cluster);
    }

    public HiveParserTypeCheckCtx(HiveParserRowResolver inputRR, boolean useCaching, boolean foldExpr, FrameworkConfig frameworkConfig, RelOptCluster cluster) {
        this(inputRR, useCaching, foldExpr, false, true, true, true, true, true, true, true, frameworkConfig, cluster);
    }

    public HiveParserTypeCheckCtx(HiveParserRowResolver inputRR, boolean useCaching, boolean foldExpr, boolean allowStatefulFunctions, boolean allowDistinctFunctions, boolean allowGBExprElimination, boolean allowAllColRef, boolean allowFunctionStar, boolean allowWindowing, boolean allowIndexExpr, boolean allowSubQueryExpr, FrameworkConfig frameworkConfig, RelOptCluster cluster) {
        this.setInputRR(inputRR);
        this.error = null;
        this.useCaching = useCaching;
        this.foldExpr = foldExpr;
        this.allowStatefulFunctions = allowStatefulFunctions;
        this.allowDistinctFunctions = allowDistinctFunctions;
        this.allowGBExprElimination = allowGBExprElimination;
        this.allowAllColRef = allowAllColRef;
        this.allowFunctionStar = allowFunctionStar;
        this.allowWindowing = allowWindowing;
        this.allowIndexExpr = allowIndexExpr;
        this.allowSubQueryExpr = allowSubQueryExpr;
        this.outerRR = null;
        this.subqueryToRelNode = null;
        this.frameworkConfig = frameworkConfig;
        this.cluster = cluster;
    }

    public void setInputRR(HiveParserRowResolver inputRR) {
        this.inputRR = inputRR;
    }

    public HiveParserRowResolver getInputRR() {
        return this.inputRR;
    }

    public void setOuterRR(HiveParserRowResolver outerRR) {
        this.outerRR = outerRR;
    }

    public HiveParserRowResolver getOuterRR() {
        return this.outerRR;
    }

    public void setSubqueryToRelNode(Map<HiveParserASTNode, RelNode> subqueryToRelNode) {
        this.subqueryToRelNode = subqueryToRelNode;
    }

    public Map<HiveParserASTNode, RelNode> getSubqueryToRelNode() {
        return this.subqueryToRelNode;
    }

    public void setUnparseTranslator(HiveParserUnparseTranslator unparseTranslator) {
        this.unparseTranslator = unparseTranslator;
    }

    public HiveParserUnparseTranslator getUnparseTranslator() {
        return this.unparseTranslator;
    }

    public void setAllowStatefulFunctions(boolean allowStatefulFunctions) {
        this.allowStatefulFunctions = allowStatefulFunctions;
    }

    public boolean getAllowStatefulFunctions() {
        return this.allowStatefulFunctions;
    }

    public void setError(String error, HiveParserASTNode errorSrcNode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting error: [" + error + "] from " + (errorSrcNode == null ? "null" : errorSrcNode.toStringTree()), (Throwable)new Exception());
        }
        this.error = error;
        this.errorSrcNode = errorSrcNode;
    }

    public String getError() {
        return this.error;
    }

    public HiveParserASTNode getErrorSrcNode() {
        return this.errorSrcNode;
    }

    public void setAllowDistinctFunctions(boolean allowDistinctFunctions) {
        this.allowDistinctFunctions = allowDistinctFunctions;
    }

    public boolean getAllowDistinctFunctions() {
        return this.allowDistinctFunctions;
    }

    public boolean getAllowGBExprElimination() {
        return this.allowGBExprElimination;
    }

    public boolean getallowAllColRef() {
        return this.allowAllColRef;
    }

    public boolean getallowFunctionStar() {
        return this.allowFunctionStar;
    }

    public boolean getallowWindowing() {
        return this.allowWindowing;
    }

    public boolean getallowIndexExpr() {
        return this.allowIndexExpr;
    }

    public boolean getallowSubQueryExpr() {
        return this.allowSubQueryExpr;
    }

    public boolean isUseCaching() {
        return this.useCaching;
    }

    public boolean isFoldExpr() {
        return this.foldExpr;
    }

    public SqlOperatorTable getSqlOperatorTable() {
        return this.frameworkConfig.getOperatorTable();
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.cluster.getTypeFactory();
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }
}

