/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlMonotonicBinaryOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.planner.delegation.hive.HiveParserIN;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBetween;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExtractDate;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserFloorDate;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSqlCountAggFunction;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSqlMinMaxAggFunction;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSqlSumAggFunction;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserSqlFunctionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserSqlFunctionConverter.class);
    static final Map<String, SqlOperator> HIVE_TO_CALCITE;
    static final Map<SqlOperator, HiveToken> CALCITE_TO_HIVE_TOKEN;
    static final Map<SqlOperator, String> REVERSE_OPERATOR_MAP;

    public static SqlOperator getCalciteOperator(String funcTextName, GenericUDF hiveUDF, List<RelDataType> calciteArgTypes, RelDataType retType) throws SemanticException {
        if (hiveUDF instanceof GenericUDFOPNegative) {
            return SqlStdOperatorTable.UNARY_MINUS;
        }
        if (hiveUDF instanceof GenericUDFOPPositive) {
            return SqlStdOperatorTable.UNARY_PLUS;
        }
        String name = null;
        if (StringUtils.isEmpty(funcTextName)) {
            name = HiveParserSqlFunctionConverter.getName(hiveUDF);
            LOG.warn("The function text was empty, name from annotation is " + name);
        } else {
            name = FunctionRegistry.getNormalizedFunctionName(funcTextName);
        }
        return HiveParserSqlFunctionConverter.getCalciteFn(name, calciteArgTypes, retType, FunctionRegistry.isDeterministic(hiveUDF));
    }

    private static String getName(GenericUDF hiveUDF) {
        String udfName = null;
        if (hiveUDF instanceof GenericUDFBridge) {
            udfName = hiveUDF.getUdfName();
        } else {
            int indx;
            String[] aliases;
            Class<?> udfClass = hiveUDF.getClass();
            Description udfAnnotation = udfClass.getAnnotation(Description.class);
            if (udfAnnotation != null && (udfName = udfAnnotation.name()) != null && (aliases = udfName.split(",")).length > 0) {
                udfName = aliases[0];
            }
            if ((udfName == null || udfName.isEmpty()) && (indx = (udfName = hiveUDF.getClass().getName()).lastIndexOf(".")) >= 0) {
                udfName = udfName.substring(++indx);
            }
        }
        return udfName;
    }

    private static HiveToken hToken(int type, String text) {
        return new HiveToken(type, text, new String[0]);
    }

    private static CalciteUDFInfo getUDFInfo(String hiveUdfName, List<RelDataType> calciteArgTypes, RelDataType calciteRetType) {
        CalciteUDFInfo udfInfo = new CalciteUDFInfo();
        udfInfo.udfName = hiveUdfName;
        String[] nameParts = hiveUdfName.split("\\.");
        if (nameParts.length > 1) {
            udfInfo.identifier = new SqlIdentifier(Arrays.stream(nameParts).collect(Collectors.toList()), new SqlParserPos(0, 0));
        }
        udfInfo.returnTypeInference = (SqlReturnTypeInference)ReturnTypes.explicit((RelDataType)calciteRetType);
        udfInfo.operandTypeInference = InferTypes.explicit(calciteArgTypes);
        ArrayList<Object> typeFamily = new ArrayList<Object>();
        for (RelDataType argType : calciteArgTypes) {
            typeFamily.add(Util.first((Object)argType.getSqlTypeName().getFamily(), (Object)SqlTypeFamily.ANY));
        }
        udfInfo.operandTypeChecker = (SqlOperandTypeChecker)OperandTypes.family(Collections.unmodifiableList(typeFamily));
        return udfInfo;
    }

    public static SqlOperator getCalciteFn(String hiveUdfName, List<RelDataType> calciteArgTypes, RelDataType calciteRetType, boolean deterministic) {
        Object calciteOp;
        CalciteUDFInfo uInf = HiveParserSqlFunctionConverter.getUDFInfo(hiveUdfName, calciteArgTypes, calciteRetType);
        switch (hiveUdfName) {
            case "-": {
                calciteOp = new SqlMonotonicBinaryOperator("-", SqlKind.MINUS, 40, true, uInf.returnTypeInference, uInf.operandTypeInference, (SqlOperandTypeChecker)OperandTypes.MINUS_OPERATOR);
                break;
            }
            case "+": {
                calciteOp = new SqlMonotonicBinaryOperator("+", SqlKind.PLUS, 40, true, uInf.returnTypeInference, uInf.operandTypeInference, (SqlOperandTypeChecker)OperandTypes.PLUS_OPERATOR);
                break;
            }
            default: {
                calciteOp = HIVE_TO_CALCITE.get(hiveUdfName);
                if (null != calciteOp) break;
                calciteOp = new CalciteSqlFn(uInf.udfName, uInf.identifier, SqlKind.OTHER_FUNCTION, uInf.returnTypeInference, uInf.operandTypeInference, uInf.operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION, deterministic);
            }
        }
        return calciteOp;
    }

    public static SqlAggFunction getCalciteAggFn(String hiveUdfName, boolean isDistinct, List<RelDataType> calciteArgTypes, RelDataType calciteRetType) {
        SqlAggFunction calciteAggFn = (SqlAggFunction)HIVE_TO_CALCITE.get(hiveUdfName);
        if (calciteAggFn == null) {
            CalciteUDFInfo udfInfo = HiveParserSqlFunctionConverter.getUDFInfo(hiveUdfName, calciteArgTypes, calciteRetType);
            switch (hiveUdfName.toLowerCase()) {
                case "sum": {
                    calciteAggFn = new HiveParserSqlSumAggFunction(isDistinct, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                    break;
                }
                case "count": {
                    calciteAggFn = new HiveParserSqlCountAggFunction(isDistinct, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                    break;
                }
                case "min": {
                    calciteAggFn = new HiveParserSqlMinMaxAggFunction(udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker, true);
                    break;
                }
                case "max": {
                    calciteAggFn = new HiveParserSqlMinMaxAggFunction(udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker, false);
                    break;
                }
                default: {
                    calciteAggFn = new CalciteUDAF(isDistinct, udfInfo.udfName, udfInfo.identifier, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                }
            }
        }
        return calciteAggFn;
    }

    static {
        StaticBlockBuilder builder = new StaticBlockBuilder();
        HIVE_TO_CALCITE = Collections.unmodifiableMap(builder.hiveToCalcite);
        CALCITE_TO_HIVE_TOKEN = Collections.unmodifiableMap(builder.calciteToHiveToken);
        REVERSE_OPERATOR_MAP = Collections.unmodifiableMap(builder.reverseOperatorMap);
    }

    public static interface CanAggregateDistinct {
        public boolean isDistinct();
    }

    static class HiveToken {
        int type;
        String text;
        String[] args;

        HiveToken(int type, String text, String ... args) {
            this.type = type;
            this.text = text;
            this.args = args;
        }
    }

    private static class CalciteUDFInfo {
        private String udfName;
        private SqlIdentifier identifier;
        private SqlReturnTypeInference returnTypeInference;
        private SqlOperandTypeInference operandTypeInference;
        private SqlOperandTypeChecker operandTypeChecker;

        private CalciteUDFInfo() {
        }
    }

    public static class CalciteSqlFn
    extends SqlFunction {
        private final boolean deterministic;

        public CalciteSqlFn(String name, SqlIdentifier identifier, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category, boolean deterministic) {
            super(name, identifier, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category);
            this.deterministic = deterministic;
        }

        public boolean isDeterministic() {
            return this.deterministic;
        }
    }

    private static class CalciteUDAF
    extends SqlAggFunction
    implements CanAggregateDistinct {
        private final boolean isDistinct;

        public CalciteUDAF(boolean isDistinct, String opName, SqlIdentifier identifier, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
            super(opName, identifier, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION);
            this.isDistinct = isDistinct;
        }

        @Override
        public boolean isDistinct() {
            return this.isDistinct;
        }
    }

    private static class StaticBlockBuilder {
        final Map<String, SqlOperator> hiveToCalcite = new HashMap<String, SqlOperator>();
        final Map<SqlOperator, HiveToken> calciteToHiveToken = new HashMap<SqlOperator, HiveToken>();
        final Map<SqlOperator, String> reverseOperatorMap = new HashMap<SqlOperator, String>();

        StaticBlockBuilder() {
            this.registerFunction("+", (SqlOperator)SqlStdOperatorTable.PLUS, HiveParserSqlFunctionConverter.hToken(343, "+"));
            this.registerFunction("-", (SqlOperator)SqlStdOperatorTable.MINUS, HiveParserSqlFunctionConverter.hToken(338, "-"));
            this.registerFunction("*", (SqlOperator)SqlStdOperatorTable.MULTIPLY, HiveParserSqlFunctionConverter.hToken(352, "*"));
            this.registerFunction("/", (SqlOperator)SqlStdOperatorTable.DIVIDE, HiveParserSqlFunctionConverter.hToken(14, "/"));
            this.registerFunction("%", (SqlOperator)SqlStdOperatorTable.MOD, HiveParserSqlFunctionConverter.hToken(24, "%"));
            this.registerFunction("and", (SqlOperator)SqlStdOperatorTable.AND, HiveParserSqlFunctionConverter.hToken(33, "and"));
            this.registerFunction("or", (SqlOperator)SqlStdOperatorTable.OR, HiveParserSqlFunctionConverter.hToken(202, "or"));
            this.registerFunction("=", (SqlOperator)SqlStdOperatorTable.EQUALS, HiveParserSqlFunctionConverter.hToken(18, "="));
            this.registerDuplicateFunction("==", (SqlOperator)SqlStdOperatorTable.EQUALS, HiveParserSqlFunctionConverter.hToken(18, "="));
            this.registerFunction("<", (SqlOperator)SqlStdOperatorTable.LESS_THAN, HiveParserSqlFunctionConverter.hToken(332, "<"));
            this.registerFunction("<=", (SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, HiveParserSqlFunctionConverter.hToken(333, "<="));
            this.registerFunction(">", (SqlOperator)SqlStdOperatorTable.GREATER_THAN, HiveParserSqlFunctionConverter.hToken(21, ">"));
            this.registerFunction(">=", (SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, HiveParserSqlFunctionConverter.hToken(22, ">="));
            this.registerFunction("not", (SqlOperator)SqlStdOperatorTable.NOT, HiveParserSqlFunctionConverter.hToken(192, "not"));
            this.registerDuplicateFunction("!", (SqlOperator)SqlStdOperatorTable.NOT, HiveParserSqlFunctionConverter.hToken(192, "not"));
            this.registerFunction("<>", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, HiveParserSqlFunctionConverter.hToken(340, "<>"));
            this.registerDuplicateFunction("!=", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, HiveParserSqlFunctionConverter.hToken(340, "<>"));
            this.registerFunction("in", (SqlOperator)HiveParserIN.INSTANCE, HiveParserSqlFunctionConverter.hToken(24, "in"));
            this.registerFunction("between", (SqlOperator)HiveParserBetween.INSTANCE, HiveParserSqlFunctionConverter.hToken(24, "between"));
            this.registerFunction("struct", (SqlOperator)SqlStdOperatorTable.ROW, HiveParserSqlFunctionConverter.hToken(24, "struct"));
            this.registerFunction("isnotnull", (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, HiveParserSqlFunctionConverter.hToken(800, "TOK_ISNOTNULL"));
            this.registerFunction("isnull", (SqlOperator)SqlStdOperatorTable.IS_NULL, HiveParserSqlFunctionConverter.hToken(801, "TOK_ISNULL"));
            this.registerFunction("year", (SqlOperator)HiveParserExtractDate.YEAR, HiveParserSqlFunctionConverter.hToken(24, "year"));
            this.registerFunction("quarter", (SqlOperator)HiveParserExtractDate.QUARTER, HiveParserSqlFunctionConverter.hToken(24, "quarter"));
            this.registerFunction("month", (SqlOperator)HiveParserExtractDate.MONTH, HiveParserSqlFunctionConverter.hToken(24, "month"));
            this.registerFunction("weekofyear", (SqlOperator)HiveParserExtractDate.WEEK, HiveParserSqlFunctionConverter.hToken(24, "weekofyear"));
            this.registerFunction("day", (SqlOperator)HiveParserExtractDate.DAY, HiveParserSqlFunctionConverter.hToken(24, "day"));
            this.registerFunction("hour", (SqlOperator)HiveParserExtractDate.HOUR, HiveParserSqlFunctionConverter.hToken(24, "hour"));
            this.registerFunction("minute", (SqlOperator)HiveParserExtractDate.MINUTE, HiveParserSqlFunctionConverter.hToken(24, "minute"));
            this.registerFunction("second", (SqlOperator)HiveParserExtractDate.SECOND, HiveParserSqlFunctionConverter.hToken(24, "second"));
            this.registerFunction("floor_year", (SqlOperator)HiveParserFloorDate.YEAR, HiveParserSqlFunctionConverter.hToken(24, "floor_year"));
            this.registerFunction("floor_quarter", (SqlOperator)HiveParserFloorDate.QUARTER, HiveParserSqlFunctionConverter.hToken(24, "floor_quarter"));
            this.registerFunction("floor_month", (SqlOperator)HiveParserFloorDate.MONTH, HiveParserSqlFunctionConverter.hToken(24, "floor_month"));
            this.registerFunction("floor_week", (SqlOperator)HiveParserFloorDate.WEEK, HiveParserSqlFunctionConverter.hToken(24, "floor_week"));
            this.registerFunction("floor_day", (SqlOperator)HiveParserFloorDate.DAY, HiveParserSqlFunctionConverter.hToken(24, "floor_day"));
            this.registerFunction("floor_hour", (SqlOperator)HiveParserFloorDate.HOUR, HiveParserSqlFunctionConverter.hToken(24, "floor_hour"));
            this.registerFunction("floor_minute", (SqlOperator)HiveParserFloorDate.MINUTE, HiveParserSqlFunctionConverter.hToken(24, "floor_minute"));
            this.registerFunction("floor_second", (SqlOperator)HiveParserFloorDate.SECOND, HiveParserSqlFunctionConverter.hToken(24, "floor_second"));
            this.registerFunction("<=>", (SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, HiveParserSqlFunctionConverter.hToken(19, "<=>"));
        }

        private void registerFunction(String name, SqlOperator calciteFn, HiveToken hiveToken) {
            FunctionInfo hFn;
            this.reverseOperatorMap.put(calciteFn, name);
            try {
                hFn = FunctionRegistry.getFunctionInfo(name);
            }
            catch (SemanticException e) {
                LOG.warn("Failed to load udf " + name, (Throwable)e);
                hFn = null;
            }
            if (hFn != null) {
                String hFnName = HiveParserSqlFunctionConverter.getName(hFn.getGenericUDF());
                this.hiveToCalcite.put(hFnName, calciteFn);
                if (hiveToken != null) {
                    this.calciteToHiveToken.put(calciteFn, hiveToken);
                }
            }
        }

        private void registerDuplicateFunction(String name, SqlOperator calciteFn, HiveToken hiveToken) {
            this.hiveToCalcite.put(name, calciteFn);
            if (hiveToken != null) {
                this.calciteToHiveToken.put(calciteFn, hiveToken);
            }
        }
    }
}

