/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserNamedJoinInfo;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserRowResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RowSchema rowSchema = new RowSchema();
    private final LinkedHashMap<String, LinkedHashMap<String, ColumnInfo>> rslvMap = new LinkedHashMap();
    private final HashMap<String, String[]> invRslvMap = new HashMap();
    private final Map<String, String[]> altInvRslvMap = new HashMap<String, String[]>();
    private final Map<String, HiveParserASTNode> expressionMap = new HashMap<String, HiveParserASTNode>();
    private boolean isExprResolver = false;
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveParserRowResolver.class.getName());
    private HiveParserNamedJoinInfo namedJoinInfo;

    public void putExpression(HiveParserASTNode node, ColumnInfo colInfo) {
        String treeAsString = node.toStringTree();
        this.expressionMap.put(treeAsString, node);
        this.put("", treeAsString, colInfo);
    }

    public ColumnInfo getExpression(HiveParserASTNode node) throws SemanticException {
        return this.get("", node.toStringTree());
    }

    public HiveParserASTNode getExpressionSource(HiveParserASTNode node) {
        return this.expressionMap.get(node.toStringTree());
    }

    public void put(String tabAlias, String colAlias, ColumnInfo colInfo) {
        if (!this.addMappingOnly(tabAlias, colAlias, colInfo)) {
            if (tabAlias != null) {
                colInfo.setTabAlias(tabAlias.toLowerCase());
            }
            if (colAlias != null) {
                colInfo.setAlias(colAlias.toLowerCase());
            }
            this.rowSchema.getSignature().add(colInfo);
        }
    }

    public boolean addMappingOnly(String tabAlias, String colAlias, ColumnInfo colInfo) {
        if (tabAlias != null) {
            tabAlias = tabAlias.toLowerCase();
        }
        boolean colPresent = this.invRslvMap.containsKey(colInfo.getInternalName());
        LinkedHashMap fMap = this.rslvMap.computeIfAbsent(tabAlias, k -> new LinkedHashMap());
        ColumnInfo oldColInfo = fMap.put(colAlias, colInfo);
        if (oldColInfo != null) {
            LOG.warn("Duplicate column info for " + tabAlias + "." + colAlias + " was overwritten in HiveParserRowResolver map: " + oldColInfo + " by " + colInfo);
        }
        String[] qualifiedAlias = new String[]{tabAlias, colAlias};
        if (!colPresent) {
            this.invRslvMap.put(colInfo.getInternalName(), qualifiedAlias);
        } else {
            this.altInvRslvMap.put(colInfo.getInternalName(), qualifiedAlias);
        }
        return colPresent;
    }

    public boolean hasTableAlias(String tabAlias) {
        return this.rslvMap.get(tabAlias.toLowerCase()) != null;
    }

    public ColumnInfo get(String tabAlias, String colAlias) throws SemanticException {
        ColumnInfo ret = null;
        if (tabAlias != null) {
            HashMap fMap = this.rslvMap.get(tabAlias = tabAlias.toLowerCase());
            if (fMap == null) {
                return null;
            }
            ret = (ColumnInfo)fMap.get(colAlias);
        } else {
            boolean found = false;
            String foundTbl = null;
            for (Map.Entry<String, LinkedHashMap<String, ColumnInfo>> rslvEntry : this.rslvMap.entrySet()) {
                String rslvKey = rslvEntry.getKey();
                LinkedHashMap<String, ColumnInfo> cmap = rslvEntry.getValue();
                for (Map.Entry<String, ColumnInfo> cmapEnt : cmap.entrySet()) {
                    if (!colAlias.equalsIgnoreCase(cmapEnt.getKey())) continue;
                    if (found && foundTbl != null && rslvKey != null) {
                        throw new SemanticException("Column " + colAlias + " Found in more than One Tables/Subqueries");
                    }
                    found = true;
                    foundTbl = rslvKey == null ? foundTbl : rslvKey;
                    ret = cmapEnt.getValue();
                }
            }
        }
        return ret;
    }

    public ArrayList<ColumnInfo> getColumnInfos() {
        return this.rowSchema.getSignature();
    }

    public List<String> getReferenceableColumnAliases(String tableAlias, int max) {
        int count = 0;
        LinkedHashSet<Object> columnNames = new LinkedHashSet<Object>();
        int tables = this.rslvMap.size();
        Map mapping = this.rslvMap.get(tableAlias);
        if (mapping != null) {
            for (Map.Entry entry : mapping.entrySet()) {
                if (max <= 0 || count < max) {
                    ColumnInfo columnInfo = (ColumnInfo)entry.getValue();
                    if (columnInfo.isHiddenVirtualCol()) continue;
                    columnNames.add(entry.getKey());
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            for (ColumnInfo columnInfo : this.getColumnInfos()) {
                if (max <= 0 || count < max) {
                    String[] inverse;
                    if (columnInfo.isHiddenVirtualCol()) continue;
                    String[] stringArray = inverse = !this.isExprResolver ? this.reverseLookup(columnInfo.getInternalName()) : null;
                    if (inverse != null) {
                        columnNames.add(inverse[0] == null || tables <= 1 ? inverse[1] : inverse[0] + "." + inverse[1]);
                    } else {
                        columnNames.add(columnInfo.getAlias());
                    }
                    ++count;
                    continue;
                }
                break;
            }
        }
        return new ArrayList<String>(columnNames);
    }

    public LinkedHashMap<String, ColumnInfo> getFieldMap(String tabAlias) {
        if (tabAlias == null) {
            return this.rslvMap.get(null);
        }
        return this.rslvMap.get(tabAlias.toLowerCase());
    }

    public int getPosition(String internalName) {
        int pos = -1;
        for (ColumnInfo var : this.rowSchema.getSignature()) {
            ++pos;
            if (!var.getInternalName().equals(internalName)) continue;
            return pos;
        }
        return -1;
    }

    public String[] reverseLookup(String internalName) {
        return this.invRslvMap.get(internalName);
    }

    public void setIsExprResolver(boolean isExprResolver) {
        this.isExprResolver = isExprResolver;
    }

    public boolean getIsExprResolver() {
        return this.isExprResolver;
    }

    public String[] getAlternateMappings(String internalName) {
        return this.altInvRslvMap.get(internalName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, LinkedHashMap<String, ColumnInfo>> e : this.rslvMap.entrySet()) {
            String tab = e.getKey();
            sb.append(tab + "{");
            HashMap fMap = e.getValue();
            if (fMap != null) {
                for (Map.Entry entry : fMap.entrySet()) {
                    sb.append("(" + (String)entry.getKey() + "," + ((ColumnInfo)entry.getValue()).toString() + ")");
                }
            }
            sb.append("} ");
        }
        return sb.toString();
    }

    public RowSchema getRowSchema() {
        return this.rowSchema;
    }

    public LinkedHashMap<String, LinkedHashMap<String, ColumnInfo>> getRslvMap() {
        return this.rslvMap;
    }

    private static boolean add(HiveParserRowResolver rrToAddTo, HiveParserRowResolver rrToAddFrom, IntRef outputColPosRef, int numColumns) throws SemanticException {
        boolean hasDuplicates = false;
        int i = 0;
        int outputColPos = outputColPosRef == null ? 0 : outputColPosRef.val;
        for (ColumnInfo cInfoFrmInput : rrToAddFrom.getRowSchema().getSignature()) {
            if (numColumns >= 0 && i == numColumns) break;
            ColumnInfo newCI = null;
            String internalName = cInfoFrmInput.getInternalName();
            String[] qualifiedColName = rrToAddFrom.reverseLookup(internalName);
            String tabAlias = qualifiedColName[0];
            String colAlias = qualifiedColName[1];
            newCI = new ColumnInfo(cInfoFrmInput);
            newCI.setInternalName(HiveParserBaseSemanticAnalyzer.getColumnInternalName(outputColPos));
            ++outputColPos;
            boolean isUnique = rrToAddTo.putWithCheck(tabAlias, colAlias, internalName, newCI);
            hasDuplicates |= !isUnique;
            qualifiedColName = rrToAddFrom.getAlternateMappings(internalName);
            if (qualifiedColName != null) {
                tabAlias = qualifiedColName[0];
                colAlias = qualifiedColName[1];
                rrToAddTo.put(tabAlias, colAlias, newCI);
            }
            ++i;
        }
        if (outputColPosRef != null) {
            outputColPosRef.val = outputColPos;
        }
        return !hasDuplicates;
    }

    public boolean putWithCheck(String tabAlias, String colAlias, String internalName, ColumnInfo newCI) throws SemanticException {
        ColumnInfo existing = this.get(tabAlias, colAlias);
        if (existing == null) {
            this.put(tabAlias, colAlias, newCI);
            return true;
        }
        if (existing.isSameColumnForRR(newCI)) {
            return true;
        }
        LOG.warn("Found duplicate column alias in RR: " + existing.toMappingString(tabAlias, colAlias) + " adding " + newCI.toMappingString(tabAlias, colAlias));
        if (internalName != null) {
            existing = this.get(tabAlias, internalName);
            if (existing == null) {
                this.put(tabAlias, internalName, newCI);
                return true;
            }
            if (existing.isSameColumnForRR(newCI)) {
                return true;
            }
            LOG.warn("Failed to use internal name after finding a duplicate: " + existing.toMappingString(tabAlias, internalName));
        }
        return false;
    }

    private static boolean add(HiveParserRowResolver rrToAddTo, HiveParserRowResolver rrToAddFrom, IntRef outputColPosRef) throws SemanticException {
        return HiveParserRowResolver.add(rrToAddTo, rrToAddFrom, outputColPosRef, -1);
    }

    public static boolean add(HiveParserRowResolver rrToAddTo, HiveParserRowResolver rrToAddFrom) throws SemanticException {
        return HiveParserRowResolver.add(rrToAddTo, rrToAddFrom, null, -1);
    }

    public static HiveParserRowResolver getCombinedRR(HiveParserRowResolver leftRR, HiveParserRowResolver rightRR) throws SemanticException {
        HiveParserRowResolver combinedRR = new HiveParserRowResolver();
        IntRef outputColPos = new IntRef();
        if (!HiveParserRowResolver.add(combinedRR, leftRR, outputColPos)) {
            LOG.warn("Duplicates detected when adding columns to RR: see previous message");
        }
        if (!HiveParserRowResolver.add(combinedRR, rightRR, outputColPos)) {
            LOG.warn("Duplicates detected when adding columns to RR: see previous message");
        }
        return combinedRR;
    }

    public HiveParserNamedJoinInfo getNamedJoinInfo() {
        return this.namedJoinInfo;
    }

    public void setNamedJoinInfo(HiveParserNamedJoinInfo namedJoinInfo) {
        this.namedJoinInfo = namedJoinInfo;
    }

    private static class IntRef {
        public int val = 0;

        private IntRef() {
        }
    }
}

