/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserContext {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserContext.class);
    private final Configuration conf;
    protected int pathid = 10000;
    private TokenRewriteStream tokenRewriteStream;
    private final Map<String, TokenRewriteStream> viewsTokenRewriteStreams;

    public DestClausePrefix getDestNamePrefix(HiveParserASTNode curNode) {
        assert (curNode != null) : "must supply curNode";
        assert (curNode.getType() == 786 || curNode.getType() == 737);
        return DestClausePrefix.INSERT;
    }

    public HiveParserContext(Configuration conf) {
        this.conf = conf;
        this.viewsTokenRewriteStreams = new HashMap<String, TokenRewriteStream>();
    }

    public boolean isExplainSkipExecution() {
        return false;
    }

    public Path getMRTmpPath(URI uri) {
        return null;
    }

    public void setTokenRewriteStream(TokenRewriteStream tokenRewriteStream) {
        assert (this.tokenRewriteStream == null);
        this.tokenRewriteStream = tokenRewriteStream;
    }

    public TokenRewriteStream getTokenRewriteStream() {
        return this.tokenRewriteStream;
    }

    public void addViewTokenRewriteStream(String viewFullyQualifiedName, TokenRewriteStream tokenRewriteStream) {
        this.viewsTokenRewriteStreams.put(viewFullyQualifiedName, tokenRewriteStream);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static enum DestClausePrefix {
        INSERT("insclause-"),
        UPDATE("updclause-"),
        DELETE("delclause-");

        private final String prefix;

        private DestClausePrefix(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }

    public static enum Operation {
        UPDATE,
        DELETE,
        MERGE,
        OTHER;

    }
}

