/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.planner.delegation.hive.HiveParser;
import org.apache.flink.table.planner.delegation.hive.HiveParserIN;
import org.apache.flink.table.planner.delegation.hive.HiveParserRexNodeConverter;
import org.apache.flink.table.planner.delegation.hive.HiveParserUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBetween;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSqlFunctionConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlTimestampFunction;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.session.SessionState;

public class SqlFunctionConverter
extends RexShuttle {
    private static final Field REX_WINDOW_PART_KEYS;
    private static final Field REX_WINDOW_ORDER_KEYS;
    protected final RelOptCluster cluster;
    protected final RexBuilder builder;
    private final SqlOperatorTable opTable;
    private final SqlNameMatcher nameMatcher;

    public SqlFunctionConverter(RelOptCluster cluster, SqlOperatorTable opTable, SqlNameMatcher nameMatcher) {
        this.cluster = cluster;
        this.builder = cluster.getRexBuilder();
        this.opTable = opTable;
        this.nameMatcher = nameMatcher;
    }

    public RexNode visitCall(RexCall call) {
        SqlOperator operator = call.getOperator();
        List operands = call.getOperands();
        SqlOperator convertedOp = this.convertOperator(operator);
        boolean[] update = null;
        if (convertedOp instanceof SqlCastFunction) {
            RelDataType type = call.getType();
            return this.builder.makeCall(type, convertedOp, this.visitList(operands, update));
        }
        if (convertedOp instanceof FlinkSqlTimestampFunction) {
            Timestamp currentTS = ((HiveParser.HiveParserSessionState)SessionState.get()).getHiveParserCurrentTS();
            try {
                return HiveParserRexNodeConverter.convertConstant(new ExprNodeConstantDesc(currentTS), this.cluster);
            }
            catch (SemanticException e) {
                throw new FlinkHiveException(e);
            }
        }
        return this.builder.makeCall(convertedOp, this.visitList(operands, update));
    }

    public RexNode visitOver(RexOver over) {
        SqlOperator operator = this.convertOperator((SqlOperator)over.getAggOperator());
        Preconditions.checkArgument((boolean)(operator instanceof SqlAggFunction), (Object)("Expect converted operator to be an agg function, but got " + operator.toString()));
        SqlAggFunction convertedAgg = (SqlAggFunction)operator;
        RexWindow window = over.getWindow();
        RelDataType inferredType = this.builder.makeCall((SqlOperator)convertedAgg, over.getOperands()).getType();
        ArrayList<RexNode> partitionKeys = new ArrayList<RexNode>();
        for (RexNode rexNode : this.getPartKeys(window)) {
            if (rexNode instanceof RexLiteral) continue;
            partitionKeys.add(rexNode);
        }
        ArrayList<RexFieldCollation> convertedOrderKeys = new ArrayList<RexFieldCollation>(this.getOrderKeys(window).size());
        for (RexFieldCollation orderKey : this.getOrderKeys(window)) {
            convertedOrderKeys.add(new RexFieldCollation((RexNode)((RexNode)orderKey.getKey()).accept((RexVisitor)this), (Set)orderKey.getValue()));
        }
        boolean[] blArray = null;
        return HiveParserUtils.makeOver(this.builder, inferredType, convertedAgg, this.visitList(over.getOperands(), blArray), this.visitList(partitionKeys, blArray), convertedOrderKeys, window.getLowerBound(), window.getUpperBound(), window.isRows(), true, false, false, false);
    }

    public SqlOperator convertOperator(SqlOperator operator) {
        if (operator instanceof SqlFunction) {
            operator = this.convertOperator(operator, ((SqlFunction)operator).getFunctionType());
        } else if (operator instanceof HiveParserIN || operator instanceof HiveParserBetween) {
            operator = this.convertOperator(operator, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }
        return operator;
    }

    public boolean hasOverloadedOp(SqlOperator operator, SqlFunctionCategory functionType) {
        return operator != this.convertOperator(operator, functionType);
    }

    SqlOperator convertOperator(SqlOperator operator, SqlFunctionCategory functionType) {
        ArrayList overloads = new ArrayList();
        this.opTable.lookupOperatorOverloads(operator.getNameAsId(), functionType, SqlSyntax.FUNCTION, overloads, this.nameMatcher);
        if (!overloads.isEmpty()) {
            return (SqlOperator)overloads.get(0);
        }
        return operator;
    }

    boolean isHiveCalciteSqlFn(SqlOperator operator) {
        return operator instanceof HiveParserSqlFunctionConverter.CalciteSqlFn;
    }

    private List<RexNode> getPartKeys(RexWindow window) {
        try {
            return (List)REX_WINDOW_PART_KEYS.get(window);
        }
        catch (IllegalAccessException e) {
            throw new FlinkHiveException("Failed to get partitionKeys from RexWindow", e);
        }
    }

    private List<RexFieldCollation> getOrderKeys(RexWindow window) {
        try {
            return (List)REX_WINDOW_ORDER_KEYS.get(window);
        }
        catch (IllegalAccessException e) {
            throw new FlinkHiveException("Failed to get orderKeys from RexWindow", e);
        }
    }

    static {
        try {
            REX_WINDOW_PART_KEYS = RexWindow.class.getDeclaredField("partitionKeys");
            REX_WINDOW_ORDER_KEYS = RexWindow.class.getDeclaredField("orderKeys");
        }
        catch (Exception e) {
            throw new FlinkHiveException("Failed to init RexWindow fields", e);
        }
    }
}

