/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import com.google.common.math.IntMath;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.ExplicitOperatorBinding;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.util.ConversionUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.factories.HiveCatalogFactoryOptions;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.hive.HiveGenericUDAF;
import org.apache.flink.table.functions.hive.HiveGenericUDTF;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.delegation.hive.HiveParserRexNodeConverter;
import org.apache.flink.table.planner.delegation.hive.HiveParserTypeCheckProcFactory;
import org.apache.flink.table.planner.delegation.hive.SqlFunctionConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseDriver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserJoinCondTypeCheckProcFactory;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQB;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSqlFunctionConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeCheckCtx;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserUnparseTranslator;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserCreateViewDesc;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserErrorMsg;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.utils.HiveAggSqlFunction;
import org.apache.flink.table.planner.functions.utils.HiveTableSqlFunction;
import org.apache.flink.table.runtime.types.ClassLogicalTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserUtils.class);
    private static final Class immutableListClz = HiveReflectionUtils.tryGetClass("com.google.common.collect.ImmutableList");
    private static final Class shadedImmutableListClz = HiveReflectionUtils.tryGetClass("org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList");
    private static final boolean useShadedImmutableList = shadedImmutableListClz != null;

    private HiveParserUtils() {
    }

    public static void removeASTChild(HiveParserASTNode node) {
        Tree parent = node.getParent();
        if (parent != null) {
            parent.deleteChild(node.getChildIndex());
            node.setParent(null);
        }
    }

    public static NlsString asUnicodeString(String text) {
        return new NlsString(text, ConversionUtil.NATIVE_UTF16_CHARSET_NAME, SqlCollation.IMPLICIT);
    }

    public static String canHandleQbForCbo(QueryProperties queryProperties) {
        if (!queryProperties.hasPTF() && !queryProperties.usesScript()) {
            return null;
        }
        String msg = "";
        if (queryProperties.hasPTF()) {
            msg = msg + "has PTF; ";
        }
        if (queryProperties.usesScript()) {
            msg = msg + "uses scripts; ";
        }
        return msg;
    }

    public static RelDataType toRelDataType(TypeInfo typeInfo, RelDataTypeFactory relTypeFactory) throws SemanticException {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                RelDataType res = HiveParserTypeConverter.convert(typeInfo, relTypeFactory);
                return relTypeFactory.createTypeWithNullability(res, false);
            }
            case LIST: {
                RelDataType elementType = HiveParserUtils.toRelDataType(((ListTypeInfo)typeInfo).getListElementTypeInfo(), relTypeFactory);
                return relTypeFactory.createArrayType(elementType, -1L);
            }
            case MAP: {
                RelDataType keyType = HiveParserUtils.toRelDataType(((MapTypeInfo)typeInfo).getMapKeyTypeInfo(), relTypeFactory);
                RelDataType valType = HiveParserUtils.toRelDataType(((MapTypeInfo)typeInfo).getMapValueTypeInfo(), relTypeFactory);
                return relTypeFactory.createMapType(keyType, valType);
            }
            case STRUCT: {
                ArrayList<TypeInfo> types = ((StructTypeInfo)typeInfo).getAllStructFieldTypeInfos();
                ArrayList<RelDataType> convertedTypes = new ArrayList<RelDataType>(types.size());
                for (TypeInfo type : types) {
                    convertedTypes.add(HiveParserUtils.toRelDataType(type, relTypeFactory));
                }
                return relTypeFactory.createStructType(convertedTypes, ((StructTypeInfo)typeInfo).getAllStructFieldNames());
            }
        }
        throw new SemanticException(String.format("%s type is not supported yet", typeInfo.getCategory().name()));
    }

    public static RexNode makeOver(RexBuilder rexBuilder, RelDataType type, SqlAggFunction operator, List<RexNode> exprs, List<RexNode> partitionKeys, List<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean physical, boolean allowPartial, boolean nullWhenCountZero, boolean distinct, boolean ignoreNulls) {
        Preconditions.checkState((immutableListClz != null || shadedImmutableListClz != null ? 1 : 0) != 0, (Object)"Neither original nor shaded guava class can be found");
        Method method = null;
        String methodName = "makeOver";
        int orderKeysIndex = 4;
        Class[] argTypes = new Class[]{RelDataType.class, SqlAggFunction.class, List.class, List.class, null, RexWindowBound.class, RexWindowBound.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE};
        if (immutableListClz != null) {
            argTypes[4] = immutableListClz;
            method = HiveReflectionUtils.tryGetMethod(rexBuilder.getClass(), "makeOver", argTypes);
        }
        if (method == null) {
            Preconditions.checkState((shadedImmutableListClz != null ? 1 : 0) != 0, (Object)String.format("Shaded guava class not found, but method %s takes shaded parameter", "makeOver"));
            argTypes[4] = shadedImmutableListClz;
            method = HiveReflectionUtils.tryGetMethod(rexBuilder.getClass(), "makeOver", argTypes);
        }
        Preconditions.checkState((method != null ? 1 : 0) != 0, (Object)"Neither original nor shaded method can be found");
        Object orderKeysArg = HiveParserUtils.toImmutableList(orderKeys);
        Object[] args = new Object[]{type, operator, exprs, partitionKeys, orderKeysArg, lowerBound, upperBound, physical, allowPartial, nullWhenCountZero, distinct, ignoreNulls};
        try {
            return (RexNode)method.invoke((Object)rexBuilder, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke makeOver", e);
        }
    }

    private static Object toImmutableList(Collection collection) {
        try {
            Class clz = useShadedImmutableList ? shadedImmutableListClz : immutableListClz;
            return HiveReflectionUtils.invokeMethod(clz, null, "copyOf", new Class[]{Collection.class}, new Object[]{collection});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new FlinkHiveException("Failed to create immutable list", e);
        }
    }

    public static RelNode genValuesRelNode(RelOptCluster cluster, RelDataType rowType, List<List<RexLiteral>> rows) {
        List immutableRows = rows.stream().map(HiveParserUtils::toImmutableList).collect(Collectors.toList());
        Class[] argTypes = new Class[]{RelOptCluster.class, RelDataType.class, null};
        argTypes[2] = useShadedImmutableList ? shadedImmutableListClz : immutableListClz;
        Method method = HiveReflectionUtils.tryGetMethod(LogicalValues.class, "create", argTypes);
        Preconditions.checkState((method != null ? 1 : 0) != 0, (Object)"Cannot get the method to create LogicalValues");
        try {
            return (RelNode)method.invoke(null, cluster, rowType, HiveParserUtils.toImmutableList(immutableRows));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new FlinkHiveException("Failed to create LogicalValues", e);
        }
    }

    public static RexSubQuery rexSubQueryIn(RelNode relNode, Collection<RexNode> rexNodes) {
        Class[] argTypes = new Class[]{RelNode.class, null};
        argTypes[1] = useShadedImmutableList ? shadedImmutableListClz : immutableListClz;
        Method method = HiveReflectionUtils.tryGetMethod(RexSubQuery.class, "in", argTypes);
        Preconditions.checkState((method != null ? 1 : 0) != 0, (Object)"Cannot get the method to create an IN sub-query");
        try {
            return (RexSubQuery)method.invoke(null, relNode, HiveParserUtils.toImmutableList(rexNodes));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new FlinkHiveException("Failed to create RexSubQuery", e);
        }
    }

    public static boolean isValuesTempTable(String tableName) {
        return tableName.toLowerCase().startsWith("Values__Tmp__Table__".toLowerCase());
    }

    public static ReadEntity addInput(Set<ReadEntity> inputs, ReadEntity newInput, boolean mergeIsDirectFlag) {
        if (inputs.contains(newInput)) {
            for (ReadEntity input : inputs) {
                if (!input.equals(newInput)) continue;
                if (newInput.getParents() != null && !newInput.getParents().isEmpty()) {
                    input.getParents().addAll(newInput.getParents());
                    input.setDirect(input.isDirect() || newInput.isDirect());
                } else if (mergeIsDirectFlag) {
                    input.setDirect(input.isDirect() || newInput.isDirect());
                }
                return input;
            }
            assert (false);
        } else {
            inputs.add(newInput);
            return newInput;
        }
        return null;
    }

    public static Map<HiveParserASTNode, ExprNodeDesc> genExprNode(HiveParserASTNode expr, HiveParserTypeCheckCtx tcCtx) throws SemanticException {
        return HiveParserTypeCheckProcFactory.genExprNode(expr, tcCtx, new HiveParserJoinCondTypeCheckProcFactory());
    }

    public static String generateErrorMessage(HiveParserASTNode ast, String message) {
        StringBuilder sb = new StringBuilder();
        if (ast == null) {
            sb.append(message).append(". Cannot tell the position of null AST.");
            return sb.toString();
        }
        sb.append(ast.getLine());
        sb.append(":");
        sb.append(ast.getCharPositionInLine());
        sb.append(" ");
        sb.append(message);
        sb.append(". Error encountered near token '");
        sb.append(HiveParserUtils.getText(ast));
        sb.append("'");
        return sb.toString();
    }

    public static void writeAsText(String text, FSDataOutputStream out) throws IOException {
        Text to = new Text(text);
        out.write(to.getBytes(), 0, to.getLength());
    }

    private static HiveParserASTNode buildSelExprSubTree(String tableAlias, String col) {
        HiveParserASTNode selexpr = new HiveParserASTNode(new CommonToken(905, "TOK_SELEXPR"));
        HiveParserASTNode tableOrCol = new HiveParserASTNode(new CommonToken(977, "TOK_TABLE_OR_COL"));
        HiveParserASTNode dot = new HiveParserASTNode(new CommonToken(16, "."));
        tableOrCol.addChild(new HiveParserASTNode(new CommonToken(24, tableAlias)));
        dot.addChild(tableOrCol);
        dot.addChild(new HiveParserASTNode(new CommonToken(24, col)));
        selexpr.addChild(dot);
        return selexpr;
    }

    public static HiveParserASTNode genSelectDIAST(HiveParserRowResolver rr) {
        LinkedHashMap<String, LinkedHashMap<String, ColumnInfo>> map = rr.getRslvMap();
        HiveParserASTNode selectDI = new HiveParserASTNode(new CommonToken(904, "TOK_SELECTDI"));
        for (String tabAlias : map.keySet()) {
            for (Map.Entry<String, ColumnInfo> entry : map.get(tabAlias).entrySet()) {
                selectDI.addChild(HiveParserUtils.buildSelExprSubTree(tabAlias, entry.getKey()));
            }
        }
        return selectDI;
    }

    public static GenericUDAFEvaluator.Mode groupByDescModeToUDAFMode(GroupByDesc.Mode mode, boolean isDistinct) {
        switch (mode) {
            case COMPLETE: {
                return GenericUDAFEvaluator.Mode.COMPLETE;
            }
            case PARTIAL1: {
                return GenericUDAFEvaluator.Mode.PARTIAL1;
            }
            case PARTIAL2: {
                return GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case PARTIALS: {
                return isDistinct ? GenericUDAFEvaluator.Mode.PARTIAL1 : GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case FINAL: {
                return GenericUDAFEvaluator.Mode.FINAL;
            }
            case HASH: {
                return GenericUDAFEvaluator.Mode.PARTIAL1;
            }
            case MERGEPARTIAL: {
                return isDistinct ? GenericUDAFEvaluator.Mode.COMPLETE : GenericUDAFEvaluator.Mode.FINAL;
            }
        }
        throw new RuntimeException("internal error in groupByDescModeToUDAFMode");
    }

    public static boolean isSkewedCol(String alias, HiveParserQB qb, String colName) {
        List<String> skewedCols = qb.getSkewedColumnNames(alias);
        for (String skewedCol : skewedCols) {
            if (!skewedCol.equalsIgnoreCase(colName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJoinToken(HiveParserASTNode node) {
        return node.getToken().getType() == 805 || node.getToken().getType() == 719 || HiveParserUtils.isOuterJoinToken(node) || node.getToken().getType() == 809 || node.getToken().getType() == 1002;
    }

    public static boolean isOuterJoinToken(HiveParserASTNode node) {
        return node.getToken().getType() == 808 || node.getToken().getType() == 898 || node.getToken().getType() == 765;
    }

    public static void extractColumns(Set<String> colNamesExprs, ExprNodeDesc exprNode) {
        if (exprNode instanceof ExprNodeColumnDesc) {
            colNamesExprs.add(((ExprNodeColumnDesc)exprNode).getColumn());
            return;
        }
        if (exprNode instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)exprNode;
            for (ExprNodeDesc childExpr : funcDesc.getChildren()) {
                HiveParserUtils.extractColumns(colNamesExprs, childExpr);
            }
        }
    }

    public static boolean hasCommonElement(Set<String> set1, Set<String> set2) {
        for (String elem1 : set1) {
            if (!set2.contains(elem1)) continue;
            return true;
        }
        return false;
    }

    public static HiveParserBaseSemanticAnalyzer.GenericUDAFInfo getGenericUDAFInfo(GenericUDAFEvaluator evaluator, GenericUDAFEvaluator.Mode emode, ArrayList<ExprNodeDesc> aggParameters) throws SemanticException {
        HiveParserBaseSemanticAnalyzer.GenericUDAFInfo res = new HiveParserBaseSemanticAnalyzer.GenericUDAFInfo();
        res.genericUDAFEvaluator = evaluator;
        try {
            ArrayList<ObjectInspector> aggOIs = HiveParserUtils.getWritableObjectInspector(aggParameters);
            ObjectInspector[] aggOIArray = new ObjectInspector[aggOIs.size()];
            for (int i = 0; i < aggOIs.size(); ++i) {
                aggOIArray[i] = aggOIs.get(i);
            }
            ObjectInspector returnOI = res.genericUDAFEvaluator.init(emode, aggOIArray);
            res.returnType = TypeInfoUtils.getTypeInfoFromObjectInspector(returnOI);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        res.convertedParameters = aggParameters;
        return res;
    }

    public static ArrayList<ObjectInspector> getWritableObjectInspector(ArrayList<ExprNodeDesc> exprs) {
        ArrayList<ObjectInspector> result = new ArrayList<ObjectInspector>();
        for (ExprNodeDesc expr : exprs) {
            result.add(expr.getWritableObjectInspector());
        }
        return result;
    }

    public static GenericUDAFEvaluator getGenericUDAFEvaluator(String aggName, ArrayList<ExprNodeDesc> aggParameters, HiveParserASTNode aggTree, boolean isDistinct, boolean isAllColumns, SqlOperatorTable opTable) throws SemanticException {
        SqlOperator sqlOperator;
        ArrayList<ObjectInspector> originalParameterTypeInfos = HiveParserUtils.getWritableObjectInspector(aggParameters);
        GenericUDAFEvaluator result = FunctionRegistry.getGenericUDAFEvaluator(aggName, originalParameterTypeInfos, isDistinct, isAllColumns);
        if (result == null && (sqlOperator = HiveParserUtils.getSqlOperator(aggName, opTable, SqlFunctionCategory.USER_DEFINED_FUNCTION)) instanceof HiveAggSqlFunction) {
            HiveGenericUDAF hiveGenericUDAF = (HiveGenericUDAF)((HiveAggSqlFunction)sqlOperator).makeFunction(new Object[0], new LogicalType[0]);
            result = hiveGenericUDAF.createEvaluator(originalParameterTypeInfos.toArray(new ObjectInspector[0]));
        }
        if (null == result) {
            String reason = "Looking for UDAF Evaluator\"" + aggName + "\" with parameters " + originalParameterTypeInfos;
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_FUNCTION_SIGNATURE, aggTree.getChild(0), reason));
        }
        return result;
    }

    public static boolean isRegex(String pattern, HiveConf conf) {
        String qIdSupport = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT);
        if ("column".equals(qIdSupport)) {
            return false;
        }
        for (int i = 0; i < pattern.length(); ++i) {
            if (Character.isLetterOrDigit(pattern.charAt(i)) || pattern.charAt(i) == '_') continue;
            return true;
        }
        return false;
    }

    public static String[] getColAlias(HiveParserASTNode selExpr, String defaultName, HiveParserRowResolver inputRR, boolean includeFuncName, int colNum) {
        String colAlias = null;
        String tabAlias = null;
        String[] colRef = new String[2];
        if (selExpr.getChildCount() == 2 || selExpr.getChildCount() == 3 && selExpr.getChild(2).getType() == 1021) {
            colAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(selExpr.getChild(1).getText().toLowerCase());
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        HiveParserASTNode root = (HiveParserASTNode)selExpr.getChild(0);
        if (root.getType() == 977) {
            colAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(root.getChild(0).getText().toLowerCase());
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        if (root.getType() == 16) {
            HiveParserASTNode col;
            String t;
            HiveParserASTNode tab = (HiveParserASTNode)root.getChild(0);
            if (tab.getType() == 977 && inputRR.hasTableAlias(t = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tab.getChild(0).getText()))) {
                tabAlias = t;
            }
            if ((col = (HiveParserASTNode)root.getChild(1)).getType() == 24) {
                colAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(col.getText().toLowerCase());
            }
        }
        if (includeFuncName && root.getType() == 766) {
            String exprFlattened = root.toStringTree();
            String exprNoTok = exprFlattened.replaceAll("tok_\\S+", "");
            String exprFormatted = exprNoTok.replaceAll("\\W", " ").trim().replaceAll("\\s+", "_");
            if (exprFormatted.length() > 20) {
                exprFormatted = exprFormatted.substring(0, 20);
            }
            colAlias = exprFormatted.concat("_" + colNum);
        }
        if (colAlias == null) {
            colAlias = defaultName + colNum;
        }
        colRef[0] = tabAlias;
        colRef[1] = colAlias;
        return colRef;
    }

    public static int unsetBit(int bitmap, int bitIdx) {
        return bitmap & ~(1 << bitIdx);
    }

    public static HiveParserASTNode rewriteGroupingFunctionAST(final List<HiveParserASTNode> grpByAstExprs, HiveParserASTNode targetNode, final boolean noneSet) throws SemanticException {
        final MutableBoolean visited = new MutableBoolean(false);
        final MutableBoolean found = new MutableBoolean(false);
        TreeVisitorAction action = new TreeVisitorAction(){

            @Override
            public Object pre(Object t) {
                return t;
            }

            @Override
            public Object post(Object t) {
                HiveParserASTNode func;
                HiveParserASTNode root = (HiveParserASTNode)t;
                if (root.getType() == 766 && root.getChildCount() == 2 && (func = (HiveParserASTNode)HiveASTParseDriver.ADAPTOR.getChild(root, 0)).getText().equals("grouping")) {
                    HiveParserASTNode c = (HiveParserASTNode)HiveASTParseDriver.ADAPTOR.getChild(root, 1);
                    visited.setValue(true);
                    for (int i = 0; i < grpByAstExprs.size(); ++i) {
                        HiveParserASTNode child1;
                        HiveParserASTNode grpByExpr = (HiveParserASTNode)grpByAstExprs.get(i);
                        if (!grpByExpr.toStringTree().equals(c.toStringTree())) continue;
                        if (noneSet) {
                            child1 = (HiveParserASTNode)HiveASTParseDriver.ADAPTOR.create(25, String.valueOf(0));
                        } else {
                            child1 = (HiveParserASTNode)HiveASTParseDriver.ADAPTOR.create(977, "TOK_TABLE_OR_COL");
                            HiveASTParseDriver.ADAPTOR.addChild(child1, HiveASTParseDriver.ADAPTOR.create(24, VirtualColumn.GROUPINGID.getName()));
                        }
                        HiveParserASTNode child2 = (HiveParserASTNode)HiveASTParseDriver.ADAPTOR.create(25, String.valueOf(IntMath.mod(-i - 1, grpByAstExprs.size())));
                        root.setChild(1, child1);
                        root.addChild(child2);
                        found.setValue(true);
                        break;
                    }
                }
                return t;
            }
        };
        HiveParserASTNode newTargetNode = (HiveParserASTNode)new TreeVisitor(HiveASTParseDriver.ADAPTOR).visit(targetNode, action);
        if (visited.booleanValue() && !found.booleanValue()) {
            throw new SemanticException("Expression in GROUPING function not present in GROUP BY");
        }
        return newTargetNode;
    }

    public static SqlOperator getAnySqlOperator(String funcName, SqlOperatorTable opTable) {
        SqlOperator sqlOperator = HiveParserUtils.getSqlOperator(funcName, opTable, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        if (sqlOperator == null) {
            sqlOperator = HiveParserUtils.getSqlOperator(funcName, opTable, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }
        return sqlOperator;
    }

    public static SqlOperator getSqlOperator(String funcName, SqlOperatorTable opTable, SqlFunctionCategory category) {
        funcName = funcName.toLowerCase();
        String[] names = funcName.split("\\.");
        SqlIdentifier identifier = new SqlIdentifier(Arrays.asList(names), SqlParserPos.ZERO);
        ArrayList operators = new ArrayList();
        try {
            opTable.lookupOperatorOverloads(identifier, category, SqlSyntax.FUNCTION, operators, SqlNameMatchers.withCaseSensitive((boolean)false));
        }
        catch (Exception e) {
            LOG.warn("Error trying to resolve function " + funcName, (Throwable)e);
        }
        if (operators.isEmpty()) {
            return null;
        }
        return (SqlOperator)operators.get(0);
    }

    public static RelDataType inferReturnTypeForOperandsTypes(SqlOperator sqlOperator, List<RelDataType> types, List<RexNode> operands, RelDataTypeFactory dataTypeFactory) {
        HiveParserOperatorBinding operatorBinding = new HiveParserOperatorBinding(dataTypeFactory, sqlOperator, types, operands);
        if (sqlOperator instanceof BridgingSqlFunction || sqlOperator instanceof HiveAggSqlFunction) {
            SqlReturnTypeInference returnTypeInference = sqlOperator.getReturnTypeInference();
            return returnTypeInference.inferReturnType((SqlOperatorBinding)operatorBinding);
        }
        if (sqlOperator instanceof HiveTableSqlFunction) {
            HiveGenericUDTF hiveGenericUDTF = (HiveGenericUDTF)((HiveTableSqlFunction)sqlOperator).makeFunction(new Object[0], new LogicalType[0]);
            DataType dataType = hiveGenericUDTF.getHiveResultType(operatorBinding.getConstantOperands(), (DataType[])types.stream().map(HiveParserUtils::toDataType).toArray(DataType[]::new));
            return HiveParserUtils.toRelDataType(dataType, dataTypeFactory);
        }
        throw new FlinkHiveException("Unsupported SqlOperator class " + sqlOperator.getClass().getName());
    }

    public static RelDataType inferReturnTypeForOperands(SqlOperator sqlOperator, List<RexNode> operands, RelDataTypeFactory dataTypeFactory) {
        return HiveParserUtils.inferReturnTypeForOperandsTypes(sqlOperator, operands.stream().map(RexNode::getType).collect(Collectors.toList()), operands, dataTypeFactory);
    }

    public static RelDataType toRelDataType(DataType dataType, RelDataTypeFactory dtFactory) {
        try {
            return HiveParserUtils.toRelDataType(HiveTypeUtil.toHiveTypeInfo(dataType, false), dtFactory);
        }
        catch (SemanticException e) {
            throw new FlinkHiveException(e);
        }
    }

    public static DataType toDataType(RelDataType relDataType) {
        return HiveTypeUtil.toFlinkType(HiveParserTypeConverter.convert(relDataType));
    }

    public static LateralViewInfo extractLateralViewInfo(HiveParserASTNode lateralView, HiveParserRowResolver inputRR, HiveParserSemanticAnalyzer hiveAnalyzer, FrameworkConfig frameworkConfig, RelOptCluster cluster) throws SemanticException {
        HiveParserASTNode sel = (HiveParserASTNode)lateralView.getChild(0);
        Preconditions.checkArgument((sel.getToken().getType() == 903 ? 1 : 0) != 0);
        Preconditions.checkArgument((sel.getChildCount() == 1 ? 1 : 0) != 0);
        HiveParserASTNode selExpr = (HiveParserASTNode)sel.getChild(0);
        Preconditions.checkArgument((selExpr.getToken().getType() == 905 ? 1 : 0) != 0);
        HiveParserASTNode func = (HiveParserASTNode)selExpr.getChild(0);
        Preconditions.checkArgument((func.getToken().getType() == 766 ? 1 : 0) != 0);
        String funcName = HiveParserTypeCheckProcFactory.DefaultExprProcessor.getFunctionText(func, true);
        SqlOperator sqlOperator = HiveParserUtils.getSqlOperator(funcName, frameworkConfig.getOperatorTable(), SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        Preconditions.checkArgument((boolean)HiveParserUtils.isUDTF(sqlOperator), (Object)(funcName + " is not a valid UDTF"));
        ArrayList<ExprNodeDesc> operands = new ArrayList<ExprNodeDesc>(func.getChildCount() - 1);
        ArrayList<ColumnInfo> operandColInfos = new ArrayList<ColumnInfo>(func.getChildCount() - 1);
        HiveParserTypeCheckCtx typeCheckCtx = new HiveParserTypeCheckCtx(inputRR, frameworkConfig, cluster);
        for (int i = 1; i < func.getChildCount(); ++i) {
            ExprNodeDesc exprDesc = hiveAnalyzer.genExprNodeDesc((HiveParserASTNode)func.getChild(i), inputRR, typeCheckCtx);
            operands.add(exprDesc);
            operandColInfos.add(new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(i - 1), exprDesc.getWritableObjectInspector(), null, false));
        }
        HiveParserASTNode tabAliasNode = (HiveParserASTNode)selExpr.getChild(selExpr.getChildCount() - 1);
        Preconditions.checkArgument((tabAliasNode.getToken().getType() == 953 ? 1 : 0) != 0);
        String tabAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(tabAliasNode.getChild(0).getText().toLowerCase());
        ArrayList<String> colAliases = new ArrayList<String>();
        for (int i = 1; i < selExpr.getChildCount() - 1; ++i) {
            HiveParserASTNode child = (HiveParserASTNode)selExpr.getChild(i);
            Preconditions.checkArgument((child.getToken().getType() == 24 ? 1 : 0) != 0);
            colAliases.add(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(child.getText().toLowerCase()));
        }
        return new LateralViewInfo(funcName, sqlOperator, operands, operandColInfos, colAliases, tabAlias);
    }

    public static boolean isUDAF(SqlOperator sqlOperator) {
        return sqlOperator instanceof SqlAggFunction;
    }

    public static boolean isUDTF(SqlOperator sqlOperator) {
        if (sqlOperator instanceof BridgingSqlFunction) {
            return ((BridgingSqlFunction)sqlOperator).getDefinition().getKind() == FunctionKind.TABLE;
        }
        return sqlOperator instanceof SqlUserDefinedTableFunction;
    }

    public static boolean isNative(SqlOperator sqlOperator) {
        return false;
    }

    public static RexNode projectNonColumnEquiConditions(RelFactories.ProjectFactory factory, RelNode[] inputRels, List<RexNode> leftJoinKeys, List<RexNode> rightJoinKeys, int systemColCount, List<Integer> leftKeys, List<Integer> rightKeys) {
        RelDataTypeField field;
        int i;
        RelNode leftRel = inputRels[0];
        RelNode rightRel = inputRels[1];
        RexBuilder rexBuilder = leftRel.getCluster().getRexBuilder();
        RexNode outJoinCond = null;
        int origLeftInputSize = leftRel.getRowType().getFieldCount();
        int origRightInputSize = rightRel.getRowType().getFieldCount();
        ArrayList<Object> newLeftFields = new ArrayList<Object>();
        ArrayList<String> newLeftFieldNames = new ArrayList<String>();
        ArrayList<Object> newRightFields = new ArrayList<Object>();
        ArrayList<String> newRightFieldNames = new ArrayList<String>();
        int leftKeyCount = leftJoinKeys.size();
        for (i = 0; i < origLeftInputSize; ++i) {
            field = (RelDataTypeField)leftRel.getRowType().getFieldList().get(i);
            newLeftFields.add(rexBuilder.makeInputRef(field.getType(), i));
            newLeftFieldNames.add(field.getName());
        }
        for (i = 0; i < origRightInputSize; ++i) {
            field = (RelDataTypeField)rightRel.getRowType().getFieldList().get(i);
            newRightFields.add(rexBuilder.makeInputRef(field.getType(), i));
            newRightFieldNames.add(field.getName());
        }
        ImmutableBitSet.Builder origColEqCondsPosBuilder = ImmutableBitSet.builder();
        int newKeyCount = 0;
        ArrayList<Pair> origColEqConds = new ArrayList<Pair>();
        for (i = 0; i < leftKeyCount; ++i) {
            RexNode leftKey = leftJoinKeys.get(i);
            RexNode rightKey = rightJoinKeys.get(i);
            if (leftKey instanceof RexInputRef && rightKey instanceof RexInputRef) {
                origColEqConds.add(Pair.of((Object)((RexInputRef)leftKey).getIndex(), (Object)((RexInputRef)rightKey).getIndex()));
                origColEqCondsPosBuilder.set(i);
                continue;
            }
            newLeftFields.add(leftKey);
            newLeftFieldNames.add(null);
            newRightFields.add(rightKey);
            newRightFieldNames.add(null);
            ++newKeyCount;
        }
        ImmutableBitSet origColEqCondsPos = origColEqCondsPosBuilder.build();
        for (i = 0; i < origColEqConds.size(); ++i) {
            Pair p = (Pair)origColEqConds.get(i);
            int condPos = origColEqCondsPos.nth(i);
            RexNode leftKey = leftJoinKeys.get(condPos);
            RexNode rightKey = rightJoinKeys.get(condPos);
            leftKeys.add((Integer)p.left);
            rightKeys.add((Integer)p.right);
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(leftKey.getType(), systemColCount + (Integer)p.left), rexBuilder.makeInputRef(rightKey.getType(), systemColCount + origLeftInputSize + newKeyCount + (Integer)p.right)});
            outJoinCond = outJoinCond == null ? cond : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{outJoinCond, cond});
        }
        if (newKeyCount == 0) {
            return outJoinCond;
        }
        int newLeftOffset = systemColCount + origLeftInputSize;
        int newRightOffset = systemColCount + origLeftInputSize + origRightInputSize + newKeyCount;
        for (i = 0; i < newKeyCount; ++i) {
            leftKeys.add(origLeftInputSize + i);
            rightKeys.add(origRightInputSize + i);
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(((RexNode)newLeftFields.get(origLeftInputSize + i)).getType(), newLeftOffset + i), rexBuilder.makeInputRef(((RexNode)newRightFields.get(origRightInputSize + i)).getType(), newRightOffset + i)});
            outJoinCond = outJoinCond == null ? cond : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{outJoinCond, cond});
        }
        if (newKeyCount > 0) {
            leftRel = factory.createProject(leftRel, Collections.emptyList(), newLeftFields, SqlValidatorUtil.uniquify(newLeftFieldNames, (boolean)false));
            rightRel = factory.createProject(rightRel, Collections.emptyList(), newRightFields, SqlValidatorUtil.uniquify(newRightFieldNames, (boolean)false));
        }
        inputRels[0] = leftRel;
        inputRels[1] = rightRel;
        return outJoinCond;
    }

    public static List<RexNode> getProjsFromBelowAsInputRef(RelNode rel) {
        return rel.getRowType().getFieldList().stream().map(field -> rel.getCluster().getRexBuilder().makeInputRef(field.getType(), field.getIndex())).collect(Collectors.toList());
    }

    public static boolean pivotResult(String functionName) throws SemanticException {
        WindowFunctionInfo windowInfo = FunctionRegistry.getWindowFunctionInfo(functionName);
        if (windowInfo != null) {
            return windowInfo.isPivotResult();
        }
        return false;
    }

    public static FunctionInfo getFunctionInfo(String funcName) throws SemanticException {
        FunctionInfo res = FunctionRegistry.getFunctionInfo(funcName);
        if (res == null) {
            HiveConf hiveConf;
            SessionState sessionState = SessionState.get();
            HiveConf hiveConf2 = hiveConf = sessionState != null ? sessionState.getConf() : null;
            if (hiveConf != null) {
                try (HiveMetastoreClientWrapper hmsClient = new HiveMetastoreClientWrapper(hiveConf, HiveShimLoader.getHiveVersion());){
                    String[] parts = FunctionUtils.getQualifiedFunctionNameParts(funcName);
                    Function function = hmsClient.getFunction(parts[0], parts[1]);
                    HiveParserUtils.getSessionHiveShim().registerTemporaryFunction(FunctionUtils.qualifyFunctionName(parts[1], parts[0]), Thread.currentThread().getContextClassLoader().loadClass(function.getClassName()));
                    res = FunctionRegistry.getFunctionInfo(funcName);
                }
                catch (NoSuchObjectException e) {
                    LOG.warn("Function {} doesn't exist in metastore", (Object)funcName);
                }
                catch (Exception e) {
                    LOG.warn("Failed to look up function in metastore", (Throwable)e);
                }
            }
        }
        return res;
    }

    public static List<FieldSchema> convertRowSchemaToResultSetSchema(HiveParserRowResolver rr, boolean useTabAliasIfAvailable) {
        ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
        for (ColumnInfo colInfo : rr.getColumnInfos()) {
            if (colInfo.isHiddenVirtualCol()) continue;
            String[] qualifiedColName = rr.reverseLookup(colInfo.getInternalName());
            String colName = useTabAliasIfAvailable && qualifiedColName[0] != null && !qualifiedColName[0].isEmpty() ? qualifiedColName[0] + "." + qualifiedColName[1] : qualifiedColName[1];
            fieldSchemas.add(new FieldSchema(colName, colInfo.getType().getTypeName(), null));
        }
        return fieldSchemas;
    }

    public static void saveViewDefinition(List<FieldSchema> resultSchema, HiveParserCreateViewDesc desc, TokenRewriteStream tokenRewriteStream, HiveParserUnparseTranslator unparseTranslator, HiveConf conf) throws SemanticException {
        int derivedColCount;
        int explicitColCount;
        ArrayList<FieldSchema> derivedSchema = new ArrayList<FieldSchema>(resultSchema);
        ParseUtils.validateColumnNameUniqueness(derivedSchema);
        List<FieldSchema> imposedSchema = desc.getSchema();
        if (imposedSchema != null && (explicitColCount = imposedSchema.size()) != (derivedColCount = derivedSchema.size())) {
            throw new SemanticException(HiveParserUtils.generateErrorMessage(desc.getQuery(), ErrorMsg.VIEW_COL_MISMATCH.getMsg()));
        }
        if (desc.getOriginalText() == null) {
            String originalText = tokenRewriteStream.toString(desc.getQuery().getTokenStartIndex(), desc.getQuery().getTokenStopIndex());
            desc.setOriginalText(originalText);
        }
        unparseTranslator.applyTranslations(tokenRewriteStream);
        String expandedText = tokenRewriteStream.toString(desc.getQuery().getTokenStartIndex(), desc.getQuery().getTokenStopIndex());
        if (imposedSchema != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            int n = derivedSchema.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                FieldSchema fieldSchema = (FieldSchema)derivedSchema.get(i);
                fieldSchema = new FieldSchema(fieldSchema);
                derivedSchema.set(i, fieldSchema);
                sb.append(HiveUtils.unparseIdentifier(fieldSchema.getName(), conf));
                sb.append(" AS ");
                String imposedName = imposedSchema.get(i).getName();
                sb.append(HiveUtils.unparseIdentifier(imposedName, conf));
                fieldSchema.setName(imposedName);
                fieldSchema.setComment(imposedSchema.get(i).getComment());
            }
            sb.append(" FROM (");
            sb.append(expandedText);
            sb.append(") ");
            sb.append(HiveUtils.unparseIdentifier(desc.getCompoundName(), conf));
            expandedText = sb.toString();
        }
        desc.setSchema(derivedSchema);
        if (!desc.isMaterialized()) {
            desc.setExpandedText(expandedText);
        }
    }

    public static HiveShim getSessionHiveShim() {
        return HiveShimLoader.loadHiveShim(SessionState.get().getConf().get(HiveCatalogFactoryOptions.HIVE_VERSION.key()));
    }

    public static String getStandardDisplayString(String name, String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("(");
        if (children.length > 0) {
            sb.append(children[0]);
            for (int i = 1; i < children.length; ++i) {
                sb.append(", ");
                sb.append(children[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static void verifyCanHandleAst(HiveParserASTNode ast, HiveParserQB qb, QueryProperties queryProperties) throws SemanticException {
        boolean noBadTokens;
        int root = ast.getToken().getType();
        boolean isSupportedRoot = root == 880 || root == 754 || qb.isCTAS() || qb.isMaterializedView();
        boolean isSupportedType = qb.getIsQuery() || qb.isCTAS() || qb.isMaterializedView() || !queryProperties.hasMultiDestQuery();
        boolean bl = noBadTokens = !HiveASTParseUtils.containsTokenOfType(ast, 976);
        if (!isSupportedRoot) {
            throw new SemanticException("HiveParser doesn't support the SQL statement due to unsupported AST root type");
        }
        if (!isSupportedType) {
            throw new SemanticException("HiveParser doesn't support the SQL statement due to unsupported query type");
        }
        if (!noBadTokens) {
            throw new SemanticException("HiveParser doesn't support the SQL statement because AST contains unsupported tokens");
        }
        String reason = HiveParserUtils.canHandleQbForCbo(queryProperties);
        if (reason != null) {
            throw new SemanticException("HiveParser doesn't support the SQL statement because it " + reason);
        }
    }

    public static boolean isIdentityProject(RelNode input, List<RexNode> exprs, List<String> aliases) {
        if (exprs.size() == aliases.size() && RexUtil.isIdentity(exprs, (RelDataType)input.getRowType())) {
            for (int i = 0; i < aliases.size(); ++i) {
                String alias = aliases.get(i);
                if (alias == null) continue;
                RexInputRef inputRef = (RexInputRef)exprs.get(i);
                if (((String)input.getRowType().getFieldNames().get(inputRef.getIndex())).equals(alias)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static AggregateCall toAggCall(HiveParserBaseSemanticAnalyzer.AggInfo aggInfo, HiveParserRexNodeConverter converter, Map<String, Integer> rexNodeToPos, int groupCount, RelNode input, RelOptCluster cluster, SqlFunctionConverter funcConverter) throws SemanticException {
        RelDataType aggFnRetType = HiveParserUtils.toRelDataType(aggInfo.getReturnType(), cluster.getTypeFactory());
        ArrayList<Integer> argIndices = new ArrayList<Integer>();
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        ArrayList<RelDataType> calciteArgTypes = new ArrayList<RelDataType>();
        for (ExprNodeDesc expr : aggInfo.getAggParams()) {
            RexNode paramRex = (RexNode)converter.convert(expr).accept((RexVisitor)funcConverter);
            Integer argIndex = (Integer)Preconditions.checkNotNull((Object)rexNodeToPos.get(paramRex.toString()));
            argIndices.add(argIndex);
            calciteArgTypes.add(HiveParserUtils.toRelDataType(expr.getTypeInfo(), typeFactory));
        }
        SqlAggFunction aggFunc = HiveParserSqlFunctionConverter.getCalciteAggFn(aggInfo.getUdfName(), aggInfo.isDistinct(), calciteArgTypes, aggFnRetType);
        RelDataType type = null;
        if (aggInfo.isAllColumns() && argIndices.isEmpty()) {
            type = aggFnRetType;
        }
        return AggregateCall.create((SqlAggFunction)((SqlAggFunction)funcConverter.convertOperator((SqlOperator)aggFunc)), (boolean)aggInfo.isDistinct(), (boolean)false, (boolean)false, argIndices, (int)-1, (RelCollation)RelCollations.EMPTY, (int)groupCount, (RelNode)input, (RelDataType)type, (String)aggInfo.getAlias());
    }

    private static String getText(HiveParserASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getText();
        }
        return HiveParserUtils.getText((HiveParserASTNode)tree.getChild(tree.getChildCount() - 1));
    }

    private static class HiveParserOperatorBinding
    extends ExplicitOperatorBinding {
        private final List<RexNode> operands;

        public HiveParserOperatorBinding(RelDataTypeFactory typeFactory, SqlOperator operator, List<RelDataType> types, List<RexNode> operands) {
            super(typeFactory, operator, types);
            this.operands = (List)Preconditions.checkNotNull(operands, (String)"Operands cannot be null");
            Preconditions.checkArgument((types.size() == operands.size() ? 1 : 0) != 0, (Object)String.format("Type length %d and operand length %d mismatch", types.size(), operands.size()));
        }

        public String getStringLiteralOperand(int ordinal) {
            return RexLiteral.stringValue((RexNode)this.operands.get(ordinal));
        }

        public int getIntLiteralOperand(int ordinal) {
            return RexLiteral.intValue((RexNode)this.operands.get(ordinal));
        }

        public <T> T getOperandLiteralValue(int ordinal, Class<T> clazz) {
            RexNode operand = this.operands.get(ordinal);
            if (operand instanceof RexLiteral) {
                return (T)((RexLiteral)operand).getValueAs(clazz);
            }
            throw new AssertionError((Object)("not a literal: " + operand));
        }

        public boolean isOperandLiteral(int ordinal, boolean allowCast) {
            RexNode operand = this.operands.get(ordinal);
            return operand != null && RexUtil.isLiteral((RexNode)operand, (boolean)false);
        }

        public boolean isOperandNull(int ordinal, boolean allowCast) {
            RexNode operand = this.operands.get(ordinal);
            return operand != null && RexUtil.isNullLiteral((RexNode)operand, (boolean)false);
        }

        public Object[] getConstantOperands() {
            Object[] res = new Object[this.operands.size()];
            for (int i = 0; i < res.length; ++i) {
                if (!this.isOperandLiteral(i, false)) continue;
                res[i] = this.getOperandLiteralValue(i, ClassLogicalTypeConverter.getDefaultExternalClassForType((LogicalType)FlinkTypeFactory.toLogicalType((RelDataType)this.getOperandType(i))));
            }
            return res;
        }
    }

    public static class CorrelationCollector
    extends RexVisitorImpl<Void> {
        private final List<CorrelationId> correlIDs;
        private final ImmutableBitSet.Builder requiredColumns;

        public CorrelationCollector(List<CorrelationId> correlIDs, ImmutableBitSet.Builder requiredColumns) {
            super(true);
            this.correlIDs = correlIDs;
            this.requiredColumns = requiredColumns;
        }

        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode expr = fieldAccess.getReferenceExpr();
            if (expr instanceof RexCorrelVariable) {
                this.requiredColumns.set(fieldAccess.getField().getIndex());
            }
            return (Void)super.visitFieldAccess(fieldAccess);
        }

        public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
            this.correlIDs.add(correlVariable.id);
            return null;
        }
    }

    public static class LateralViewInfo {
        private final String funcName;
        private final SqlOperator sqlOperator;
        private final List<ExprNodeDesc> operands;
        private final List<ColumnInfo> operandColInfos;
        private final List<String> colAliases;
        private final String tabAlias;

        public LateralViewInfo(String funcName, SqlOperator sqlOperator, List<ExprNodeDesc> operands, List<ColumnInfo> operandColInfos, List<String> colAliases, String tabAlias) {
            this.funcName = funcName;
            this.sqlOperator = sqlOperator;
            this.operands = operands;
            this.operandColInfos = operandColInfos;
            this.colAliases = colAliases;
            this.tabAlias = tabAlias;
        }

        public String getFuncName() {
            return this.funcName;
        }

        public SqlOperator getSqlOperator() {
            return this.sqlOperator;
        }

        public List<ExprNodeDesc> getOperands() {
            return this.operands;
        }

        public List<ColumnInfo> getOperandColInfos() {
            return this.operandColInfos;
        }

        public List<String> getColAliases() {
            return this.colAliases;
        }

        public String getTabAlias() {
            return this.tabAlias;
        }
    }
}

