/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveDatabase;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.factories.HiveFunctionDefinitionFactory;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowPartitionsOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.ShowViewsOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.ddl.AddPartitionsOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterPartitionPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterTableOptionsOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.AlterTableSchemaOperation;
import org.apache.flink.table.operations.ddl.AlterViewAsOperation;
import org.apache.flink.table.operations.ddl.AlterViewPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterViewRenameOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropPartitionsOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropViewOperation;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserStorageFormat;
import org.apache.flink.table.planner.delegation.hive.desc.DropPartitionDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserAlterDatabaseDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserAlterTableDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserCreateTableDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserCreateViewDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserDropDatabaseDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserDropFunctionDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserDropTableDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserShowTablesDesc;
import org.apache.flink.table.planner.utils.OperationConverterUtils;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class DDLOperationConverter {
    private final Parser parser;
    private final CatalogManager catalogManager;
    private final HiveFunctionDefinitionFactory funcDefFactory;

    public DDLOperationConverter(Parser parser, CatalogManager catalogManager, HiveShim hiveShim) {
        this.parser = parser;
        this.catalogManager = catalogManager;
        this.funcDefFactory = new HiveFunctionDefinitionFactory(hiveShim);
    }

    public Operation convert(Serializable work) {
        if (work instanceof DDLWork) {
            DDLWork ddlWork = (DDLWork)work;
            if (ddlWork.getCreateDatabaseDesc() != null) {
                return this.convertCreateDatabase(ddlWork.getCreateDatabaseDesc());
            }
            if (ddlWork.getShowDatabasesDesc() != null) {
                return this.convertShowDatabases(ddlWork.getShowDatabasesDesc());
            }
            if (ddlWork.getSwitchDatabaseDesc() != null) {
                return this.convertUseDatabase(ddlWork.getSwitchDatabaseDesc());
            }
            if (ddlWork.getAddPartitionDesc() != null) {
                return this.convertAddPartitions(ddlWork.getAddPartitionDesc());
            }
            if (ddlWork.getShowPartsDesc() != null) {
                return this.convertShowPartitions(ddlWork.getShowPartsDesc());
            }
            if (ddlWork.getShowFuncsDesc() != null) {
                return this.convertShowFunctions(ddlWork.getShowFuncsDesc());
            }
            if (ddlWork.getDescTblDesc() != null) {
                return this.convertDescTable(ddlWork.getDescTblDesc());
            }
            throw new FlinkHiveException("Unsupported DDLWork");
        }
        if (work instanceof HiveParserShowTablesDesc) {
            if (((HiveParserShowTablesDesc)work).isExpectView()) {
                return this.convertShowViews((HiveParserShowTablesDesc)work);
            }
            return this.convertShowTables((HiveParserShowTablesDesc)work);
        }
        if (work instanceof HiveParserAlterTableDesc) {
            HiveParserAlterTableDesc alterTableDesc = (HiveParserAlterTableDesc)work;
            if (alterTableDesc.expectView()) {
                return this.convertAlterView(alterTableDesc);
            }
            return this.convertAlterTable(alterTableDesc);
        }
        if (work instanceof HiveParserCreateTableDesc) {
            return this.convertCreateTable((HiveParserCreateTableDesc)work);
        }
        if (work instanceof HiveParserDropTableDesc) {
            HiveParserDropTableDesc dropTableDesc = (HiveParserDropTableDesc)work;
            if (dropTableDesc.isExpectView()) {
                return this.convertDropView(dropTableDesc);
            }
            return this.convertDropTable(dropTableDesc);
        }
        if (work instanceof DropPartitionDesc) {
            return this.convertDropPartitions((DropPartitionDesc)work);
        }
        if (work instanceof HiveParserCreateViewDesc) {
            return this.convertCreateAlterView((HiveParserCreateViewDesc)work);
        }
        if (work instanceof HiveParserDropFunctionDesc) {
            return this.convertDropFunction((HiveParserDropFunctionDesc)work);
        }
        if (work instanceof FunctionWork) {
            FunctionWork functionWork = (FunctionWork)work;
            if (functionWork.getCreateFunctionDesc() != null) {
                return this.convertCreateFunction(functionWork.getCreateFunctionDesc());
            }
            throw new FlinkHiveException("Unsupported FunctionWork");
        }
        if (work instanceof HiveParserAlterDatabaseDesc) {
            return this.convertAlterDatabase((HiveParserAlterDatabaseDesc)work);
        }
        if (work instanceof HiveParserDropDatabaseDesc) {
            return this.convertDropDatabase((HiveParserDropDatabaseDesc)work);
        }
        throw new FlinkHiveException("Unsupported work class " + work.getClass().getName());
    }

    private Operation convertDescTable(DescTableDesc desc) {
        ObjectIdentifier tableIdentifier = this.parseObjectIdentifier(desc.getTableName());
        return new DescribeTableOperation(tableIdentifier, desc.isExt() || desc.isFormatted());
    }

    private Operation convertShowFunctions(ShowFunctionsDesc desc) {
        return new ShowFunctionsOperation();
    }

    private Operation convertShowPartitions(ShowPartitionsDesc desc) {
        ObjectIdentifier tableIdentifier = this.parseObjectIdentifier(desc.getTabName());
        CatalogPartitionSpec spec = null;
        if (desc.getPartSpec() != null && !desc.getPartSpec().isEmpty()) {
            spec = new CatalogPartitionSpec(new HashMap<String, String>(desc.getPartSpec()));
        }
        return new ShowPartitionsOperation(tableIdentifier, spec);
    }

    private Operation convertCreateFunction(CreateFunctionDesc desc) {
        if (desc.isTemp()) {
            FunctionDefinition funcDefinition = this.funcDefFactory.createFunctionDefinition(desc.getFunctionName(), (CatalogFunction)new CatalogFunctionImpl(desc.getClassName(), FunctionLanguage.JAVA));
            return new CreateTempSystemFunctionOperation(desc.getFunctionName(), false, funcDefinition);
        }
        ObjectIdentifier identifier = this.parseObjectIdentifier(desc.getFunctionName());
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(desc.getClassName(), FunctionLanguage.JAVA);
        return new CreateCatalogFunctionOperation(identifier, (CatalogFunction)catalogFunction, false, desc.isTemp());
    }

    private Operation convertDropFunction(HiveParserDropFunctionDesc desc) {
        if (desc.getDesc().isTemp()) {
            return new DropTempSystemFunctionOperation(desc.getDesc().getFunctionName(), desc.ifExists());
        }
        ObjectIdentifier identifier = this.parseObjectIdentifier(desc.getDesc().getFunctionName());
        return new DropCatalogFunctionOperation(identifier, desc.ifExists(), desc.getDesc().isTemp());
    }

    private Operation convertDropView(HiveParserDropTableDesc desc) {
        ObjectIdentifier identifier = this.parseObjectIdentifier(desc.getCompoundName());
        CatalogBaseTable baseTable = this.getCatalogBaseTable(identifier, true);
        if (baseTable instanceof CatalogTable) {
            throw new ValidationException("DROP VIEW for a table is not allowed");
        }
        return new DropViewOperation(identifier, desc.ifExists(), false);
    }

    private Operation convertDropTable(HiveParserDropTableDesc desc) {
        ObjectIdentifier identifier = this.parseObjectIdentifier(desc.getCompoundName());
        CatalogBaseTable baseTable = this.getCatalogBaseTable(identifier, true);
        if (baseTable instanceof CatalogView) {
            throw new ValidationException("DROP TABLE for a view is not allowed");
        }
        return new DropTableOperation(identifier, desc.ifExists(), false);
    }

    private Operation convertCreateAlterView(HiveParserCreateViewDesc desc) {
        String comment;
        ObjectIdentifier viewIdentifier = this.parseObjectIdentifier(desc.getCompoundName());
        TableSchema schema = HiveTableUtil.createTableSchema(desc.getSchema(), Collections.emptyList(), Collections.emptySet(), null);
        HashMap<String, String> props = new HashMap<String, String>();
        if (desc.isAlterViewAs()) {
            CatalogBaseTable baseTable = this.getCatalogBaseTable(viewIdentifier);
            if (baseTable instanceof CatalogTable) {
                throw new ValidationException("ALTER VIEW for a table is not allowed");
            }
            props.putAll(baseTable.getOptions());
            comment = baseTable.getComment();
        } else {
            this.markHiveConnector(props);
            comment = desc.getComment();
            if (desc.getTblProps() != null) {
                props.putAll(desc.getTblProps());
            }
        }
        CatalogViewImpl catalogView = new CatalogViewImpl(desc.getOriginalText(), desc.getExpandedText(), schema, props, comment);
        if (desc.isAlterViewAs()) {
            return new AlterViewAsOperation(viewIdentifier, (CatalogView)catalogView);
        }
        return new CreateViewOperation(viewIdentifier, (CatalogView)catalogView, desc.ifNotExists(), false);
    }

    private Operation convertDropPartitions(DropPartitionDesc desc) {
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{desc.getDbName(), desc.getTableName()}));
        CatalogBaseTable catalogBaseTable = this.getCatalogBaseTable(tableIdentifier);
        if (catalogBaseTable instanceof CatalogView) {
            throw new ValidationException("DROP PARTITION for a view is not supported");
        }
        List specs = desc.getSpecs().stream().map(CatalogPartitionSpec::new).collect(Collectors.toList());
        return new DropPartitionsOperation(tableIdentifier, desc.ifExists(), specs);
    }

    private Operation convertAddPartitions(AddPartitionDesc desc) {
        ObjectIdentifier tableIdentifier = desc.getDbName() == null ? this.parseObjectIdentifier(desc.getTableName()) : this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{desc.getDbName(), desc.getTableName()}));
        CatalogBaseTable catalogBaseTable = this.getCatalogBaseTable(tableIdentifier);
        if (catalogBaseTable instanceof CatalogView) {
            throw new ValidationException("ADD PARTITION for a view is not supported");
        }
        ArrayList<CatalogPartitionSpec> specs = new ArrayList<CatalogPartitionSpec>();
        ArrayList<CatalogPartitionImpl> partitions = new ArrayList<CatalogPartitionImpl>();
        for (int i = 0; i < desc.getPartitionCount(); ++i) {
            specs.add(new CatalogPartitionSpec(desc.getPartition(i).getPartSpec()));
            HashMap<String, String> props = new HashMap<String, String>();
            String location = desc.getPartition(i).getLocation();
            if (location != null) {
                props.put("hive.location-uri", location);
            }
            partitions.add(new CatalogPartitionImpl(props, null));
        }
        return new AddPartitionsOperation(tableIdentifier, desc.isIfNotExists(), specs, partitions);
    }

    private Operation convertCreateTable(HiveParserCreateTableDesc desc) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (desc.getTblProps() != null) {
            props.putAll(desc.getTblProps());
        }
        this.markHiveConnector(props);
        if (desc.isExternal()) {
            props.put("hive.is-external", "true");
        }
        UniqueConstraint uniqueConstraint = null;
        if (desc.getPrimaryKeys() != null && !desc.getPrimaryKeys().isEmpty()) {
            HiveParserCreateTableDesc.PrimaryKey primaryKey = desc.getPrimaryKeys().get(0);
            byte trait = 0;
            if (primaryKey.isEnable()) {
                trait = HiveDDLUtils.enableConstraint((byte)trait);
            }
            if (primaryKey.isValidate()) {
                trait = HiveDDLUtils.validateConstraint((byte)trait);
            }
            if (primaryKey.isRely()) {
                trait = HiveDDLUtils.relyConstraint((byte)trait);
            }
            props.put("hive.pk.constraint.trait", String.valueOf(trait));
            List pkCols = desc.getPrimaryKeys().stream().map(HiveParserCreateTableDesc.PrimaryKey::getPk).collect(Collectors.toList());
            String constraintName = primaryKey.getConstraintName();
            if (constraintName == null) {
                constraintName = pkCols.stream().collect(Collectors.joining("_", "PK_", ""));
            }
            uniqueConstraint = UniqueConstraint.primaryKey((String)constraintName, (List)pkCols);
        }
        ArrayList<String> notNullCols = new ArrayList<String>();
        if (!desc.getNotNullConstraints().isEmpty()) {
            ArrayList<String> traits = new ArrayList<String>();
            for (HiveParserCreateTableDesc.NotNullConstraint notNull : desc.getNotNullConstraints()) {
                byte trait = 0;
                if (notNull.isEnable()) {
                    trait = HiveDDLUtils.enableConstraint((byte)trait);
                }
                if (notNull.isValidate()) {
                    trait = HiveDDLUtils.validateConstraint((byte)trait);
                }
                if (notNull.isRely()) {
                    trait = HiveDDLUtils.relyConstraint((byte)trait);
                }
                traits.add(String.valueOf(trait));
                notNullCols.add(notNull.getColName());
            }
            props.put("hive.not.null.constraint.traits", String.join((CharSequence)";", traits));
            props.put("hive.not.null.cols", String.join((CharSequence)";", notNullCols));
        }
        if (desc.getRowFormatParams() != null) {
            this.encodeRowFormat(desc.getRowFormatParams(), props);
        }
        if (desc.getStorageFormat() != null) {
            this.encodeStorageFormat(desc.getStorageFormat(), props);
        }
        if (desc.getLocation() != null) {
            props.put("hive.location-uri", desc.getLocation());
        }
        ObjectIdentifier identifier = this.parseObjectIdentifier(desc.getCompoundName());
        HashSet<String> notNullColSet = new HashSet<String>(notNullCols);
        if (uniqueConstraint != null) {
            notNullColSet.addAll(uniqueConstraint.getColumns());
        }
        TableSchema tableSchema = HiveTableUtil.createTableSchema(desc.getCols(), desc.getPartCols(), notNullColSet, uniqueConstraint);
        return new CreateTableOperation(identifier, (CatalogTable)new CatalogTableImpl(tableSchema, HiveCatalog.getFieldNames(desc.getPartCols()), props, desc.getComment()), desc.ifNotExists(), desc.isTemporary());
    }

    private Operation convertAlterView(HiveParserAlterTableDesc desc) {
        ObjectIdentifier viewIdentifier = this.parseObjectIdentifier(desc.getCompoundName());
        CatalogBaseTable baseTable = this.getCatalogBaseTable(viewIdentifier);
        if (baseTable instanceof CatalogTable) {
            throw new ValidationException("ALTER VIEW for a table is not allowed");
        }
        CatalogView oldView = (CatalogView)baseTable;
        switch (desc.getOp()) {
            case RENAME: {
                return new AlterViewRenameOperation(viewIdentifier, this.parseObjectIdentifier(desc.getNewName()));
            }
            case ADDPROPS: {
                HashMap<String, String> props = new HashMap<String, String>(oldView.getOptions());
                props.putAll(desc.getProps());
                CatalogViewImpl newView = new CatalogViewImpl(oldView.getOriginalQuery(), oldView.getExpandedQuery(), oldView.getSchema(), props, oldView.getComment());
                return new AlterViewPropertiesOperation(viewIdentifier, (CatalogView)newView);
            }
        }
        throw new FlinkHiveException("Unsupported alter view operation " + (Object)((Object)desc.getOp()));
    }

    private Operation convertAlterTable(HiveParserAlterTableDesc desc) {
        ObjectIdentifier tableIdentifier = this.parseObjectIdentifier(desc.getCompoundName());
        CatalogBaseTable catalogBaseTable = this.getCatalogBaseTable(tableIdentifier);
        if (catalogBaseTable instanceof CatalogView) {
            throw new ValidationException("ALTER TABLE for a view is not allowed");
        }
        CatalogTable oldTable = (CatalogTable)catalogBaseTable;
        CatalogPartitionSpec partSpec = desc.getPartSpec() != null ? new CatalogPartitionSpec(desc.getPartSpec()) : null;
        CatalogPartition catalogPartition = partSpec != null ? this.getPartition(tableIdentifier, partSpec) : null;
        HashMap<String, String> newProps = new HashMap<String, String>();
        switch (desc.getOp()) {
            case RENAME: {
                return new AlterTableRenameOperation(tableIdentifier, this.parseObjectIdentifier(desc.getNewName()));
            }
            case ADDPROPS: {
                newProps.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_TBL_PROPS.name());
                newProps.putAll(desc.getProps());
                return this.convertAlterTableProps(tableIdentifier, oldTable, partSpec, catalogPartition, newProps);
            }
            case ALTERLOCATION: {
                newProps.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_LOCATION.name());
                newProps.put("hive.location-uri", desc.getNewLocation());
                return this.convertAlterTableProps(tableIdentifier, oldTable, partSpec, catalogPartition, newProps);
            }
            case ADDFILEFORMAT: {
                newProps.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_FILE_FORMAT.name());
                newProps.put("hive.storage.file-format", desc.getGenericFileFormatName());
                return this.convertAlterTableProps(tableIdentifier, oldTable, partSpec, catalogPartition, newProps);
            }
            case ADDSERDE: 
            case ADDSERDEPROPS: {
                newProps.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_SERDE_PROPS.name());
                if (desc.getSerdeName() != null) {
                    newProps.put("hive.serde.lib.class.name", desc.getSerdeName());
                }
                if (desc.getProps() != null) {
                    for (String key : desc.getProps().keySet()) {
                        newProps.put("hive.serde.info.prop." + key, desc.getProps().get(key));
                    }
                }
                return this.convertAlterTableProps(tableIdentifier, oldTable, partSpec, catalogPartition, newProps);
            }
            case REPLACECOLS: {
                return this.convertAddReplaceColumns(tableIdentifier, oldTable, desc.getNewCols(), true, desc.isCascade());
            }
            case ADDCOLS: {
                return this.convertAddReplaceColumns(tableIdentifier, oldTable, desc.getNewCols(), false, desc.isCascade());
            }
            case RENAMECOLUMN: {
                return this.convertChangeColumn(tableIdentifier, oldTable, desc.getOldColName(), desc.getNewColName(), desc.getNewColType(), desc.getNewColComment(), desc.getAfter(), desc.isFirst(), desc.isCascade());
            }
        }
        throw new FlinkHiveException("Unsupported alter table operation " + (Object)((Object)desc.getOp()));
    }

    private Operation convertChangeColumn(ObjectIdentifier tableIdentifier, CatalogTable oldTable, String oldName, String newName, String newType, String newComment, String after, boolean first, boolean cascade) {
        if (oldTable.getPartitionKeys().contains(oldName)) {
            throw new ValidationException("CHANGE COLUMN cannot be applied to partition columns");
        }
        TableSchema oldSchema = oldTable.getSchema();
        TableColumn.PhysicalColumn newTableColumn = TableColumn.physical((String)newName, (DataType)HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString(newType)));
        TableSchema newSchema = OperationConverterUtils.changeColumn((TableSchema)oldSchema, (String)oldName, (TableColumn)newTableColumn, (boolean)first, (String)after);
        HashMap<String, String> props = new HashMap<String, String>(oldTable.getOptions());
        props.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.ALTER_COLUMNS.name());
        if (cascade) {
            props.put("alter.column.cascade", "true");
        }
        return new AlterTableSchemaOperation(tableIdentifier, (CatalogTable)new CatalogTableImpl(newSchema, oldTable.getPartitionKeys(), props, oldTable.getComment()));
    }

    private Operation convertAddReplaceColumns(ObjectIdentifier tableIdentifier, CatalogTable oldTable, List<FieldSchema> newCols, boolean replace, boolean cascade) {
        HashMap<String, String> props = new HashMap<String, String>(oldTable.getOptions());
        props.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.ALTER_COLUMNS.name());
        if (cascade) {
            props.put("alter.column.cascade", "true");
        }
        TableSchema oldSchema = oldTable.getSchema();
        int numPartCol = oldTable.getPartitionKeys().size();
        TableSchema.Builder builder = TableSchema.builder();
        if (!replace) {
            List nonPartCols = oldSchema.getTableColumns().subList(0, oldSchema.getFieldCount() - numPartCol);
            Iterator iterator = nonPartCols.iterator();
            while (iterator.hasNext()) {
                TableColumn column = (TableColumn)iterator.next();
                builder.add(column);
            }
            DDLOperationConverter.setWatermarkAndPK(builder, oldSchema);
        }
        for (FieldSchema col : newCols) {
            builder.add((TableColumn)TableColumn.physical((String)col.getName(), (DataType)HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString(col.getType()))));
        }
        List partCols = oldSchema.getTableColumns().subList(oldSchema.getFieldCount() - numPartCol, oldSchema.getFieldCount());
        for (TableColumn column : partCols) {
            builder.add(column);
        }
        return new AlterTableSchemaOperation(tableIdentifier, (CatalogTable)new CatalogTableImpl(builder.build(), oldTable.getPartitionKeys(), props, oldTable.getComment()));
    }

    private Operation convertAlterTableProps(ObjectIdentifier tableIdentifier, CatalogTable oldTable, CatalogPartitionSpec partSpec, CatalogPartition catalogPartition, Map<String, String> newProps) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (catalogPartition != null) {
            props.putAll(catalogPartition.getProperties());
            props.putAll(newProps);
            return new AlterPartitionPropertiesOperation(tableIdentifier, partSpec, (CatalogPartition)new CatalogPartitionImpl(props, catalogPartition.getComment()));
        }
        props.putAll(oldTable.getOptions());
        props.putAll(newProps);
        return new AlterTableOptionsOperation(tableIdentifier, oldTable.copy(props));
    }

    private Operation convertShowViews(HiveParserShowTablesDesc desc) {
        return new ShowViewsOperation();
    }

    private Operation convertShowTables(HiveParserShowTablesDesc desc) {
        return new ShowTablesOperation();
    }

    private Operation convertUseDatabase(SwitchDatabaseDesc desc) {
        return new UseDatabaseOperation(this.catalogManager.getCurrentCatalog(), desc.getDatabaseName());
    }

    private Operation convertShowDatabases(ShowDatabasesDesc desc) {
        return new ShowDatabasesOperation();
    }

    private Operation convertDropDatabase(HiveParserDropDatabaseDesc desc) {
        return new DropDatabaseOperation(this.catalogManager.getCurrentCatalog(), desc.getDatabaseName(), desc.ifExists(), desc.cascade());
    }

    private Operation convertAlterDatabase(HiveParserAlterDatabaseDesc desc) {
        CatalogDatabase originDB;
        Catalog catalog = (Catalog)this.catalogManager.getCatalog(this.catalogManager.getCurrentCatalog()).get();
        try {
            originDB = catalog.getDatabase(desc.getDatabaseName());
        }
        catch (DatabaseNotExistException e) {
            throw new ValidationException(String.format("Database %s not exists", desc.getDatabaseName()), (Throwable)e);
        }
        HashMap<String, String> props = new HashMap<String, String>(originDB.getProperties());
        switch (desc.getAlterType()) {
            case ALTER_PROPERTY: {
                props.put("hive.alter.database.op", SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_PROPS.name());
                props.putAll(desc.getDbProperties());
                break;
            }
            case ALTER_OWNER: {
                props.put("hive.alter.database.op", SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_OWNER.name());
                PrincipalDesc principalDesc = desc.getOwnerPrincipal();
                props.put("hive.database.owner.name", principalDesc.getName());
                props.put("hive.database.owner.type", principalDesc.getType().name().toLowerCase());
                break;
            }
            case ALTER_LOCATION: {
                props.put("hive.alter.database.op", SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_LOCATION.name());
                props.put("hive.database.location-uri", desc.getLocation());
                break;
            }
            default: {
                throw new FlinkHiveException("Unsupported alter database operation");
            }
        }
        CatalogDatabaseImpl newDB = new CatalogDatabaseImpl(props, originDB.getComment());
        return new AlterDatabaseOperation(this.catalogManager.getCurrentCatalog(), desc.getDatabaseName(), (CatalogDatabase)newDB);
    }

    private Operation convertCreateDatabase(CreateDatabaseDesc desc) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (desc.getDatabaseProperties() != null) {
            props.putAll(desc.getDatabaseProperties());
        }
        if (desc.getLocationUri() != null) {
            props.put("hive.database.location-uri", desc.getLocationUri());
        }
        CatalogDatabaseImpl catalogDatabase = new CatalogDatabaseImpl(props, desc.getComment());
        return new CreateDatabaseOperation(this.catalogManager.getCurrentCatalog(), desc.getName(), (CatalogDatabase)catalogDatabase, desc.getIfNotExists());
    }

    private void markHiveConnector(Map<String, String> props) {
        props.put(FactoryUtil.CONNECTOR.key(), "hive");
    }

    private CatalogBaseTable getCatalogBaseTable(ObjectIdentifier tableIdentifier) {
        return this.getCatalogBaseTable(tableIdentifier, false);
    }

    private CatalogBaseTable getCatalogBaseTable(ObjectIdentifier tableIdentifier, boolean ifExists) {
        Optional optionalCatalogTable = this.catalogManager.getTable(tableIdentifier);
        if (!optionalCatalogTable.isPresent()) {
            if (ifExists) {
                return null;
            }
            throw new ValidationException(String.format("Table or View %s doesn't exist.", tableIdentifier.toString()));
        }
        if (((CatalogManager.TableLookupResult)optionalCatalogTable.get()).isTemporary()) {
            throw new ValidationException(String.format("Table or View %s is temporary.", tableIdentifier.toString()));
        }
        return ((CatalogManager.TableLookupResult)optionalCatalogTable.get()).getTable();
    }

    private CatalogPartition getPartition(ObjectIdentifier tableIdentifier, CatalogPartitionSpec partitionSpec) {
        return (CatalogPartition)this.catalogManager.getPartition(tableIdentifier, partitionSpec).orElseThrow(() -> new ValidationException(String.format("Partition %s of table %s doesn't exist", partitionSpec.getPartitionSpec(), tableIdentifier)));
    }

    private ObjectIdentifier parseObjectIdentifier(String compoundName) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(compoundName);
        return this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
    }

    private void encodeRowFormat(HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams rowFormatParams, Map<String, String> props) {
        if (rowFormatParams.getFieldDelim() != null) {
            props.put("hive.serde.info.prop.field.delim", rowFormatParams.getFieldDelim());
        }
        if (rowFormatParams.getCollItemDelim() != null) {
            props.put("hive.serde.info.prop.collection.delim", rowFormatParams.getCollItemDelim());
        }
        if (rowFormatParams.getMapKeyDelim() != null) {
            props.put("hive.serde.info.prop.mapkey.delim", rowFormatParams.getMapKeyDelim());
        }
        if (rowFormatParams.getFieldEscape() != null) {
            props.put("hive.serde.info.prop.escape.delim", rowFormatParams.getFieldEscape());
        }
        if (rowFormatParams.getLineDelim() != null) {
            props.put("hive.serde.info.prop.line.delim", rowFormatParams.getLineDelim());
        }
        if (rowFormatParams.getNullFormat() != null) {
            props.put("hive.serde.info.prop.serialization.null.format", rowFormatParams.getNullFormat());
        }
    }

    private void encodeStorageFormat(HiveParserStorageFormat storageFormat, Map<String, String> props) {
        Map<String, String> serdeProps;
        String serdeName = storageFormat.getSerde();
        if (serdeName != null) {
            props.put("hive.serde.lib.class.name", serdeName);
        }
        if ((serdeProps = storageFormat.getSerdeProps()) != null) {
            for (String serdeKey : serdeProps.keySet()) {
                props.put("hive.serde.info.prop." + serdeKey, serdeProps.get(serdeKey));
            }
        }
        if (storageFormat.getInputFormat() != null) {
            props.put("hive.stored.as.input.format", storageFormat.getInputFormat());
        }
        if (storageFormat.getOutputFormat() != null) {
            props.put("hive.stored.as.output.format", storageFormat.getOutputFormat());
        }
    }

    private static void setWatermarkAndPK(TableSchema.Builder builder, TableSchema schema) {
        for (WatermarkSpec watermarkSpec : schema.getWatermarkSpecs()) {
            builder.watermark(watermarkSpec);
        }
        schema.getPrimaryKey().ifPresent(pk -> builder.primaryKey(pk.getName(), pk.getColumns().toArray(new String[0])));
    }
}

