/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive.util;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public class HiveFunctionUtil {
    public static boolean isSingleBoxedArray(DataType[] argTypes) {
        for (DataType dataType : argTypes) {
            if (!HiveFunctionUtil.isPrimitiveArray(dataType)) continue;
            throw new FlinkHiveUDFException("Flink doesn't support primitive array for Hive functions yet.");
        }
        return argTypes.length == 1 && HiveFunctionUtil.isArrayType(argTypes[0]);
    }

    private static boolean isPrimitiveArray(DataType dataType) {
        if (HiveFunctionUtil.isArrayType(dataType)) {
            ArrayType arrayType = (ArrayType)dataType.getLogicalType();
            LogicalType elementType = arrayType.getElementType();
            return !elementType.isNullable() && HiveFunctionUtil.isPrimitive(elementType);
        }
        return false;
    }

    private static boolean isPrimitive(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    private static boolean isArrayType(DataType dataType) {
        return dataType.getLogicalType().getTypeRoot().equals((Object)LogicalTypeRoot.ARRAY);
    }
}

