/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.hadoop.hive.ql.exec.UDF;

@Internal
public class HiveFunctionWrapper<UDFType>
implements Serializable {
    public static final long serialVersionUID = 393313529306818205L;
    private final String className;
    private transient UDFType instance = null;

    public HiveFunctionWrapper(String className) {
        this.className = className;
    }

    public UDFType createFunction() {
        if (this.instance != null) {
            return this.instance;
        }
        UDFType func = null;
        try {
            func = this.getUDFClass().newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new FlinkHiveUDFException(String.format("Failed to create function from %s", this.className), e);
        }
        if (!(func instanceof UDF)) {
            this.instance = func;
        }
        return func;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<UDFType> getUDFClass() throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(this.className);
    }
}

