/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.factories;

import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.connectors.hive.HiveTableFactory;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.factories.FunctionDefinitionFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.HiveGenericUDAF;
import org.apache.flink.table.functions.hive.HiveGenericUDF;
import org.apache.flink.table.functions.hive.HiveGenericUDTF;
import org.apache.flink.table.functions.hive.HiveSimpleUDF;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveFunctionDefinitionFactory
implements FunctionDefinitionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableFactory.class);
    private final HiveShim hiveShim;

    public HiveFunctionDefinitionFactory(HiveShim hiveShim) {
        Preconditions.checkNotNull((Object)hiveShim, (String)"hiveShim cannot be null");
        this.hiveShim = hiveShim;
    }

    public FunctionDefinition createFunctionDefinition(String name, CatalogFunction catalogFunction) {
        if (catalogFunction.isGeneric()) {
            return this.createFunctionDefinitionFromFlinkFunction(name, catalogFunction);
        }
        return this.createFunctionDefinitionFromHiveFunction(name, catalogFunction.getClassName());
    }

    public FunctionDefinition createFunctionDefinitionFromFlinkFunction(String name, CatalogFunction catalogFunction) {
        return UserDefinedFunctionHelper.instantiateFunction((ClassLoader)Thread.currentThread().getContextClassLoader(), null, (String)name, (CatalogFunction)catalogFunction);
    }

    public FunctionDefinition createFunctionDefinitionFromHiveFunction(String name, String functionClassName) {
        Class<?> clazz;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(functionClassName);
            LOG.info("Successfully loaded Hive udf '{}' with class '{}'", (Object)name, (Object)functionClassName);
        }
        catch (ClassNotFoundException e) {
            throw new TableException(String.format("Failed to initiate an instance of class %s.", functionClassName), (Throwable)e);
        }
        if (UDF.class.isAssignableFrom(clazz)) {
            LOG.info("Transforming Hive function '{}' into a HiveSimpleUDF", (Object)name);
            return new HiveSimpleUDF(new HiveFunctionWrapper<UDF>(functionClassName), this.hiveShim);
        }
        if (GenericUDF.class.isAssignableFrom(clazz)) {
            LOG.info("Transforming Hive function '{}' into a HiveGenericUDF", (Object)name);
            return new HiveGenericUDF(new HiveFunctionWrapper<GenericUDF>(functionClassName), this.hiveShim);
        }
        if (GenericUDTF.class.isAssignableFrom(clazz)) {
            LOG.info("Transforming Hive function '{}' into a HiveGenericUDTF", (Object)name);
            HiveGenericUDTF udtf = new HiveGenericUDTF(new HiveFunctionWrapper<GenericUDTF>(functionClassName), this.hiveShim);
            return new TableFunctionDefinition(name, (TableFunction)udtf, GenericTypeInfo.of(Row.class));
        }
        if (GenericUDAFResolver2.class.isAssignableFrom(clazz) || UDAF.class.isAssignableFrom(clazz)) {
            HiveGenericUDAF udaf;
            if (GenericUDAFResolver2.class.isAssignableFrom(clazz)) {
                LOG.info("Transforming Hive function '{}' into a HiveGenericUDAF without UDAF bridging", (Object)name);
                udaf = new HiveGenericUDAF(new HiveFunctionWrapper(functionClassName), false, this.hiveShim);
            } else {
                LOG.info("Transforming Hive function '{}' into a HiveGenericUDAF with UDAF bridging", (Object)name);
                udaf = new HiveGenericUDAF(new HiveFunctionWrapper(functionClassName), true, this.hiveShim);
            }
            return new AggregateFunctionDefinition(name, (AggregateFunction)udaf, GenericTypeInfo.of(Object.class), GenericTypeInfo.of(GenericUDAFEvaluator.AggregationBuffer.class));
        }
        throw new IllegalArgumentException(String.format("HiveFunctionDefinitionFactory cannot initiate FunctionDefinition for class %s", functionClassName));
    }
}

