/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShimV220;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.thrift.TException;

public class HiveShimV230
extends HiveShimV220 {
    private static Method isMaterializedView;
    private static boolean inited;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (inited) return;
        Class<HiveShimV230> clazz = HiveShimV230.class;
        synchronized (HiveShimV230.class) {
            if (inited) return;
            try {
                isMaterializedView = Table.class.getDeclaredMethod("isMaterializedView", new Class[0]);
                inited = true;
            }
            catch (Exception e) {
                throw new FlinkHiveException(e);
            }
            return;
        }
    }

    @Override
    public IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) {
        try {
            Method method = RetryingMetaStoreClient.class.getMethod("getProxy", HiveConf.class, Boolean.TYPE);
            return (IMetaStoreClient)method.invoke(null, new Object[]{hiveConf, true});
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to create Hive Metastore client", (Throwable)ex);
        }
    }

    @Override
    public List<String> getViews(IMetaStoreClient client, String databaseName) throws UnknownDBException, TException {
        try {
            Method method = client.getClass().getMethod("getTables", String.class, String.class, TableType.class);
            return (List)method.invoke((Object)client, new Object[]{databaseName, null, TableType.VIRTUAL_VIEW});
        }
        catch (InvocationTargetException ite) {
            Throwable targetEx = ite.getTargetException();
            if (targetEx instanceof TException) {
                throw (TException)targetEx;
            }
            throw new CatalogException(String.format("Failed to get views for %s", databaseName), targetEx);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new CatalogException(String.format("Failed to get views for %s", databaseName), (Throwable)e);
        }
    }

    @Override
    public void alterTable(IMetaStoreClient client, String databaseName, String tableName, org.apache.hadoop.hive.metastore.api.Table table) throws InvalidOperationException, MetaException, TException {
        client.alter_table(databaseName, tableName, table);
    }

    @Override
    public SimpleGenericUDAFParameterInfo createUDAFParameterInfo(ObjectInspector[] params, boolean isWindowing, boolean distinct, boolean allColumns) {
        try {
            Constructor constructor = SimpleGenericUDAFParameterInfo.class.getConstructor(ObjectInspector[].class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            return (SimpleGenericUDAFParameterInfo)constructor.newInstance(params, isWindowing, distinct, allColumns);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to create SimpleGenericUDAFParameterInfo", (Throwable)e);
        }
    }

    @Override
    public boolean isMaterializedView(Table table) {
        HiveShimV230.init();
        try {
            return (Boolean)isMaterializedView.invoke((Object)table, new Object[0]);
        }
        catch (Exception e) {
            throw new FlinkHiveException(e);
        }
    }

    static {
        inited = false;
    }
}

