/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcBatchReader;
import org.apache.flink.orc.OrcInputFormat;
import org.apache.flink.orc.OrcRowSplitReader;
import org.apache.flink.types.Row;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcRowInputFormat
extends OrcInputFormat<Row>
implements ResultTypeQueryable<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(OrcRowInputFormat.class);
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private transient RowTypeInfo rowType;

    public OrcRowInputFormat(String path, String schemaString, Configuration orcConfig) {
        this(path, TypeDescription.fromString(schemaString), orcConfig, 1000);
    }

    public OrcRowInputFormat(String path, String schemaString, Configuration orcConfig, int batchSize) {
        this(path, TypeDescription.fromString(schemaString), orcConfig, batchSize);
    }

    public OrcRowInputFormat(String path, TypeDescription orcSchema, Configuration orcConfig, int batchSize) {
        super(new Path(path), orcSchema, orcConfig, batchSize);
        this.rowType = (RowTypeInfo)OrcBatchReader.schemaToTypeInfo(orcSchema);
    }

    @Override
    public void selectFields(int ... selectedFields) {
        super.selectFields(selectedFields);
        this.rowType = RowTypeInfo.projectFields((RowTypeInfo)this.rowType, (int[])selectedFields);
    }

    public void open(FileInputSplit fileSplit) throws IOException {
        LOG.debug("Opening ORC file {}", (Object)fileSplit.getPath());
        this.reader = new OrcRowSplitReader(this.conf, this.schema, this.selectedFields, this.conjunctPredicates, this.batchSize, fileSplit.getPath(), fileSplit.getStart(), fileSplit.getLength());
    }

    public TypeInformation<Row> getProducedType() {
        return this.rowType;
    }
}

