/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.hadoop;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Queue;
import org.apache.flink.hive.shaded.parquet.bytes.BytesInput;
import org.apache.flink.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.flink.hive.shaded.parquet.column.page.DataPage;
import org.apache.flink.hive.shaded.parquet.column.page.DataPageV1;
import org.apache.flink.hive.shaded.parquet.column.page.DataPageV2;
import org.apache.flink.hive.shaded.parquet.column.page.DictionaryPage;
import org.apache.flink.hive.shaded.parquet.column.page.DictionaryPageReadStore;
import org.apache.flink.hive.shaded.parquet.column.page.PageReadStore;
import org.apache.flink.hive.shaded.parquet.column.page.PageReader;
import org.apache.flink.hive.shaded.parquet.compression.CompressionCodecFactory;
import org.apache.flink.hive.shaded.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.flink.hive.shaded.parquet.internal.filter2.columnindex.RowRanges;
import org.apache.flink.hive.shaded.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnChunkPageReadStore
implements PageReadStore,
DictionaryPageReadStore {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnChunkPageReadStore.class);
    private final Map<ColumnDescriptor, ColumnChunkPageReader> readers = new HashMap<ColumnDescriptor, ColumnChunkPageReader>();
    private final long rowCount;
    private final RowRanges rowRanges;

    public ColumnChunkPageReadStore(long rowCount) {
        this.rowCount = rowCount;
        this.rowRanges = null;
    }

    ColumnChunkPageReadStore(RowRanges rowRanges) {
        this.rowRanges = rowRanges;
        this.rowCount = rowRanges.rowCount();
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public PageReader getPageReader(ColumnDescriptor path) {
        if (!this.readers.containsKey(path)) {
            throw new IllegalArgumentException(path + " is not in the store: " + this.readers.keySet() + " " + this.rowCount);
        }
        return this.readers.get(path);
    }

    @Override
    public DictionaryPage readDictionaryPage(ColumnDescriptor descriptor) {
        return this.readers.get(descriptor).readDictionaryPage();
    }

    @Override
    public Optional<PrimitiveIterator.OfLong> getRowIndexes() {
        return this.rowRanges == null ? Optional.empty() : Optional.of(this.rowRanges.iterator());
    }

    void addColumn(ColumnDescriptor path, ColumnChunkPageReader reader) {
        if (this.readers.put(path, reader) != null) {
            throw new RuntimeException(path + " was added twice");
        }
    }

    static final class ColumnChunkPageReader
    implements PageReader {
        private final CompressionCodecFactory.BytesInputDecompressor decompressor;
        private final long valueCount;
        private final Queue<DataPage> compressedPages;
        private final DictionaryPage compressedDictionaryPage;
        private final OffsetIndex offsetIndex;
        private final long rowCount;
        private int pageIndex = 0;

        ColumnChunkPageReader(CompressionCodecFactory.BytesInputDecompressor decompressor, List<DataPage> compressedPages, DictionaryPage compressedDictionaryPage, OffsetIndex offsetIndex, long rowCount) {
            this.decompressor = decompressor;
            this.compressedPages = new ArrayDeque<DataPage>(compressedPages);
            this.compressedDictionaryPage = compressedDictionaryPage;
            long count = 0L;
            for (DataPage p : compressedPages) {
                count += (long)p.getValueCount();
            }
            this.valueCount = count;
            this.offsetIndex = offsetIndex;
            this.rowCount = rowCount;
        }

        @Override
        public long getTotalValueCount() {
            return this.valueCount;
        }

        @Override
        public DataPage readPage() {
            DataPage compressedPage = this.compressedPages.poll();
            if (compressedPage == null) {
                return null;
            }
            final int currentPageIndex = this.pageIndex++;
            return compressedPage.accept(new DataPage.Visitor<DataPage>(){

                @Override
                public DataPage visit(DataPageV1 dataPageV1) {
                    try {
                        DataPageV1 decompressedPage;
                        BytesInput decompressed = decompressor.decompress(dataPageV1.getBytes(), dataPageV1.getUncompressedSize());
                        if (offsetIndex == null) {
                            decompressedPage = new DataPageV1(decompressed, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
                        } else {
                            long firstRowIndex = offsetIndex.getFirstRowIndex(currentPageIndex);
                            decompressedPage = new DataPageV1(decompressed, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), firstRowIndex, Math.toIntExact(offsetIndex.getLastRowIndex(currentPageIndex, rowCount) - firstRowIndex + 1L), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
                        }
                        if (dataPageV1.getCrc().isPresent()) {
                            decompressedPage.setCrc(dataPageV1.getCrc().getAsInt());
                        }
                        return decompressedPage;
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not decompress page", e);
                    }
                }

                @Override
                public DataPage visit(DataPageV2 dataPageV2) {
                    if (!dataPageV2.isCompressed()) {
                        if (offsetIndex == null) {
                            return dataPageV2;
                        }
                        return DataPageV2.uncompressed(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), offsetIndex.getFirstRowIndex(currentPageIndex), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), dataPageV2.getData(), dataPageV2.getStatistics());
                    }
                    try {
                        int uncompressedSize = Math.toIntExact((long)dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().size() - dataPageV2.getRepetitionLevels().size());
                        BytesInput decompressed = decompressor.decompress(dataPageV2.getData(), uncompressedSize);
                        if (offsetIndex == null) {
                            return DataPageV2.uncompressed(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), decompressed, dataPageV2.getStatistics());
                        }
                        return DataPageV2.uncompressed(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), offsetIndex.getFirstRowIndex(currentPageIndex), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), decompressed, dataPageV2.getStatistics());
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not decompress page", e);
                    }
                }
            });
        }

        @Override
        public DictionaryPage readDictionaryPage() {
            if (this.compressedDictionaryPage == null) {
                return null;
            }
            try {
                DictionaryPage decompressedPage = new DictionaryPage(this.decompressor.decompress(this.compressedDictionaryPage.getBytes(), this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
                if (this.compressedDictionaryPage.getCrc().isPresent()) {
                    decompressedPage.setCrc(this.compressedDictionaryPage.getCrc().getAsInt());
                }
                return decompressedPage;
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Could not decompress dictionary page", e);
            }
        }
    }
}

