/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.fs.hdfs;

import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.Path;

class HadoopFsRecoverable
implements RecoverableWriter.CommitRecoverable,
RecoverableWriter.ResumeRecoverable {
    private final Path targetFile;
    private final Path tempFile;
    private final long offset;

    HadoopFsRecoverable(Path targetFile, Path tempFile, long offset) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be >= 0");
        this.targetFile = (Path)Preconditions.checkNotNull((Object)targetFile, (String)"targetFile");
        this.tempFile = (Path)Preconditions.checkNotNull((Object)tempFile, (String)"tempFile");
        this.offset = offset;
    }

    public Path targetFile() {
        return this.targetFile;
    }

    public Path tempFile() {
        return this.tempFile;
    }

    public long offset() {
        return this.offset;
    }

    public String toString() {
        return "HadoopFsRecoverable " + this.tempFile + " @ " + this.offset + " -> " + this.targetFile;
    }
}

