/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet.protobuf;

import com.google.protobuf.Message;
import org.apache.flink.hive.shaded.formats.parquet.ParquetBuilder;
import org.apache.flink.hive.shaded.formats.parquet.ParquetWriterFactory;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetWriter;
import org.apache.flink.hive.shaded.parquet.hadoop.api.WriteSupport;
import org.apache.flink.hive.shaded.parquet.io.OutputFile;
import org.apache.flink.hive.shaded.parquet.proto.ProtoWriteSupport;
import org.apache.hadoop.conf.Configuration;

public class ParquetProtoWriters {
    public static <T extends Message> ParquetWriterFactory<T> forType(Class<T> type) {
        ParquetBuilder builder = out -> new ParquetProtoWriterBuilder(out, type).build();
        return new ParquetWriterFactory(builder);
    }

    private ParquetProtoWriters() {
    }

    private static class ParquetProtoWriterBuilder<T extends Message>
    extends ParquetWriter.Builder<T, ParquetProtoWriterBuilder<T>> {
        private final Class<T> clazz;

        protected ParquetProtoWriterBuilder(OutputFile outputFile, Class<T> clazz) {
            super(outputFile);
            this.clazz = clazz;
        }

        @Override
        protected ParquetProtoWriterBuilder<T> self() {
            return this;
        }

        @Override
        protected WriteSupport<T> getWriteSupport(Configuration conf) {
            return new ProtoWriteSupport(this.clazz);
        }
    }
}

