/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.write;

import java.io.IOException;
import java.util.function.Function;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.hive.write.HiveWriterFactory;
import org.apache.flink.core.fs.Path;
import org.apache.flink.hive.shaded.fs.hdfs.HadoopFileSystem;
import org.apache.flink.table.filesystem.OutputFormatFactory;
import org.apache.flink.types.Row;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.Writable;

public class HiveOutputFormatFactory
implements OutputFormatFactory<Row> {
    private static final long serialVersionUID = 2L;
    private final HiveWriterFactory factory;

    public HiveOutputFormatFactory(HiveWriterFactory factory) {
        this.factory = factory;
    }

    public HiveOutputFormat createOutputFormat(Path path) {
        return new HiveOutputFormat(this.factory.createRecordWriter(HadoopFileSystem.toHadoopPath(path)), this.factory.createRowConverter());
    }

    private class HiveOutputFormat
    implements OutputFormat<Row> {
        private final FileSinkOperator.RecordWriter recordWriter;
        private final Function<Row, Writable> rowConverter;

        private HiveOutputFormat(FileSinkOperator.RecordWriter recordWriter, Function<Row, Writable> rowConverter) {
            this.recordWriter = recordWriter;
            this.rowConverter = rowConverter;
        }

        public void configure(Configuration parameters) {
        }

        public void open(int taskNumber, int numTasks) {
        }

        public void writeRecord(Row record) throws IOException {
            this.recordWriter.write(this.rowConverter.apply(record));
        }

        public void close() throws IOException {
            this.recordWriter.close(false);
        }
    }
}

