/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.io.IOException;
import java.util.List;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.JobConfWrapper;
import org.apache.flink.connectors.hive.read.HiveTableInputFormat;
import org.apache.flink.connectors.hive.read.HiveTableInputSplit;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.filesystem.PartitionReader;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.mapred.JobConf;

public class HiveInputFormatPartitionReader
implements PartitionReader<HiveTablePartition, RowData> {
    private static final long serialVersionUID = 1L;
    private final JobConfWrapper jobConfWrapper;
    private final String hiveVersion;
    protected final ObjectPath tablePath;
    private final DataType[] fieldTypes;
    private final String[] fieldNames;
    private final List<String> partitionKeys;
    private final int[] selectedFields;
    private final boolean useMapRedReader;
    private transient HiveTableInputFormat hiveTableInputFormat;
    private transient HiveTableInputSplit[] inputSplits;
    private transient int readingSplitId;

    public HiveInputFormatPartitionReader(JobConf jobConf, String hiveVersion, ObjectPath tablePath, DataType[] fieldTypes, String[] fieldNames, List<String> partitionKeys, int[] selectedFields, boolean useMapRedReader) {
        this.jobConfWrapper = new JobConfWrapper(jobConf);
        this.hiveVersion = hiveVersion;
        this.tablePath = tablePath;
        this.fieldTypes = fieldTypes;
        this.fieldNames = fieldNames;
        this.partitionKeys = partitionKeys;
        this.selectedFields = selectedFields;
        this.useMapRedReader = useMapRedReader;
    }

    public void open(List<HiveTablePartition> partitions) throws IOException {
        this.hiveTableInputFormat = new HiveTableInputFormat(this.jobConfWrapper.conf(), this.partitionKeys, this.fieldTypes, this.fieldNames, this.selectedFields, null, this.hiveVersion, this.useMapRedReader, partitions);
        this.inputSplits = this.hiveTableInputFormat.createInputSplits(1);
        this.readingSplitId = 0;
        if (this.inputSplits.length > 0) {
            this.hiveTableInputFormat.open(this.inputSplits[this.readingSplitId]);
        }
    }

    public RowData read(RowData reuse) throws IOException {
        if (this.hasNext()) {
            return this.hiveTableInputFormat.nextRecord(reuse);
        }
        return null;
    }

    private boolean hasNext() throws IOException {
        if (this.inputSplits.length > 0) {
            if (this.hiveTableInputFormat.reachedEnd() && this.readingSplitId == this.inputSplits.length - 1) {
                return false;
            }
            if (this.hiveTableInputFormat.reachedEnd()) {
                ++this.readingSplitId;
                this.hiveTableInputFormat.open(this.inputSplits[this.readingSplitId]);
            }
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.hiveTableInputFormat.close();
    }
}

