/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.filesystem.ContinuousPartitionFetcher;
import org.apache.flink.table.filesystem.PartitionFetcher;
import org.apache.hadoop.hive.metastore.api.Partition;

@Internal
public class HiveContinuousPartitionFetcher<T extends Comparable<T>>
implements ContinuousPartitionFetcher<Partition, T> {
    private static final long serialVersionUID = 1L;

    public List<Tuple2<Partition, T>> fetchPartitions(ContinuousPartitionFetcher.Context<Partition, T> context, T previousOffset) throws Exception {
        ArrayList<Tuple2<Partition, T>> partitions = new ArrayList<Tuple2<Partition, T>>();
        List partitionValueList = context.getComparablePartitionValueList();
        for (PartitionFetcher.Context.ComparablePartitionValue partitionValue : partitionValueList) {
            Comparable partitionOffset = partitionValue.getComparator();
            if (partitionOffset.compareTo(previousOffset) < 0) continue;
            Partition partition = (Partition)context.getPartition((List)partitionValue.getPartitionValue()).orElseThrow(() -> new IllegalArgumentException(String.format("Fetch partition fail for hive table %s.", context.getTablePath())));
            partitions.add(new Tuple2((Object)partition, (Object)partitionValue.getComparator()));
        }
        return partitions;
    }

    public List<Partition> fetch(PartitionFetcher.Context<Partition> context) throws Exception {
        throw new UnsupportedOperationException("HiveContinuousPartitionFetcher does not support fetch all partition.");
    }
}

