/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.flink.connectors.hive.CachedSerializedValue;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;

public class HiveTablePartition
implements Serializable {
    private static final long serialVersionUID = 4145470177119940673L;
    private final CachedSerializedValue<StorageDescriptor> storageDescriptor;
    private final Map<String, String> partitionSpec;
    private final Properties tableProps;

    public HiveTablePartition(StorageDescriptor storageDescriptor, Properties tableProps) {
        this(storageDescriptor, new LinkedHashMap<String, String>(), tableProps);
    }

    public HiveTablePartition(StorageDescriptor storageDescriptor, Map<String, String> partitionSpec, Properties tableProps) {
        try {
            this.storageDescriptor = new CachedSerializedValue<Object>(Preconditions.checkNotNull((Object)storageDescriptor, (String)"storageDescriptor can not be null"));
        }
        catch (IOException e) {
            throw new FlinkHiveException("Failed to serialize StorageDescriptor", e);
        }
        this.partitionSpec = (Map)Preconditions.checkNotNull(partitionSpec, (String)"partitionSpec can not be null");
        this.tableProps = (Properties)Preconditions.checkNotNull((Object)tableProps, (String)"tableProps can not be null");
    }

    public StorageDescriptor getStorageDescriptor() {
        try {
            return this.storageDescriptor.deserializeValue();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new FlinkHiveException("Failed to deserialize StorageDescriptor", e);
        }
    }

    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    public Properties getTableProps() {
        return this.tableProps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTablePartition that = (HiveTablePartition)o;
        return Objects.equals(this.storageDescriptor, that.storageDescriptor) && Objects.equals(this.partitionSpec, that.partitionSpec) && Objects.equals(this.tableProps, that.tableProps);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.storageDescriptor, this.partitionSpec, this.tableProps});
    }

    public String toString() {
        return "HiveTablePartition{storageDescriptor=" + this.getStorageDescriptor() + ", partitionSpec=" + this.partitionSpec + ", tableProps=" + this.tableProps + '}';
    }
}

