/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.IOException;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.connectors.hive.HiveOptions;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveParallelismInference {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParallelismInference.class);
    private final ObjectPath tablePath;
    private final boolean infer;
    private final int inferMaxParallelism;
    private int parallelism;

    HiveParallelismInference(ObjectPath tablePath, ReadableConfig flinkConf) {
        this.tablePath = tablePath;
        this.infer = (Boolean)flinkConf.get(HiveOptions.TABLE_EXEC_HIVE_INFER_SOURCE_PARALLELISM);
        this.inferMaxParallelism = (Integer)flinkConf.get(HiveOptions.TABLE_EXEC_HIVE_INFER_SOURCE_PARALLELISM_MAX);
        Preconditions.checkArgument((this.inferMaxParallelism >= 1 ? 1 : 0) != 0, (Object)(HiveOptions.TABLE_EXEC_HIVE_INFER_SOURCE_PARALLELISM_MAX.key() + " cannot be less than 1"));
        this.parallelism = (Integer)flinkConf.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM);
    }

    int limit(Long limit) {
        if (limit != null) {
            this.parallelism = Math.min(this.parallelism, (int)(limit / 1000L));
        }
        return Math.max(1, this.parallelism);
    }

    HiveParallelismInference infer(SupplierWithException<Integer, IOException> numFiles, SupplierWithException<Integer, IOException> numSplits) {
        if (!this.infer) {
            return this;
        }
        try {
            int lowerBound = this.logRunningTime("getNumFiles", numFiles);
            if (lowerBound >= this.inferMaxParallelism) {
                this.parallelism = this.inferMaxParallelism;
                return this;
            }
            int splitNum = this.logRunningTime("createInputSplits", numSplits);
            this.parallelism = Math.min(splitNum, this.inferMaxParallelism);
        }
        catch (IOException e) {
            throw new FlinkHiveException(e);
        }
        return this;
    }

    private int logRunningTime(String operationName, SupplierWithException<Integer, IOException> supplier) throws IOException {
        long startTimeMillis = System.currentTimeMillis();
        int result = (Integer)supplier.get();
        LOG.info("Hive source({}}) {} use time: {} ms, result: {}", new Object[]{this.tablePath, operationName, System.currentTimeMillis() - startTimeMillis, result});
        return result;
    }
}

