/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.LinkedHashMap;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="str_to_map", value="_FUNC_(text, delimiter1, delimiter2) - Creates a map by parsing text ", extended="Split text into key-value pairs using two delimiters. The first delimiter seperates pairs, and the second delimiter sperates key and value. If only one parameter is given, default delimiters are used: ',' as delimiter1 and '=' as delimiter2.")
public class GenericUDFStringToMap
extends GenericUDF {
    private final LinkedHashMap<Object, Object> ret = new LinkedHashMap();
    private transient ObjectInspectorConverters.Converter soi_text;
    private transient ObjectInspectorConverters.Converter soi_de1 = null;
    private transient ObjectInspectorConverters.Converter soi_de2 = null;
    static final String default_de1 = ",";
    static final String default_de2 = ":";

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        for (int idx = 0; idx < Math.min(arguments.length, 3); ++idx) {
            if (arguments[idx].getCategory() == ObjectInspector.Category.PRIMITIVE && PrimitiveObjectInspectorUtils.getPrimitiveGrouping(((PrimitiveObjectInspector)arguments[idx]).getPrimitiveCategory()) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) continue;
            throw new UDFArgumentException("All argument should be string/character type");
        }
        this.soi_text = ObjectInspectorConverters.getConverter(arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        if (arguments.length > 1) {
            this.soi_de1 = ObjectInspectorConverters.getConverter(arguments[1], (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        if (arguments.length > 2) {
            this.soi_de2 = ObjectInspectorConverters.getConverter(arguments[2], (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        return ObjectInspectorFactory.getStandardMapObjectInspector(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        String[] keyValuePairs;
        this.ret.clear();
        String text = (String)this.soi_text.convert(arguments[0].get());
        String delimiter1 = this.soi_de1 == null ? default_de1 : (String)this.soi_de1.convert(arguments[1].get());
        String delimiter2 = this.soi_de2 == null ? default_de2 : (String)this.soi_de2.convert(arguments[2].get());
        for (String keyValuePair : keyValuePairs = text.split(delimiter1)) {
            String[] keyValue = keyValuePair.split(delimiter2, 2);
            if (keyValue.length < 2) {
                this.ret.put(keyValuePair, null);
                continue;
            }
            this.ret.put(keyValue[0], keyValue[1]);
        }
        return this.ret;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length <= 3);
        return this.getStandardDisplayString("str_to_map", children, default_de1);
    }
}

