/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.CompactionTxnHandler;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorMR;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class Worker
extends CompactorThread {
    private static final String CLASS_NAME = Worker.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private static final long SLEEP_TIME = 5000L;
    private static final int baseThreadNum = 10002;
    private String name;

    public static String hostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Unable to resolve my host name " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        do {
            boolean launchedJob = false;
            try {
                String runAs;
                Partition p;
                Table t;
                CompactionInfo ci;
                block22: {
                    Table t1;
                    block21: {
                        ci = this.txnHandler.findNextToCompact(this.name);
                        if (ci == null && !this.stop.get()) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                LOG.warn((Object)("Worker thread sleep interrupted " + e.getMessage()));
                            }
                            continue;
                        }
                        t1 = null;
                        try {
                            t1 = this.resolveTable(ci);
                            if (t1 == null) {
                                LOG.info((Object)("Unable to find table " + ci.getFullTableName() + ", assuming it was dropped and moving on."));
                                this.txnHandler.markCleaned(ci);
                            }
                            break block21;
                        }
                        catch (MetaException e) {
                            this.txnHandler.markCleaned(ci);
                        }
                        continue;
                    }
                    t = t1;
                    p = null;
                    try {
                        p = this.resolvePartition(ci);
                        if (p == null && ci.partName != null) {
                            LOG.info((Object)("Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped and moving on."));
                            this.txnHandler.markCleaned(ci);
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        this.txnHandler.markCleaned(ci);
                    }
                    continue;
                }
                final StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
                if (sd.getSortCols() != null && !sd.getSortCols().isEmpty()) {
                    LOG.error((Object)"Attempt to compact sorted table, which is not yet supported!");
                    this.txnHandler.markCleaned(ci);
                    continue;
                }
                final boolean isMajor = ci.isMajorCompaction();
                final ValidTxnList txns = CompactionTxnHandler.createValidCompactTxnList(this.txnHandler.getOpenTxnsInfo());
                LOG.debug((Object)("ValidCompactTxnList: " + txns.writeToString()));
                final StringBuffer jobName = new StringBuffer(this.name);
                jobName.append("-compactor-");
                jobName.append(ci.getFullPartitionName());
                if (ci.runAs == null) {
                    runAs = this.findUserToRunAs(sd.getLocation(), t);
                    this.txnHandler.setRunAs(ci.id, runAs);
                } else {
                    runAs = ci.runAs;
                }
                LOG.info((Object)("Starting " + ci.type.toString() + " compaction for " + ci.getFullPartitionName()));
                final StatsUpdater su = StatsUpdater.init(ci, this.txnHandler.findColumnsWithStats(ci), this.conf, this.runJobAsSelf(runAs) ? runAs : t.getOwner());
                final CompactorMR mr = new CompactorMR();
                launchedJob = true;
                try {
                    if (this.runJobAsSelf(runAs)) {
                        mr.run(this.conf, jobName.toString(), t, sd, txns, isMajor, su);
                    } else {
                        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)t.getOwner(), (UserGroupInformation)UserGroupInformation.getLoginUser());
                        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                mr.run(Worker.this.conf, jobName.toString(), t, sd, txns, isMajor, su);
                                return null;
                            }
                        });
                    }
                    this.txnHandler.markCompacted(ci);
                }
                catch (Exception e) {
                    LOG.error((Object)("Caught exception while trying to compact " + ci.getFullPartitionName() + ".  Marking clean to avoid repeated failures, " + StringUtils.stringifyException((Throwable)e)));
                    this.txnHandler.markCleaned(ci);
                }
            }
            catch (Throwable t) {
                LOG.error((Object)("Caught an exception in the main loop of compactor worker " + this.name + ", " + StringUtils.stringifyException((Throwable)t)));
            }
            if (launchedJob || this.stop.get()) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.stop.get());
    }

    @Override
    public void init(AtomicBoolean stop, AtomicBoolean looped) throws MetaException {
        super.init(stop, looped);
        StringBuilder name = new StringBuilder(Worker.hostname());
        name.append("-");
        name.append(this.getId());
        this.name = name.toString();
        this.setName(name.toString());
    }

    static final class StatsUpdater {
        private static final Log LOG = LogFactory.getLog(StatsUpdater.class);
        private final List<String> columnList;
        private final HiveConf conf;
        private final String userName;
        private final CompactionInfo ci;

        public static StatsUpdater init(CompactionInfo ci, List<String> columnListForStats, HiveConf conf, String userName) {
            return new StatsUpdater(ci, columnListForStats, conf, userName);
        }

        private StatsUpdater(CompactionInfo ci, List<String> columnListForStats, HiveConf conf, String userName) {
            this.conf = conf;
            this.userName = userName;
            this.ci = ci;
            if (!ci.isMajorCompaction() || columnListForStats == null || columnListForStats.isEmpty()) {
                this.columnList = Collections.emptyList();
                return;
            }
            this.columnList = columnListForStats;
        }

        void gatherStats() throws IOException {
            if (!this.ci.isMajorCompaction()) {
                return;
            }
            if (this.columnList.isEmpty()) {
                LOG.debug((Object)("No existing stats for " + this.ci.dbname + "." + this.ci.tableName + " found.  Will not run analyze."));
                return;
            }
            StringBuilder sb = new StringBuilder("analyze table ").append(this.ci.dbname).append(".").append(this.ci.tableName);
            if (this.ci.partName != null) {
                try {
                    sb.append(" partition(");
                    Map<String, String> partitionColumnValues = Warehouse.makeEscSpecFromName(this.ci.partName);
                    for (Map.Entry<String, String> ent : partitionColumnValues.entrySet()) {
                        sb.append(ent.getKey()).append("='").append(ent.getValue()).append("'");
                    }
                    sb.append(")");
                }
                catch (MetaException ex) {
                    throw new IOException(ex);
                }
            }
            sb.append(" compute statistics for columns ");
            for (String colName : this.columnList) {
                sb.append(colName).append(",");
            }
            sb.setLength(sb.length() - 1);
            LOG.debug((Object)("running '" + sb.toString() + "'"));
            Driver d = new Driver(this.conf, this.userName);
            SessionState localSession = null;
            if (SessionState.get() == null) {
                localSession = SessionState.start(new SessionState(this.conf));
            }
            try {
                CommandProcessorResponse cpr = d.run(sb.toString());
                if (cpr.getResponseCode() != 0) {
                    throw new IOException("Could not update stats for table " + this.ci.getFullTableName() + (this.ci.partName == null ? "" : "/" + this.ci.partName) + " due to: " + cpr);
                }
            }
            catch (CommandNeedRetryException cnre) {
                throw new IOException("Could not update stats for table " + this.ci.getFullTableName() + (this.ci.partName == null ? "" : "/" + this.ci.partName) + " due to: " + cnre.getMessage());
            }
            finally {
                if (localSession != null) {
                    localSession.close();
                }
            }
        }
    }
}

