/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteCanApplyCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public final class RewriteCanApplyProcFactory {
    public static CheckTableScanProc canApplyOnTableScanOperator(TableScanOperator topOp) {
        return new CheckTableScanProc();
    }

    private static class CheckTableScanProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            RewriteCanApplyCtx canApplyCtx = (RewriteCanApplyCtx)ctx;
            for (Node node : stack) {
                if (node instanceof TableScanOperator) {
                    TableScanOperator ts = (TableScanOperator)node;
                    canApplyCtx.setTableScanOperator(ts);
                    List<String> selectColumns = ((TableScanDesc)ts.getConf()).getReferencedColumns();
                    if (selectColumns == null || selectColumns.size() != 1) {
                        canApplyCtx.setSelClauseColsFetchException(true);
                        return null;
                    }
                    canApplyCtx.setIndexKey(selectColumns.get(0));
                    continue;
                }
                if (node instanceof SelectOperator) {
                    if (canApplyCtx.getSelectOperators() == null) {
                        canApplyCtx.setSelectOperators(new ArrayList<SelectOperator>());
                    }
                    canApplyCtx.getSelectOperators().add((SelectOperator)node);
                    continue;
                }
                if (!(node instanceof GroupByOperator)) continue;
                if (canApplyCtx.getGroupByOperators() == null) {
                    canApplyCtx.setGroupByOperators(new ArrayList<GroupByOperator>());
                }
                GroupByOperator operator = (GroupByOperator)node;
                canApplyCtx.getGroupByOperators().add(operator);
                if (canApplyCtx.isQueryHasGroupBy()) continue;
                canApplyCtx.setQueryHasGroupBy(true);
                GroupByDesc conf = (GroupByDesc)operator.getConf();
                ArrayList<AggregationDesc> aggrList = conf.getAggregators();
                if (aggrList == null || aggrList.size() != 1 || !"count".equals(((AggregationDesc)aggrList.get(0)).getGenericUDAFName())) {
                    canApplyCtx.setAggFuncIsNotCount(true);
                    return null;
                }
                ArrayList<ExprNodeDesc> para = ((AggregationDesc)aggrList.get(0)).getParameters();
                if (para == null || para.size() == 0 || para.size() > 1) {
                    canApplyCtx.setAggParameterException(true);
                    return null;
                }
                ExprNodeDesc expr = ExprNodeDescUtils.backtrack((ExprNodeDesc)para.get(0), operator, (Operator)stack.get(0));
                if (expr instanceof ExprNodeColumnDesc) continue;
                canApplyCtx.setAggParameterException(true);
                return null;
            }
            return null;
        }
    }
}

