/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.correlation.AbstractCorrelationProcCtx;
import org.apache.hadoop.hive.ql.optimizer.correlation.CorrelationUtilities;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class ReduceSinkDeDuplication
implements Transform {
    private static final String RS = ReduceSinkOperator.getOperatorName();
    private static final String GBY = GroupByOperator.getOperatorName();
    private static final String JOIN = JoinOperator.getOperatorName();
    protected ParseContext pGraphContext;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.pGraphContext = pctx;
        ReduceSinkDeduplicateProcCtx cppCtx = new ReduceSinkDeduplicateProcCtx(this.pGraphContext);
        boolean mergeJoins = !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN) && !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASK);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", RS + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getReducerReducerProc());
        opRules.put(new RuleRegExp("R2", RS + "%" + GBY + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getGroupbyReducerProc());
        if (mergeJoins) {
            opRules.put(new RuleRegExp("R3", JOIN + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getJoinReducerProc());
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ReduceSinkDeduplicateProcFactory.getDefaultProc(), opRules, cppCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pGraphContext.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return this.pGraphContext;
    }

    static class ReducerReducerProc
    extends AbsctractReducerReducerProc {
        ReducerReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(cRS, ReduceSinkOperator.class, dedupCtx.trustScript());
            if (pRS != null && this.merge(cRS, pRS, dedupCtx.minReducer())) {
                CorrelationUtilities.replaceReduceSinkWithSelectOperator(cRS, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setEnforceSort(true);
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            Operator<?> start = CorrelationUtilities.getStartForGroupBy(cRS);
            ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(start, ReduceSinkOperator.class, dedupCtx.trustScript());
            if (pRS != null && this.merge(cRS, pRS, dedupCtx.minReducer())) {
                if (dedupCtx.getPctx().getConf().getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW)) {
                    return false;
                }
                CorrelationUtilities.removeReduceSinkForGroupBy(cRS, cGBY, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setEnforceSort(true);
                return true;
            }
            return false;
        }
    }

    static class JoinReducerProc
    extends AbsctractReducerReducerProc {
        JoinReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            JoinOperator pJoin = CorrelationUtilities.findPossibleParent(cRS, JoinOperator.class, dedupCtx.trustScript());
            if (pJoin != null && this.merge(cRS, pJoin, dedupCtx.minReducer())) {
                ((JoinDesc)pJoin.getConf()).setFixedAsSorted(true);
                CorrelationUtilities.replaceReduceSinkWithSelectOperator(cRS, dedupCtx.getPctx(), dedupCtx);
                ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(pJoin, ReduceSinkOperator.class, dedupCtx.trustScript());
                if (pRS != null) {
                    ((ReduceSinkDesc)pRS.getConf()).setEnforceSort(true);
                }
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            Operator<?> start = CorrelationUtilities.getStartForGroupBy(cRS);
            JoinOperator pJoin = CorrelationUtilities.findPossibleParent(start, JoinOperator.class, dedupCtx.trustScript());
            if (pJoin != null && this.merge(cRS, pJoin, dedupCtx.minReducer())) {
                ((JoinDesc)pJoin.getConf()).setFixedAsSorted(true);
                CorrelationUtilities.removeReduceSinkForGroupBy(cRS, cGBY, dedupCtx.getPctx(), dedupCtx);
                ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(pJoin, ReduceSinkOperator.class, dedupCtx.trustScript());
                if (pRS != null) {
                    ((ReduceSinkDesc)pRS.getConf()).setEnforceSort(true);
                }
                return true;
            }
            return false;
        }
    }

    static class GroupbyReducerProc
    extends AbsctractReducerReducerProc {
        GroupbyReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            GroupByOperator pGBY = CorrelationUtilities.findPossibleParent(cRS, GroupByOperator.class, dedupCtx.trustScript());
            if (pGBY == null) {
                return false;
            }
            ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(pGBY, ReduceSinkOperator.class, dedupCtx.trustScript());
            if (pRS != null && this.merge(cRS, pRS, dedupCtx.minReducer())) {
                CorrelationUtilities.replaceReduceSinkWithSelectOperator(cRS, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setEnforceSort(true);
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            Operator<?> start = CorrelationUtilities.getStartForGroupBy(cRS);
            GroupByOperator pGBY = CorrelationUtilities.findPossibleParent(start, GroupByOperator.class, dedupCtx.trustScript());
            if (pGBY == null) {
                return false;
            }
            ReduceSinkOperator pRS = CorrelationUtilities.getSingleParent(pGBY, ReduceSinkOperator.class);
            if (pRS != null && this.merge(cRS, pRS, dedupCtx.minReducer())) {
                CorrelationUtilities.removeReduceSinkForGroupBy(cRS, cGBY, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setEnforceSort(true);
                return true;
            }
            return false;
        }
    }

    public static abstract class AbsctractReducerReducerProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkDeduplicateProcCtx dedupCtx = (ReduceSinkDeduplicateProcCtx)procCtx;
            if (dedupCtx.hasBeenRemoved((Operator)nd)) {
                return false;
            }
            ReduceSinkOperator cRS = (ReduceSinkOperator)nd;
            Operator<?> child = CorrelationUtilities.getSingleChild(cRS);
            if (child instanceof JoinOperator) {
                return false;
            }
            if (child instanceof GroupByOperator) {
                GroupByOperator cGBY = (GroupByOperator)child;
                if (!CorrelationUtilities.hasGroupingSet(cRS) && !((GroupByDesc)cGBY.getConf()).isGroupingSetsPresent()) {
                    return this.process(cRS, cGBY, dedupCtx);
                }
                return false;
            }
            if (child instanceof SelectOperator) {
                return this.process(cRS, dedupCtx);
            }
            return false;
        }

        protected abstract Object process(ReduceSinkOperator var1, ReduceSinkDeduplicateProcCtx var2) throws SemanticException;

        protected abstract Object process(ReduceSinkOperator var1, GroupByOperator var2, ReduceSinkDeduplicateProcCtx var3) throws SemanticException;

        protected boolean merge(ReduceSinkOperator cRS, JoinOperator pJoin, int minReducer) throws SemanticException {
            List<Operator<OperatorDesc>> parents = pJoin.getParentOperators();
            Operator[] pRSs = parents.toArray(new ReduceSinkOperator[parents.size()]);
            ReduceSinkDesc cRSc = (ReduceSinkDesc)cRS.getConf();
            ReduceSinkDesc pRS0c = (ReduceSinkDesc)pRSs[0].getConf();
            if (cRSc.getKeyCols().size() > pRS0c.getKeyCols().size()) {
                return false;
            }
            if (cRSc.getPartitionCols().size() > pRS0c.getPartitionCols().size()) {
                return false;
            }
            Integer moveReducerNumTo = this.checkNumReducer(cRSc.getNumReducers(), pRS0c.getNumReducers());
            if (moveReducerNumTo == null || moveReducerNumTo > 0 && cRSc.getNumReducers() < minReducer) {
                return false;
            }
            Integer moveRSOrderTo = this.checkOrder(cRSc.getOrder(), pRS0c.getOrder());
            if (moveRSOrderTo == null) {
                return false;
            }
            boolean[] sorted = CorrelationUtilities.getSortedTags(pJoin);
            int cKeySize = cRSc.getKeyCols().size();
            for (int i = 0; i < cKeySize; ++i) {
                ExprNodeDesc cexpr = cRSc.getKeyCols().get(i);
                ExprNodeDesc[] pexprs = new ExprNodeDesc[pRSs.length];
                for (int tag = 0; tag < pRSs.length; ++tag) {
                    pexprs[tag] = ((ReduceSinkDesc)pRSs[tag].getConf()).getKeyCols().get(i);
                }
                int found = CorrelationUtilities.indexOf(cexpr, pexprs, cRS, pRSs, sorted);
                if (found >= 0) continue;
                return false;
            }
            int cPartSize = cRSc.getPartitionCols().size();
            for (int i = 0; i < cPartSize; ++i) {
                ExprNodeDesc cexpr = cRSc.getPartitionCols().get(i);
                ExprNodeDesc[] pexprs = new ExprNodeDesc[pRSs.length];
                for (int tag = 0; tag < pRSs.length; ++tag) {
                    pexprs[tag] = ((ReduceSinkDesc)pRSs[tag].getConf()).getPartitionCols().get(i);
                }
                int found = CorrelationUtilities.indexOf(cexpr, pexprs, cRS, pRSs, sorted);
                if (found >= 0) continue;
                return false;
            }
            if (moveReducerNumTo > 0) {
                for (Operator pRS : pRSs) {
                    ((ReduceSinkDesc)pRS.getConf()).setNumReducers(((ReduceSinkDesc)cRS.getConf()).getNumReducers());
                }
            }
            return true;
        }

        protected boolean merge(ReduceSinkOperator cRS, ReduceSinkOperator pRS, int minReducer) throws SemanticException {
            ArrayList<ExprNodeDesc> parentPCs;
            int[] result = this.checkStatus(cRS, pRS, minReducer);
            if (result == null) {
                return false;
            }
            if (result[0] > 0) {
                ArrayList<ExprNodeDesc> childKCs = ((ReduceSinkDesc)cRS.getConf()).getKeyCols();
                ((ReduceSinkDesc)pRS.getConf()).setKeyCols(ExprNodeDescUtils.backtrack(childKCs, cRS, pRS));
            }
            if (result[1] < 0) {
                ArrayList<ExprNodeDesc> childPCs = ((ReduceSinkDesc)cRS.getConf()).getPartitionCols();
                if (childPCs != null && !childPCs.isEmpty()) {
                    ((ReduceSinkDesc)pRS.getConf()).setPartitionCols(ExprNodeDescUtils.backtrack(childPCs, cRS, pRS));
                }
            } else if (result[1] > 0 && ((parentPCs = ((ReduceSinkDesc)pRS.getConf()).getPartitionCols()) == null || parentPCs.isEmpty())) {
                ArrayList<ExprNodeDesc> childPCs = ((ReduceSinkDesc)cRS.getConf()).getPartitionCols();
                ((ReduceSinkDesc)pRS.getConf()).setPartitionCols(ExprNodeDescUtils.backtrack(childPCs, cRS, pRS));
            }
            if (result[2] > 0) {
                if (result[0] <= 0) {
                    throw new SemanticException("Sorting columns and order don't match. Try set " + (Object)((Object)HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATION) + "=false;");
                }
                ((ReduceSinkDesc)pRS.getConf()).setOrder(((ReduceSinkDesc)cRS.getConf()).getOrder());
            }
            if (result[3] > 0) {
                ((ReduceSinkDesc)pRS.getConf()).setNumReducers(((ReduceSinkDesc)cRS.getConf()).getNumReducers());
            }
            if (result[4] > 0) {
                ((ReduceSinkDesc)pRS.getConf()).setNumDistributionKeys(((ReduceSinkDesc)cRS.getConf()).getNumDistributionKeys());
                List<FieldSchema> fields = PlanUtils.getFieldSchemasFromColumnList(((ReduceSinkDesc)pRS.getConf()).getKeyCols(), "reducesinkkey");
                TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(fields, ((ReduceSinkDesc)pRS.getConf()).getOrder());
                ArrayList<String> outputKeyCols = Lists.newArrayList();
                for (int i = 0; i < fields.size(); ++i) {
                    outputKeyCols.add(fields.get(i).getName());
                }
                ((ReduceSinkDesc)pRS.getConf()).setOutputKeyColumnNames(outputKeyCols);
                ((ReduceSinkDesc)pRS.getConf()).setKeySerializeInfo(keyTable);
            }
            return true;
        }

        private int[] checkStatus(ReduceSinkOperator cRS, ReduceSinkOperator pRS, int minReducer) throws SemanticException {
            ArrayList<ExprNodeDesc> ppars;
            ArrayList<ExprNodeDesc> pkeys;
            ReduceSinkDesc cConf = (ReduceSinkDesc)cRS.getConf();
            ReduceSinkDesc pConf = (ReduceSinkDesc)pRS.getConf();
            Integer moveRSOrderTo = this.checkOrder(cConf.getOrder(), pConf.getOrder());
            if (moveRSOrderTo == null) {
                return null;
            }
            Integer moveReducerNumTo = this.checkNumReducer(cConf.getNumReducers(), pConf.getNumReducers());
            if (moveReducerNumTo == null || moveReducerNumTo > 0 && cConf.getNumReducers() < minReducer) {
                return null;
            }
            ArrayList<ExprNodeDesc> ckeys = cConf.getKeyCols();
            Integer moveKeyColTo = this.checkExprs(ckeys, pkeys = pConf.getKeyCols(), cRS, pRS);
            if (moveKeyColTo == null) {
                return null;
            }
            ArrayList<ExprNodeDesc> cpars = cConf.getPartitionCols();
            Integer movePartitionColTo = this.checkExprs(cpars, ppars = pConf.getPartitionCols(), cRS, pRS);
            if (movePartitionColTo == null) {
                return null;
            }
            Integer moveNumDistKeyTo = this.checkNumDistributionKey(cConf.getNumDistributionKeys(), pConf.getNumDistributionKeys());
            return new int[]{moveKeyColTo, movePartitionColTo, moveRSOrderTo, moveReducerNumTo, moveNumDistKeyTo};
        }

        private Integer checkNumDistributionKey(int cnd, int pnd) {
            if (pnd <= 0) {
                return 1;
            }
            return 0;
        }

        private Integer checkExprs(List<ExprNodeDesc> ckeys, List<ExprNodeDesc> pkeys, ReduceSinkOperator cRS, ReduceSinkOperator pRS) throws SemanticException {
            Integer moveKeyColTo = 0;
            if (ckeys == null || ckeys.isEmpty()) {
                if (pkeys != null && !pkeys.isEmpty()) {
                    moveKeyColTo = -1;
                }
            } else if (pkeys == null || pkeys.isEmpty()) {
                for (ExprNodeDesc ckey : ckeys) {
                    if (ExprNodeDescUtils.backtrack(ckey, cRS, pRS) != null) continue;
                    return null;
                }
                moveKeyColTo = 1;
            } else {
                moveKeyColTo = this.sameKeys(ckeys, pkeys, cRS, pRS);
            }
            return moveKeyColTo;
        }

        protected Integer sameKeys(List<ExprNodeDesc> cexprs, List<ExprNodeDesc> pexprs, Operator<?> child, Operator<?> parent) throws SemanticException {
            int i;
            int common = Math.min(cexprs.size(), pexprs.size());
            int limit = Math.max(cexprs.size(), pexprs.size());
            for (i = 0; i < common; ++i) {
                ExprNodeDesc pexpr = pexprs.get(i);
                ExprNodeDesc cexpr = ExprNodeDescUtils.backtrack(cexprs.get(i), child, parent);
                if (cexpr != null && pexpr.isSame(cexpr)) continue;
                return null;
            }
            while (i < limit) {
                if (cexprs.size() > pexprs.size() && ExprNodeDescUtils.backtrack(cexprs.get(i), child, parent) == null) {
                    return null;
                }
                ++i;
            }
            return Integer.valueOf(cexprs.size()).compareTo(pexprs.size());
        }

        protected Integer checkOrder(String corder, String porder) {
            if (corder == null || corder.trim().equals("")) {
                if (porder == null || porder.trim().equals("")) {
                    return 0;
                }
                return -1;
            }
            if (porder == null || porder.trim().equals("")) {
                return 1;
            }
            corder = corder.trim();
            porder = porder.trim();
            int target = Math.min(corder.length(), porder.length());
            if (!corder.substring(0, target).equals(porder.substring(0, target))) {
                return null;
            }
            return Integer.valueOf(corder.length()).compareTo(porder.length());
        }

        protected Integer checkNumReducer(int creduce, int preduce) {
            if (creduce < 0) {
                if (preduce < 0) {
                    return 0;
                }
                return -1;
            }
            if (preduce < 0) {
                return 1;
            }
            if (creduce != preduce) {
                return null;
            }
            return 0;
        }
    }

    static class DefaultProc
    implements NodeProcessor {
        DefaultProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    static class ReduceSinkDeduplicateProcFactory {
        ReduceSinkDeduplicateProcFactory() {
        }

        public static NodeProcessor getReducerReducerProc() {
            return new ReducerReducerProc();
        }

        public static NodeProcessor getGroupbyReducerProc() {
            return new GroupbyReducerProc();
        }

        public static NodeProcessor getJoinReducerProc() {
            return new JoinReducerProc();
        }

        public static NodeProcessor getDefaultProc() {
            return new DefaultProc();
        }
    }

    protected class ReduceSinkDeduplicateProcCtx
    extends AbstractCorrelationProcCtx {
        public ReduceSinkDeduplicateProcCtx(ParseContext pctx) {
            super(pctx);
        }
    }
}

