/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFTimestampFieldLong;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public final class VectorUDFUnixTimeStampLong
extends VectorUDFTimestampFieldLong {
    private static final long serialVersionUID = 1L;

    @Override
    protected long getTimestampField(long time) {
        long ms = time / 1000000000L * 1000L;
        long remainder = time % 1000000000L;
        if (remainder < 0L) {
            ms -= 1000L;
        }
        return ms / 1000L;
    }

    @Override
    protected long getDateField(long days) {
        long ms = DateWritable.daysToMillis((int)days);
        return ms / 1000L;
    }

    public VectorUDFUnixTimeStampLong(int colNum, int outputColumn) {
        super(-1, colNum, outputColumn);
    }

    public VectorUDFUnixTimeStampLong() {
    }
}

