/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ISetLongArg;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncLongToLong;

public class PosModLongToLong
extends MathFuncLongToLong
implements ISetLongArg {
    private static final long serialVersionUID = 1L;
    private long divisor;

    public PosModLongToLong(int inputCol, long scalarVal, int outputCol) {
        super(inputCol, outputCol);
        this.divisor = scalarVal;
    }

    public PosModLongToLong() {
    }

    @Override
    protected long func(long v) {
        return (v % this.divisor + this.divisor) % this.divisor;
    }

    @Override
    public void setArg(long arg) {
        this.divisor = arg;
    }

    public void setDivisor(long v) {
        this.divisor = v;
    }

    public long getDivisor() {
        return this.divisor;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

