/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.ReflectionUtils;

public class SkewJoinHandler {
    protected static final Log LOG = LogFactory.getLog((String)SkewJoinHandler.class.getName());
    public int currBigKeyTag = -1;
    private int rowNumber = 0;
    private int currTag = -1;
    private int skewKeyDefinition = -1;
    private Map<Byte, StructObjectInspector> skewKeysTableObjectInspector = null;
    private Map<Byte, SerDe> tblSerializers = null;
    private Map<Byte, TableDesc> tblDesc = null;
    private Map<Byte, Boolean> bigKeysExistingMap = null;
    private LongWritable skewjoinFollowupJobs;
    private final boolean noOuterJoin;
    Configuration hconf = null;
    List<Object> dummyKey = null;
    String taskId;
    private final CommonJoinOperator<? extends OperatorDesc> joinOp;
    private final int numAliases;
    private final JoinDesc conf;
    boolean skewKeyInCurrentGroup = false;

    public SkewJoinHandler(CommonJoinOperator<? extends OperatorDesc> joinOp) {
        this.joinOp = joinOp;
        this.numAliases = joinOp.numAliases;
        this.conf = (JoinDesc)joinOp.getConf();
        this.noOuterJoin = joinOp.noOuterJoin;
    }

    public void initiliaze(Configuration hconf) {
        Byte alias;
        int i;
        this.hconf = hconf;
        JoinDesc desc = (JoinDesc)this.joinOp.getConf();
        this.skewKeyDefinition = desc.getSkewKeyDefinition();
        this.skewKeysTableObjectInspector = new HashMap<Byte, StructObjectInspector>(this.numAliases);
        this.tblDesc = desc.getSkewKeysValuesTables();
        this.tblSerializers = new HashMap<Byte, SerDe>(this.numAliases);
        this.bigKeysExistingMap = new HashMap<Byte, Boolean>(this.numAliases);
        this.taskId = Utilities.getTaskId(hconf);
        int[][] filterMap = desc.getFilterMap();
        for (i = 0; i < this.numAliases; ++i) {
            alias = this.conf.getTagOrder()[i];
            ArrayList<ObjectInspector> skewTableKeyInspectors = new ArrayList<ObjectInspector>();
            StructObjectInspector soi = (StructObjectInspector)this.joinOp.inputObjInspectors[alias];
            StructField sf = soi.getStructFieldRef(Utilities.ReduceField.KEY.toString());
            List<? extends StructField> keyFields = ((StructObjectInspector)sf.getFieldObjectInspector()).getAllStructFieldRefs();
            int keyFieldSize = keyFields.size();
            for (int k = 0; k < keyFieldSize; ++k) {
                skewTableKeyInspectors.add(keyFields.get(k).getFieldObjectInspector());
            }
            TableDesc joinKeyDesc = desc.getKeyTableDesc();
            List<String> keyColNames = Utilities.getColumnNames(joinKeyDesc.getProperties());
            StandardStructObjectInspector structTblKeyInpector = ObjectInspectorFactory.getStandardStructObjectInspector(keyColNames, skewTableKeyInspectors);
            try {
                SerDe serializer = (SerDe)ReflectionUtils.newInstance(this.tblDesc.get(alias).getDeserializerClass(), null);
                SerDeUtils.initializeSerDe(serializer, null, this.tblDesc.get(alias).getProperties(), null);
                this.tblSerializers.put((byte)i, serializer);
            }
            catch (SerDeException e) {
                LOG.error((Object)("Skewjoin will be disabled due to " + e.getMessage()), (Throwable)e);
                this.joinOp.handleSkewJoin = false;
                break;
            }
            boolean hasFilter = filterMap != null && filterMap[i] != null;
            TableDesc valTblDesc = JoinUtil.getSpillTableDesc(alias, this.joinOp.spillTableDesc, this.conf, !hasFilter);
            List<String> valColNames = new ArrayList<String>();
            if (valTblDesc != null) {
                valColNames = Utilities.getColumnNames(valTblDesc.getProperties());
            }
            StandardStructObjectInspector structTblValInpector = ObjectInspectorFactory.getStandardStructObjectInspector(valColNames, this.joinOp.joinValuesStandardObjectInspectors[i]);
            UnionStructObjectInspector structTblInpector = ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(structTblValInpector, structTblKeyInpector));
            this.skewKeysTableObjectInspector.put((byte)i, structTblInpector);
        }
        for (i = 0; i < this.numAliases; ++i) {
            alias = this.conf.getTagOrder()[i];
            RowContainer rc = (RowContainer)this.joinOp.storage[i];
            if (rc == null) continue;
            rc.setSerDe(this.tblSerializers.get((byte)i), this.skewKeysTableObjectInspector.get((byte)i));
            rc.setTableDesc(this.tblDesc.get(alias));
        }
    }

    void endGroup() throws IOException, HiveException {
        if (this.skewKeyInCurrentGroup) {
            Path specPath = this.conf.getBigKeysDirMap().get((byte)this.currBigKeyTag);
            RowContainer bigKey = (RowContainer)this.joinOp.storage[this.currBigKeyTag];
            Path outputPath = this.getOperatorOutputPath(specPath);
            FileSystem destFs = outputPath.getFileSystem(this.hconf);
            bigKey.copyToDFSDirecory(destFs, outputPath);
            for (int i = 0; i < this.numAliases; ++i) {
                RowContainer values;
                if ((byte)i == this.currBigKeyTag || (values = (RowContainer)this.joinOp.storage[i]) == null) continue;
                specPath = this.conf.getSmallKeysDirMap().get((byte)this.currBigKeyTag).get((byte)i);
                values.copyToDFSDirecory(destFs, this.getOperatorOutputPath(specPath));
            }
        }
        this.skewKeyInCurrentGroup = false;
    }

    public void handleSkew(int tag) throws HiveException {
        if (this.joinOp.newGroupStarted || tag != this.currTag) {
            this.rowNumber = 0;
            this.currTag = tag;
        }
        if (this.joinOp.newGroupStarted) {
            this.currBigKeyTag = -1;
            this.joinOp.newGroupStarted = false;
            this.dummyKey = (List)this.joinOp.getGroupKeyObject();
            this.skewKeyInCurrentGroup = false;
            for (int i = 0; i < this.numAliases; ++i) {
                RowContainer rc = (RowContainer)this.joinOp.storage[i];
                if (rc == null) continue;
                rc.setKeyObject(this.dummyKey);
            }
        }
        ++this.rowNumber;
        if (this.currBigKeyTag == -1 && tag < this.numAliases - 1 && this.rowNumber >= this.skewKeyDefinition) {
            this.currBigKeyTag = tag;
            this.updateSkewJoinJobCounter(tag);
            if (!(this.dummyKey instanceof List)) {
                throw new RuntimeException("Bug in handle skew key in a seperate job.");
            }
            this.skewKeyInCurrentGroup = true;
            this.bigKeysExistingMap.put((byte)this.currBigKeyTag, Boolean.TRUE);
        }
    }

    public void close(boolean abort) throws HiveException {
        if (!abort) {
            try {
                this.endGroup();
                this.commit();
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            for (int bigKeyTbl = 0; bigKeyTbl < this.numAliases; ++bigKeyTbl) {
                if (!this.bigKeysExistingMap.get((byte)bigKeyTbl).booleanValue()) continue;
                try {
                    Path specPath = this.conf.getBigKeysDirMap().get((byte)bigKeyTbl);
                    Path bigKeyPath = this.getOperatorOutputPath(specPath);
                    FileSystem fs = bigKeyPath.getFileSystem(this.hconf);
                    this.delete(bigKeyPath, fs);
                    for (int smallKeyTbl = 0; smallKeyTbl < this.numAliases; ++smallKeyTbl) {
                        if ((byte)smallKeyTbl == bigKeyTbl) continue;
                        specPath = this.conf.getSmallKeysDirMap().get((byte)bigKeyTbl).get((byte)smallKeyTbl);
                        this.delete(this.getOperatorOutputPath(specPath), fs);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        }
    }

    private void delete(Path operatorOutputPath, FileSystem fs) {
        try {
            fs.delete(operatorOutputPath, true);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    private void commit() throws IOException {
        for (int bigKeyTbl = 0; bigKeyTbl < this.numAliases; ++bigKeyTbl) {
            Boolean existing = this.bigKeysExistingMap.get((byte)bigKeyTbl);
            if (existing == null || !existing.booleanValue()) continue;
            Path specPath = this.conf.getBigKeysDirMap().get((byte)bigKeyTbl);
            this.commitOutputPathToFinalPath(specPath, false);
            for (int smallKeyTbl = 0; smallKeyTbl < this.numAliases; ++smallKeyTbl) {
                if (smallKeyTbl == bigKeyTbl) continue;
                specPath = this.conf.getSmallKeysDirMap().get((byte)bigKeyTbl).get((byte)smallKeyTbl);
                this.commitOutputPathToFinalPath(specPath, true);
            }
        }
    }

    private void commitOutputPathToFinalPath(Path specPath, boolean ignoreNonExisting) throws IOException {
        Path outPath = this.getOperatorOutputPath(specPath);
        Path finalPath = this.getOperatorFinalPath(specPath);
        FileSystem fs = outPath.getFileSystem(this.hconf);
        if (ignoreNonExisting && !fs.exists(outPath)) {
            return;
        }
        if (!fs.rename(outPath, finalPath)) {
            throw new IOException("Unable to rename output to: " + finalPath);
        }
    }

    private Path getOperatorOutputPath(Path specPath) throws IOException {
        return new Path(Utilities.toTempPath(specPath), Utilities.toTempPath(this.taskId));
    }

    private Path getOperatorFinalPath(Path specPath) throws IOException {
        return new Path(Utilities.toTempPath(specPath), this.taskId);
    }

    public void setSkewJoinJobCounter(LongWritable skewjoinFollowupJobs) {
        this.skewjoinFollowupJobs = skewjoinFollowupJobs;
    }

    public void updateSkewJoinJobCounter(int tag) {
        this.skewjoinFollowupJobs.set(this.skewjoinFollowupJobs.get() + 1L);
    }
}

