/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class PTFRollingPartition
extends PTFPartition {
    int numRowsProcessed;
    int precedingSpan;
    int followingSpan;
    int numRowsReceived;
    List<Object> currWindow;

    protected PTFRollingPartition(Configuration cfg, SerDe serDe, StructObjectInspector inputOI, StructObjectInspector outputOI, int precedingSpan, int succeedingSpan) throws HiveException {
        super(cfg, serDe, inputOI, outputOI, false);
        this.precedingSpan = precedingSpan;
        this.followingSpan = succeedingSpan;
        this.currWindow = new ArrayList<Object>(precedingSpan + this.followingSpan);
    }

    @Override
    public void reset() throws HiveException {
        this.currWindow.clear();
        this.numRowsProcessed = 0;
        this.numRowsReceived = 0;
    }

    @Override
    public Object getAt(int i) throws HiveException {
        int rangeStart = this.numRowsReceived - this.currWindow.size();
        return this.currWindow.get(i - rangeStart);
    }

    @Override
    public void append(Object o) throws HiveException {
        List l = (List)ObjectInspectorUtils.copyToStandardObject(o, this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        this.currWindow.add(l);
        ++this.numRowsReceived;
    }

    public Object nextOutputRow() throws HiveException {
        Object row = this.getAt(this.numRowsProcessed);
        ++this.numRowsProcessed;
        if (this.numRowsProcessed > this.precedingSpan) {
            this.currWindow.remove(0);
        }
        return row;
    }

    public boolean processedAllRows() {
        return this.numRowsProcessed >= this.numRowsReceived;
    }

    public int rowToProcess(WindowFunctionDef wFn) {
        int rowToProcess = this.numRowsReceived - wFn.getWindowFrame().getEnd().getAmt() - 1;
        return rowToProcess >= 0 ? rowToProcess : -1;
    }

    @Override
    public int size() {
        return this.numRowsReceived;
    }

    @Override
    public PTFPartition.PTFPartitionIterator<Object> iterator() throws HiveException {
        return new RollingPItr();
    }

    @Override
    public void close() {
    }

    class RollingPItr
    implements PTFPartition.PTFPartitionIterator<Object> {
        RollingPItr() {
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex() {
            return PTFRollingPartition.this.numRowsProcessed;
        }

        @Override
        public Object lead(int amt) throws HiveException {
            int i = PTFRollingPartition.this.numRowsProcessed + amt;
            i = i >= PTFRollingPartition.this.numRowsReceived ? PTFRollingPartition.this.numRowsReceived - 1 : i;
            return PTFRollingPartition.this.getAt(i);
        }

        @Override
        public Object lag(int amt) throws HiveException {
            int i = PTFRollingPartition.this.numRowsProcessed - amt;
            int start = PTFRollingPartition.this.numRowsReceived - PTFRollingPartition.this.currWindow.size();
            i = i < start ? start : i;
            return PTFRollingPartition.this.getAt(i);
        }

        @Override
        public Object resetToIndex(int idx) throws HiveException {
            return PTFRollingPartition.this.getAt(idx);
        }

        @Override
        public PTFPartition getPartition() {
            return PTFRollingPartition.this;
        }

        @Override
        public void reset() throws HiveException {
        }
    }
}

