/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module.hive;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.ModuleFactory;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.hive.HiveModule;
import org.apache.flink.table.module.hive.HiveModuleDescriptorValidator;

public class HiveModuleFactory
implements ModuleFactory {
    public Module createModule(Map<String, String> properties) {
        DescriptorProperties descProperties = HiveModuleFactory.getValidatedProperties(properties);
        String hiveVersion = descProperties.getOptionalString("hive-version").orElse(HiveShimLoader.getHiveVersion());
        return new HiveModule(hiveVersion);
    }

    private static DescriptorProperties getValidatedProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        new HiveModuleDescriptorValidator().validate(descriptorProperties);
        return descriptorProperties;
    }

    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("type", "hive");
        return context;
    }

    public List<String> supportedProperties() {
        return Arrays.asList("hive-version");
    }
}

