/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.HiveScalarFunction;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.functions.hive.conversion.HiveObjectConversion;
import org.apache.flink.table.functions.hive.conversion.IdentityConversion;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HiveSimpleUDF
extends HiveScalarFunction<UDF> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSimpleUDF.class);
    private transient Method method;
    private transient GenericUDFUtils.ConversionHelper conversionHelper;
    private transient HiveObjectConversion[] conversions;
    private transient boolean allIdentityConverter;
    private HiveShim hiveShim;

    public HiveSimpleUDF(HiveFunctionWrapper<UDF> hiveFunctionWrapper, HiveShim hiveShim) {
        super(hiveFunctionWrapper);
        this.hiveShim = hiveShim;
        LOG.info("Creating HiveSimpleUDF from '{}'", (Object)this.hiveFunctionWrapper.getClassName());
    }

    @Override
    public void openInternal() {
        LOG.info("Opening HiveSimpleUDF as '{}'", (Object)this.hiveFunctionWrapper.getClassName());
        this.function = this.hiveFunctionWrapper.createFunction();
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        for (DataType arg : this.argTypes) {
            typeInfos.add(HiveTypeUtil.toHiveTypeInfo(arg, false));
        }
        try {
            int i;
            this.method = ((UDF)this.function).getResolver().getEvalMethod(typeInfos);
            this.returnInspector = ObjectInspectorFactory.getReflectionObjectInspector(this.method.getGenericReturnType(), ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            ObjectInspector[] argInspectors = new ObjectInspector[typeInfos.size()];
            for (i = 0; i < this.argTypes.length; ++i) {
                argInspectors[i] = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfos.get(i));
            }
            this.conversionHelper = new GenericUDFUtils.ConversionHelper(this.method, argInspectors);
            this.conversions = new HiveObjectConversion[argInspectors.length];
            for (i = 0; i < argInspectors.length; ++i) {
                this.conversions[i] = HiveInspectors.getConversion(argInspectors[i], this.argTypes[i].getLogicalType(), this.hiveShim);
            }
            this.allIdentityConverter = Arrays.stream(this.conversions).allMatch(conv -> conv instanceof IdentityConversion);
        }
        catch (Exception e) {
            throw new FlinkHiveUDFException(String.format("Failed to open HiveSimpleUDF from %s", this.hiveFunctionWrapper.getClassName()), e);
        }
    }

    @Override
    public Object evalInternal(Object[] args) {
        Preconditions.checkArgument((args.length == this.conversions.length ? 1 : 0) != 0);
        if (!this.allIdentityConverter) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.conversions[i].toHiveObject(args[i]);
            }
        }
        try {
            Object result = FunctionRegistry.invoke(this.method, this.function, this.conversionHelper.convertIfNecessary(args));
            return HiveInspectors.toFlinkObject(this.returnInspector, result, this.hiveShim);
        }
        catch (HiveException e) {
            throw new FlinkHiveUDFException(e);
        }
    }

    @Override
    public DataType getHiveResultType(Object[] constantArguments, DataType[] argTypes) {
        try {
            ArrayList<TypeInfo> argTypeInfo = new ArrayList<TypeInfo>();
            for (DataType argType : argTypes) {
                argTypeInfo.add(HiveTypeUtil.toHiveTypeInfo(argType, false));
            }
            Method evalMethod = ((UDF)this.hiveFunctionWrapper.createFunction()).getResolver().getEvalMethod(argTypeInfo);
            return HiveTypeUtil.toFlinkType(ObjectInspectorFactory.getReflectionObjectInspector(evalMethod.getGenericReturnType(), ObjectInspectorFactory.ObjectInspectorOptions.JAVA));
        }
        catch (UDFArgumentException e) {
            throw new FlinkHiveUDFException(e);
        }
    }
}

