/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class HiveReflectionUtils {
    public static Properties getTableMetadata(HiveShim hiveShim, Table table) {
        try {
            Method method = hiveShim.getMetaStoreUtilsClass().getMethod("getTableMetadata", Table.class);
            return (Properties)method.invoke(null, table);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to invoke MetaStoreUtils.getTableMetadata()", (Throwable)e);
        }
    }

    public static List<String> getPvals(HiveShim hiveShim, List<FieldSchema> partCols, Map<String, String> partSpec) {
        try {
            Method method = hiveShim.getMetaStoreUtilsClass().getMethod("getPvals", List.class, Map.class);
            return (List)method.invoke(null, partCols, partSpec);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to invoke MetaStoreUtils.getFieldsFromDeserializer", (Throwable)e);
        }
    }

    public static ObjectInspector createConstantObjectInspector(String className, Object value) {
        try {
            Constructor<?> method = Class.forName(className).getDeclaredConstructor(value.getClass());
            method.setAccessible(true);
            return (ObjectInspector)method.newInstance(value);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new FlinkHiveUDFException("Failed to instantiate java constant object inspector", e);
        }
    }

    public static Object invokeMethod(Class clz, Object obj, String methodName, Class[] argClz, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method;
        try {
            method = clz.getDeclaredMethod(methodName, argClz);
        }
        catch (NoSuchMethodException e) {
            method = clz.getMethod(methodName, argClz);
        }
        return method.invoke(obj, args);
    }
}

