/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.writer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.orc.vector.Vectorizer;
import org.apache.flink.orc.writer.OrcBulkWriter;
import org.apache.flink.orc.writer.PhysicalWriterImpl;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcFile;
import org.apache.orc.impl.WriterImpl;

@PublicEvolving
public class OrcBulkWriterFactory<T>
implements BulkWriter.Factory<T> {
    private final Vectorizer<T> vectorizer;
    private final Properties writerProperties;
    private final Map<String, String> confMap;
    private OrcFile.WriterOptions writerOptions;

    public OrcBulkWriterFactory(Vectorizer<T> vectorizer) {
        this(vectorizer, new Configuration());
    }

    public OrcBulkWriterFactory(Vectorizer<T> vectorizer, Configuration configuration) {
        this(vectorizer, null, configuration);
    }

    public OrcBulkWriterFactory(Vectorizer<T> vectorizer, Properties writerProperties, Configuration configuration) {
        this.vectorizer = (Vectorizer)Preconditions.checkNotNull(vectorizer);
        this.writerProperties = writerProperties;
        this.confMap = new HashMap<String, String>();
        for (Map.Entry entry : configuration) {
            this.confMap.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public BulkWriter<T> create(FSDataOutputStream out) throws IOException {
        OrcFile.WriterOptions opts = this.getWriterOptions();
        opts.physicalWriter(new PhysicalWriterImpl(out, opts));
        Path unusedPath = new Path(UUID.randomUUID().toString());
        return new OrcBulkWriter<T>(this.vectorizer, new WriterImpl(null, unusedPath, opts));
    }

    @VisibleForTesting
    protected OrcFile.WriterOptions getWriterOptions() {
        if (null == this.writerOptions) {
            Configuration conf = new Configuration();
            for (Map.Entry<String, String> entry : this.confMap.entrySet()) {
                conf.set(entry.getKey(), entry.getValue());
            }
            this.writerOptions = OrcFile.writerOptions(this.writerProperties, conf);
            this.writerOptions.setSchema(this.vectorizer.getSchema());
        }
        return this.writerOptions;
    }
}

