/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.nohive.shim;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcSplitReader;
import org.apache.flink.orc.nohive.vector.OrcNoHiveBatchWrapper;
import org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.orc.shim.OrcShimV200;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class OrcNoHiveShim
implements OrcShim<VectorizedRowBatch> {
    private static final long serialVersionUID = 1L;

    @Override
    public RecordReader createRecordReader(Configuration conf, TypeDescription schema, int[] selectedFields, List<OrcSplitReader.Predicate> conjunctPredicates, Path path, long splitStart, long splitLength) throws IOException {
        org.apache.hadoop.fs.Path hPath = new org.apache.hadoop.fs.Path(path.toUri());
        Reader orcReader = OrcFile.createReader(hPath, OrcFile.readerOptions(conf));
        Tuple2<Long, Long> offsetAndLength = OrcShimV200.getOffsetAndLengthForSplit(splitStart, splitLength, orcReader.getStripes());
        Reader.Options options = new Reader.Options().schema(schema).range((Long)offsetAndLength.f0, (Long)offsetAndLength.f1).useZeroCopy(OrcConf.USE_ZEROCOPY.getBoolean(conf)).skipCorruptRecords(OrcConf.SKIP_CORRUPT_DATA.getBoolean(conf)).tolerateMissingSchema(OrcConf.TOLERATE_MISSING_SCHEMA.getBoolean(conf));
        options.include(OrcShimV200.computeProjectionMask(schema, selectedFields));
        RecordReader orcRowsReader = orcReader.rows(options);
        schema.getId();
        return orcRowsReader;
    }

    public OrcNoHiveBatchWrapper createBatchWrapper(TypeDescription schema, int batchSize) {
        return new OrcNoHiveBatchWrapper(schema.createRowBatch(batchSize));
    }

    @Override
    public boolean nextBatch(RecordReader reader, VectorizedRowBatch rowBatch) throws IOException {
        return reader.nextBatch(rowBatch);
    }
}

