/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.orc.OrcBatchReader;
import org.apache.flink.orc.OrcRowInputFormat;
import org.apache.flink.orc.OrcSplitReader;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.expressions.Attribute;
import org.apache.flink.table.expressions.BinaryComparison;
import org.apache.flink.table.expressions.EqualTo;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.GreaterThan;
import org.apache.flink.table.expressions.GreaterThanOrEqual;
import org.apache.flink.table.expressions.IsNotNull;
import org.apache.flink.table.expressions.IsNull;
import org.apache.flink.table.expressions.LessThan;
import org.apache.flink.table.expressions.LessThanOrEqual;
import org.apache.flink.table.expressions.Literal;
import org.apache.flink.table.expressions.Not;
import org.apache.flink.table.expressions.NotEqualTo;
import org.apache.flink.table.expressions.Or;
import org.apache.flink.table.expressions.UnaryExpression;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcTableSource
implements BatchTableSource<Row>,
ProjectableTableSource<Row>,
FilterableTableSource<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(OrcTableSource.class);
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private final String path;
    private final TypeDescription orcSchema;
    private final TableSchema tableSchema;
    private final Configuration orcConfig;
    private final int batchSize;
    private final boolean recursiveEnumeration;
    private final RowTypeInfo typeInfo;
    private final int[] selectedFields;
    private final OrcSplitReader.Predicate[] predicates;

    private OrcTableSource(String path, TypeDescription orcSchema, Configuration orcConfig, int batchSize, boolean recursiveEnumeration) {
        this(path, orcSchema, orcConfig, batchSize, recursiveEnumeration, null, null);
    }

    private OrcTableSource(String path, TypeDescription orcSchema, Configuration orcConfig, int batchSize, boolean recursiveEnumeration, int[] selectedFields, OrcSplitReader.Predicate[] predicates) {
        Preconditions.checkNotNull((Object)path, (String)"Path must not be null.");
        Preconditions.checkNotNull((Object)orcSchema, (String)"OrcSchema must not be null.");
        Preconditions.checkNotNull((Object)path, (String)"Configuration must not be null.");
        Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"Batch size must be larger than null.");
        this.path = path;
        this.orcSchema = orcSchema;
        this.orcConfig = orcConfig;
        this.batchSize = batchSize;
        this.recursiveEnumeration = recursiveEnumeration;
        this.selectedFields = selectedFields;
        this.predicates = predicates;
        RowTypeInfo typeInfoFromSchema = (RowTypeInfo)OrcBatchReader.schemaToTypeInfo(this.orcSchema);
        this.typeInfo = selectedFields == null ? typeInfoFromSchema : RowTypeInfo.projectFields((RowTypeInfo)typeInfoFromSchema, (int[])selectedFields);
        this.tableSchema = new TableSchema(typeInfoFromSchema.getFieldNames(), typeInfoFromSchema.getFieldTypes());
    }

    public DataSet<Row> getDataSet(ExecutionEnvironment execEnv) {
        OrcRowInputFormat orcIF = this.buildOrcInputFormat();
        orcIF.setNestedFileEnumeration(this.recursiveEnumeration);
        if (this.selectedFields != null) {
            orcIF.selectFields(this.selectedFields);
        }
        if (this.predicates != null) {
            for (OrcSplitReader.Predicate pred : this.predicates) {
                orcIF.addPredicate(pred);
            }
        }
        return execEnv.createInput((InputFormat)orcIF).name(this.explainSource());
    }

    @VisibleForTesting
    protected OrcRowInputFormat buildOrcInputFormat() {
        return new OrcRowInputFormat(this.path, this.orcSchema, this.orcConfig, this.batchSize);
    }

    public TypeInformation<Row> getReturnType() {
        return this.typeInfo;
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public TableSource<Row> projectFields(int[] selectedFields) {
        return new OrcTableSource(this.path, this.orcSchema, this.orcConfig, this.batchSize, this.recursiveEnumeration, selectedFields, this.predicates);
    }

    public TableSource<Row> applyPredicate(List<Expression> predicates) {
        ArrayList<OrcSplitReader.Predicate> orcPredicates = new ArrayList<OrcSplitReader.Predicate>();
        for (Expression pred : predicates) {
            OrcSplitReader.Predicate orcPred = this.toOrcPredicate(pred);
            if (orcPred != null) {
                LOG.info("Predicate [{}] converted into OrcPredicate [{}] and pushed into OrcTableSource for path {}.", new Object[]{pred, orcPred, this.path});
                orcPredicates.add(orcPred);
                continue;
            }
            LOG.info("Predicate [{}] could not be pushed into OrcTableSource for path {}.", (Object)pred, (Object)this.path);
        }
        return new OrcTableSource(this.path, this.orcSchema, this.orcConfig, this.batchSize, this.recursiveEnumeration, this.selectedFields, orcPredicates.toArray(new OrcSplitReader.Predicate[0]));
    }

    public boolean isFilterPushedDown() {
        return this.predicates != null;
    }

    public String explainSource() {
        return "OrcFile[path=" + this.path + ", schema=" + this.orcSchema + ", filter=" + this.predicateString() + ", selectedFields=" + Arrays.toString(this.selectedFields) + "]";
    }

    private String predicateString() {
        if (this.predicates == null) {
            return "NULL";
        }
        if (this.predicates.length == 0) {
            return "TRUE";
        }
        return "AND(" + Arrays.toString(this.predicates) + ")";
    }

    private OrcSplitReader.Predicate toOrcPredicate(Expression pred) {
        if (pred instanceof Or) {
            OrcSplitReader.Predicate c1 = this.toOrcPredicate((Expression)((Or)pred).left());
            OrcSplitReader.Predicate c2 = this.toOrcPredicate((Expression)((Or)pred).right());
            if (c1 == null || c2 == null) {
                return null;
            }
            return new OrcSplitReader.Or(c1, c2);
        }
        if (pred instanceof Not) {
            OrcSplitReader.Predicate c = this.toOrcPredicate((Expression)((Not)pred).child());
            if (c == null) {
                return null;
            }
            return new OrcSplitReader.Not(c);
        }
        if (pred instanceof BinaryComparison) {
            BinaryComparison binComp = (BinaryComparison)pred;
            if (!this.isValid(binComp)) {
                LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcTableSource.", (Object)pred);
                return null;
            }
            PredicateLeaf.Type litType = this.getLiteralType(binComp);
            if (litType == null) {
                LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcTableSource.", (Object)pred);
                return null;
            }
            boolean literalOnRight = this.literalOnRight(binComp);
            String colName = this.getColumnName(binComp);
            Object literalObj = this.getLiteral(binComp);
            if (!(literalObj instanceof Serializable)) {
                LOG.warn("Encountered a non-serializable literal of type {}. Cannot push predicate [{}] into OrcTableSource. This is a bug and should be reported.", (Object)literalObj.getClass().getCanonicalName(), (Object)pred);
                return null;
            }
            Serializable literal = (Serializable)literalObj;
            if (pred instanceof EqualTo) {
                return new OrcSplitReader.Equals(colName, litType, literal);
            }
            if (pred instanceof NotEqualTo) {
                return new OrcSplitReader.Not(new OrcSplitReader.Equals(colName, litType, literal));
            }
            if (pred instanceof GreaterThan) {
                if (literalOnRight) {
                    return new OrcSplitReader.Not(new OrcSplitReader.LessThanEquals(colName, litType, literal));
                }
                return new OrcSplitReader.LessThan(colName, litType, literal);
            }
            if (pred instanceof GreaterThanOrEqual) {
                if (literalOnRight) {
                    return new OrcSplitReader.Not(new OrcSplitReader.LessThan(colName, litType, literal));
                }
                return new OrcSplitReader.LessThanEquals(colName, litType, literal);
            }
            if (pred instanceof LessThan) {
                if (literalOnRight) {
                    return new OrcSplitReader.LessThan(colName, litType, literal);
                }
                return new OrcSplitReader.Not(new OrcSplitReader.LessThanEquals(colName, litType, literal));
            }
            if (pred instanceof LessThanOrEqual) {
                if (literalOnRight) {
                    return new OrcSplitReader.LessThanEquals(colName, litType, literal);
                }
                return new OrcSplitReader.Not(new OrcSplitReader.LessThan(colName, litType, literal));
            }
            LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcTableSource.", (Object)pred);
            return null;
        }
        if (pred instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)pred;
            if (!this.isValid(unary)) {
                LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcTableSource.", (Object)pred);
                return null;
            }
            PredicateLeaf.Type colType = this.toOrcType(((UnaryExpression)pred).child().resultType());
            if (colType == null) {
                LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcTableSource.", (Object)pred);
                return null;
            }
            String colName = this.getColumnName(unary);
            if (pred instanceof IsNull) {
                return new OrcSplitReader.IsNull(colName, colType);
            }
            if (pred instanceof IsNotNull) {
                return new OrcSplitReader.Not(new OrcSplitReader.IsNull(colName, colType));
            }
            LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcTableSource.", (Object)pred);
            return null;
        }
        LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcTableSource.", (Object)pred);
        return null;
    }

    private boolean isValid(UnaryExpression unary) {
        return unary.child() instanceof Attribute;
    }

    private boolean isValid(BinaryComparison comp) {
        return comp.left() instanceof Literal && comp.right() instanceof Attribute || comp.left() instanceof Attribute && comp.right() instanceof Literal;
    }

    private boolean literalOnRight(BinaryComparison comp) {
        if (comp.left() instanceof Literal && comp.right() instanceof Attribute) {
            return false;
        }
        if (comp.left() instanceof Attribute && comp.right() instanceof Literal) {
            return true;
        }
        throw new RuntimeException("Invalid binary comparison.");
    }

    private String getColumnName(UnaryExpression unary) {
        return ((Attribute)unary.child()).name();
    }

    private String getColumnName(BinaryComparison comp) {
        if (this.literalOnRight(comp)) {
            return ((Attribute)comp.left()).name();
        }
        return ((Attribute)comp.right()).name();
    }

    private PredicateLeaf.Type getLiteralType(BinaryComparison comp) {
        if (this.literalOnRight(comp)) {
            return this.toOrcType(((Literal)comp.right()).resultType());
        }
        return this.toOrcType(((Literal)comp.left()).resultType());
    }

    private Object getLiteral(BinaryComparison comp) {
        if (this.literalOnRight(comp)) {
            return ((Literal)comp.right()).value();
        }
        return ((Literal)comp.left()).value();
    }

    private PredicateLeaf.Type toOrcType(TypeInformation<?> type) {
        if (type == BasicTypeInfo.BYTE_TYPE_INFO || type == BasicTypeInfo.SHORT_TYPE_INFO || type == BasicTypeInfo.INT_TYPE_INFO || type == BasicTypeInfo.LONG_TYPE_INFO) {
            return PredicateLeaf.Type.LONG;
        }
        if (type == BasicTypeInfo.FLOAT_TYPE_INFO || type == BasicTypeInfo.DOUBLE_TYPE_INFO) {
            return PredicateLeaf.Type.FLOAT;
        }
        if (type == BasicTypeInfo.BOOLEAN_TYPE_INFO) {
            return PredicateLeaf.Type.BOOLEAN;
        }
        if (type == BasicTypeInfo.STRING_TYPE_INFO) {
            return PredicateLeaf.Type.STRING;
        }
        if (type == SqlTimeTypeInfo.TIMESTAMP) {
            return PredicateLeaf.Type.TIMESTAMP;
        }
        if (type == SqlTimeTypeInfo.DATE) {
            return PredicateLeaf.Type.DATE;
        }
        if (type == BasicTypeInfo.BIG_DEC_TYPE_INFO) {
            return PredicateLeaf.Type.DECIMAL;
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String path;
        private TypeDescription schema;
        private Configuration config;
        private int batchSize = 0;
        private boolean recursive = true;

        public Builder path(String path) {
            Preconditions.checkNotNull((Object)path, (String)"Path must not be null.");
            Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty.");
            this.path = path;
            return this;
        }

        public Builder path(String path, boolean recursive) {
            Preconditions.checkNotNull((Object)path, (String)"Path must not be null.");
            Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty.");
            this.path = path;
            this.recursive = recursive;
            return this;
        }

        public Builder forOrcSchema(String orcSchema) {
            Preconditions.checkNotNull((Object)orcSchema, (String)"ORC schema must not be null.");
            this.schema = TypeDescription.fromString(orcSchema);
            return this;
        }

        public Builder forOrcSchema(TypeDescription orcSchema) {
            Preconditions.checkNotNull((Object)orcSchema, (String)"ORC Schema must not be null.");
            this.schema = orcSchema;
            return this;
        }

        public Builder withConfiguration(Configuration config) {
            Preconditions.checkNotNull((Object)config, (String)"Configuration must not be null.");
            this.config = config;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"Batch size must be greater than zero.");
            this.batchSize = batchSize;
            return this;
        }

        public OrcTableSource build() {
            Preconditions.checkNotNull((Object)this.path, (String)"Path must not be null.");
            Preconditions.checkNotNull((Object)this.schema, (String)"ORC schema must not be null.");
            if (this.config == null) {
                this.config = new Configuration();
            }
            if (this.batchSize == 0) {
                this.batchSize = 1000;
            }
            return new OrcTableSource(this.path, this.schema, this.config, this.batchSize, this.recursive);
        }
    }
}

