/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.schema;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.flink.hive.shaded.parquet.io.api.Binary;

public abstract class PrimitiveComparator<T>
implements Comparator<T> {
    static final PrimitiveComparator<Boolean> BOOLEAN_COMPARATOR = new PrimitiveComparator<Boolean>(){

        @Override
        int compareNotNulls(Boolean o1, Boolean o2) {
            return this.compare(o1, o2);
        }

        @Override
        public int compare(boolean b1, boolean b2) {
            return Boolean.compare(b1, b2);
        }

        public String toString() {
            return "BOOLEAN_COMPARATOR";
        }
    };
    static final PrimitiveComparator<Integer> SIGNED_INT32_COMPARATOR = new IntComparator(){

        @Override
        public int compare(int i1, int i2) {
            return Integer.compare(i1, i2);
        }

        public String toString() {
            return "SIGNED_INT32_COMPARATOR";
        }
    };
    static final PrimitiveComparator<Integer> UNSIGNED_INT32_COMPARATOR = new IntComparator(){

        @Override
        public int compare(int i1, int i2) {
            return Integer.compare(i1 ^ Integer.MIN_VALUE, i2 ^ Integer.MIN_VALUE);
        }

        public String toString() {
            return "UNSIGNED_INT32_COMPARATOR";
        }
    };
    static final PrimitiveComparator<Long> SIGNED_INT64_COMPARATOR = new LongComparator(){

        @Override
        public int compare(long l1, long l2) {
            return Long.compare(l1, l2);
        }

        public String toString() {
            return "SIGNED_INT64_COMPARATOR";
        }
    };
    static final PrimitiveComparator<Long> UNSIGNED_INT64_COMPARATOR = new LongComparator(){

        @Override
        public int compare(long l1, long l2) {
            return Long.compare(l1 ^ Long.MIN_VALUE, l2 ^ Long.MIN_VALUE);
        }

        public String toString() {
            return "UNSIGNED_INT64_COMPARATOR";
        }
    };
    static final PrimitiveComparator<Float> FLOAT_COMPARATOR = new PrimitiveComparator<Float>(){

        @Override
        int compareNotNulls(Float o1, Float o2) {
            return this.compare(o1.floatValue(), o2.floatValue());
        }

        @Override
        public int compare(float f1, float f2) {
            return Float.compare(f1, f2);
        }

        public String toString() {
            return "FLOAT_COMPARATOR";
        }
    };
    static final PrimitiveComparator<Double> DOUBLE_COMPARATOR = new PrimitiveComparator<Double>(){

        @Override
        int compareNotNulls(Double o1, Double o2) {
            return this.compare(o1, o2);
        }

        @Override
        public int compare(double d1, double d2) {
            return Double.compare(d1, d2);
        }

        public String toString() {
            return "DOUBLE_COMPARATOR";
        }
    };
    public static final PrimitiveComparator<Binary> UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR = new BinaryComparator(){

        @Override
        int compare(ByteBuffer b1, ByteBuffer b2) {
            int l1 = b1.remaining();
            int l2 = b2.remaining();
            int p1 = b1.position();
            int p2 = b2.position();
            int minL = Math.min(l1, l2);
            for (int i = 0; i < minL; ++i) {
                int result = this.unsignedCompare(b1.get(p1 + i), b2.get(p2 + i));
                if (result == 0) continue;
                return result;
            }
            return l1 - l2;
        }

        private int unsignedCompare(byte b1, byte b2) {
            return this.toUnsigned(b1) - this.toUnsigned(b2);
        }

        public String toString() {
            return "UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR";
        }
    };
    static final PrimitiveComparator<Binary> BINARY_AS_SIGNED_INTEGER_COMPARATOR = new BinaryComparator(){
        private static final int NEGATIVE_PADDING = 255;
        private static final int POSITIVE_PADDING = 0;

        @Override
        int compare(ByteBuffer b1, ByteBuffer b2) {
            boolean isNegative2;
            boolean isNegative1;
            int l1 = b1.remaining();
            int l2 = b2.remaining();
            int p1 = b1.position();
            int p2 = b2.position();
            boolean bl = l1 > 0 ? b1.get(p1) < 0 : (isNegative1 = false);
            boolean bl2 = l2 > 0 ? b2.get(p2) < 0 : (isNegative2 = false);
            if (isNegative1 != isNegative2) {
                return isNegative1 ? -1 : 1;
            }
            int result = 0;
            if (l1 < l2) {
                int lengthDiff = l2 - l1;
                result = -this.compareWithPadding(lengthDiff, b2, p2, isNegative1 ? 255 : 0);
                p2 += lengthDiff;
            } else if (l1 > l2) {
                int lengthDiff = l1 - l2;
                result = this.compareWithPadding(lengthDiff, b1, p1, isNegative2 ? 255 : 0);
                p1 += lengthDiff;
            }
            if (result == 0) {
                result = this.compare(l1, b1, p1, b2, p2);
            }
            return result;
        }

        private int compareWithPadding(int length, ByteBuffer b, int p, int paddingByte) {
            int n = p + length;
            for (int i = p; i < n; ++i) {
                int result = this.toUnsigned(b.get(i)) - paddingByte;
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        private int compare(int length, ByteBuffer b1, int p1, ByteBuffer b2, int p2) {
            for (int i = 0; i < length; ++i) {
                int result = this.toUnsigned(b1.get(p1 + i)) - this.toUnsigned(b2.get(p2 + i));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        public String toString() {
            return "BINARY_AS_SIGNED_INTEGER_COMPARATOR";
        }
    };

    @Override
    public int compare(boolean b1, boolean b2) {
        throw new UnsupportedOperationException("compare(boolean, boolean) was called on a non-boolean comparator: " + this.toString());
    }

    @Override
    public int compare(int i1, int i2) {
        throw new UnsupportedOperationException("compare(int, int) was called on a non-int comparator: " + this.toString());
    }

    @Override
    public int compare(long l1, long l2) {
        throw new UnsupportedOperationException("compare(long, long) was called on a non-long comparator: " + this.toString());
    }

    @Override
    public int compare(float f1, float f2) {
        throw new UnsupportedOperationException("compare(float, float) was called on a non-float comparator: " + this.toString());
    }

    @Override
    public int compare(double d1, double d2) {
        throw new UnsupportedOperationException("compare(double, double) was called on a non-double comparator: " + this.toString());
    }

    @Override
    public final int compare(T o1, T o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        return o2 == null ? 1 : this.compareNotNulls(o1, o2);
    }

    abstract int compareNotNulls(T var1, T var2);

    private static abstract class BinaryComparator
    extends PrimitiveComparator<Binary> {
        private BinaryComparator() {
        }

        @Override
        int compareNotNulls(Binary o1, Binary o2) {
            return this.compare(o1.toByteBuffer(), o2.toByteBuffer());
        }

        @Override
        abstract int compare(ByteBuffer var1, ByteBuffer var2);

        final int toUnsigned(byte b) {
            return b & 0xFF;
        }
    }

    private static abstract class LongComparator
    extends PrimitiveComparator<Long> {
        private LongComparator() {
        }

        @Override
        int compareNotNulls(Long o1, Long o2) {
            return this.compare(o1, o2);
        }
    }

    private static abstract class IntComparator
    extends PrimitiveComparator<Integer> {
        private IntComparator() {
        }

        @Override
        int compareNotNulls(Integer o1, Integer o2) {
            return this.compare(o1, o2);
        }
    }
}

