/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.column.values.bitpacking;

import org.apache.flink.hive.shaded.parquet.column.values.bitpacking.BytePacker;
import org.apache.flink.hive.shaded.parquet.column.values.bitpacking.BytePackerFactory;
import org.apache.flink.hive.shaded.parquet.column.values.bitpacking.BytePackerForLong;
import org.apache.flink.hive.shaded.parquet.column.values.bitpacking.BytePackerForLongFactory;
import org.apache.flink.hive.shaded.parquet.column.values.bitpacking.IntPacker;
import org.apache.flink.hive.shaded.parquet.column.values.bitpacking.IntPackerFactory;

public enum Packer {
    BIG_ENDIAN{

        @Override
        public IntPacker newIntPacker(int width) {
            return beIntPackerFactory.newIntPacker(width);
        }

        @Override
        public BytePacker newBytePacker(int width) {
            return beBytePackerFactory.newBytePacker(width);
        }

        @Override
        public BytePackerForLong newBytePackerForLong(int width) {
            return beBytePackerForLongFactory.newBytePackerForLong(width);
        }
    }
    ,
    LITTLE_ENDIAN{

        @Override
        public IntPacker newIntPacker(int width) {
            return leIntPackerFactory.newIntPacker(width);
        }

        @Override
        public BytePacker newBytePacker(int width) {
            return leBytePackerFactory.newBytePacker(width);
        }

        @Override
        public BytePackerForLong newBytePackerForLong(int width) {
            return leBytePackerForLongFactory.newBytePackerForLong(width);
        }
    };

    static IntPackerFactory beIntPackerFactory;
    static IntPackerFactory leIntPackerFactory;
    static BytePackerFactory beBytePackerFactory;
    static BytePackerFactory leBytePackerFactory;
    static BytePackerForLongFactory beBytePackerForLongFactory;
    static BytePackerForLongFactory leBytePackerForLongFactory;

    private static IntPackerFactory getIntPackerFactory(String name) {
        return (IntPackerFactory)Packer.getStaticField("org.apache.flink.hive.shaded.parquet.column.values.bitpacking." + name, "factory");
    }

    private static BytePackerFactory getBytePackerFactory(String name) {
        return (BytePackerFactory)Packer.getStaticField("org.apache.flink.hive.shaded.parquet.column.values.bitpacking." + name, "factory");
    }

    private static BytePackerForLongFactory getBytePackerForLongFactory(String name) {
        return (BytePackerForLongFactory)Packer.getStaticField("org.apache.flink.hive.shaded.parquet.column.values.bitpacking." + name, "factory");
    }

    private static Object getStaticField(String className, String fieldName) {
        try {
            return Class.forName(className).getField(fieldName).get(null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract IntPacker newIntPacker(int var1);

    public abstract BytePacker newBytePacker(int var1);

    public abstract BytePackerForLong newBytePackerForLong(int var1);

    static {
        beIntPackerFactory = Packer.getIntPackerFactory("LemireBitPackingBE");
        leIntPackerFactory = Packer.getIntPackerFactory("LemireBitPackingLE");
        beBytePackerFactory = Packer.getBytePackerFactory("ByteBitPackingBE");
        leBytePackerFactory = Packer.getBytePackerFactory("ByteBitPackingLE");
        beBytePackerForLongFactory = Packer.getBytePackerForLongFactory("ByteBitPackingForLongBE");
        leBytePackerForLongFactory = Packer.getBytePackerForLongFactory("ByteBitPackingForLongLE");
    }
}

