/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.column.impl;

import java.io.IOException;
import org.apache.flink.hive.shaded.parquet.Ints;
import org.apache.flink.hive.shaded.parquet.bytes.BytesInput;
import org.apache.flink.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.flink.hive.shaded.parquet.column.ColumnWriter;
import org.apache.flink.hive.shaded.parquet.column.Encoding;
import org.apache.flink.hive.shaded.parquet.column.ParquetProperties;
import org.apache.flink.hive.shaded.parquet.column.page.DictionaryPage;
import org.apache.flink.hive.shaded.parquet.column.page.PageWriter;
import org.apache.flink.hive.shaded.parquet.column.statistics.Statistics;
import org.apache.flink.hive.shaded.parquet.column.values.ValuesWriter;
import org.apache.flink.hive.shaded.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.flink.hive.shaded.parquet.io.ParquetEncodingException;
import org.apache.flink.hive.shaded.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ColumnWriterV2
implements ColumnWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnWriterV2.class);
    private static final boolean DEBUG = false;
    private final ColumnDescriptor path;
    private final PageWriter pageWriter;
    private RunLengthBitPackingHybridEncoder repetitionLevelColumn;
    private RunLengthBitPackingHybridEncoder definitionLevelColumn;
    private ValuesWriter dataColumn;
    private int valueCount;
    private Statistics<?> statistics;
    private long rowsWrittenSoFar = 0L;

    public ColumnWriterV2(ColumnDescriptor path, PageWriter pageWriter, ParquetProperties props) {
        this.path = path;
        this.pageWriter = pageWriter;
        this.resetStatistics();
        this.repetitionLevelColumn = props.newRepetitionLevelEncoder(path);
        this.definitionLevelColumn = props.newDefinitionLevelEncoder(path);
        this.dataColumn = props.newValuesWriter(path);
    }

    private void log(Object value, int r, int d) {
        LOG.debug("{} {} r:{} d:{}", new Object[]{this.path, value, r, d});
    }

    private void resetStatistics() {
        this.statistics = Statistics.createStats(this.path.getPrimitiveType());
    }

    private void definitionLevel(int definitionLevel) {
        try {
            this.definitionLevelColumn.writeInt(definitionLevel);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("illegal definition level " + definitionLevel + " for column " + this.path, e);
        }
    }

    private void repetitionLevel(int repetitionLevel) {
        try {
            this.repetitionLevelColumn.writeInt(repetitionLevel);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("illegal repetition level " + repetitionLevel + " for column " + this.path, e);
        }
    }

    @Override
    public void writeNull(int repetitionLevel, int definitionLevel) {
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.statistics.incrementNumNulls();
        ++this.valueCount;
    }

    @Override
    public void close() {
        this.repetitionLevelColumn.close();
        this.definitionLevelColumn.close();
        this.dataColumn.close();
    }

    @Override
    public long getBufferedSizeInMemory() {
        return this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize() + this.pageWriter.getMemSize();
    }

    @Override
    public void write(double value, int repetitionLevel, int definitionLevel) {
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeDouble(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(float value, int repetitionLevel, int definitionLevel) {
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeFloat(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(Binary value, int repetitionLevel, int definitionLevel) {
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeBytes(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(boolean value, int repetitionLevel, int definitionLevel) {
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeBoolean(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(int value, int repetitionLevel, int definitionLevel) {
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeInteger(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(long value, int repetitionLevel, int definitionLevel) {
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeLong(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    public void finalizeColumnChunk() {
        DictionaryPage dictionaryPage = this.dataColumn.toDictPageAndClose();
        if (dictionaryPage != null) {
            try {
                this.pageWriter.writeDictionaryPage(dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetEncodingException("could not write dictionary page for " + this.path, e);
            }
            this.dataColumn.resetDictionary();
        }
    }

    public long getCurrentPageBufferedSize() {
        return this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize();
    }

    public long getTotalBufferedSize() {
        return this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize() + this.pageWriter.getMemSize();
    }

    public long allocatedSize() {
        return this.repetitionLevelColumn.getAllocatedSize() + this.definitionLevelColumn.getAllocatedSize() + this.dataColumn.getAllocatedSize() + this.pageWriter.allocatedSize();
    }

    public String memUsageString(String indent) {
        StringBuilder b = new StringBuilder(indent).append(this.path).append(" {\n");
        b.append(indent).append(" r:").append(this.repetitionLevelColumn.getAllocatedSize()).append(" bytes\n");
        b.append(indent).append(" d:").append(this.definitionLevelColumn.getAllocatedSize()).append(" bytes\n");
        b.append(this.dataColumn.memUsageString(indent + "  data:")).append("\n");
        b.append(this.pageWriter.memUsageString(indent + "  pages:")).append("\n");
        b.append(indent).append(String.format("  total: %,d/%,d", this.getTotalBufferedSize(), this.allocatedSize())).append("\n");
        b.append(indent).append("}\n");
        return b.toString();
    }

    public long getRowsWrittenSoFar() {
        return this.rowsWrittenSoFar;
    }

    public void writePage(long rowCount) {
        int pageRowCount = Ints.checkedCast(rowCount - this.rowsWrittenSoFar);
        this.rowsWrittenSoFar = rowCount;
        try {
            BytesInput bytes = this.dataColumn.getBytes();
            Encoding encoding = this.dataColumn.getEncoding();
            this.pageWriter.writePageV2(pageRowCount, Ints.checkedCast(this.statistics.getNumNulls()), this.valueCount, this.path.getMaxRepetitionLevel() == 0 ? BytesInput.empty() : this.repetitionLevelColumn.toBytes(), this.path.getMaxDefinitionLevel() == 0 ? BytesInput.empty() : this.definitionLevelColumn.toBytes(), encoding, bytes, this.statistics);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page for " + this.path, e);
        }
        this.repetitionLevelColumn.reset();
        this.definitionLevelColumn.reset();
        this.dataColumn.reset();
        this.valueCount = 0;
        this.resetStatistics();
    }
}

