/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.java.hadoop.mapred.wrapper.HadoopDummyReporter;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.read.HiveTableInputSplit;
import org.apache.flink.connectors.hive.read.SplitReader;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMapredSplitReader
implements SplitReader {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMapredSplitReader.class);
    private RecordReader<Writable, Writable> recordReader;
    protected Writable key;
    protected Writable value;
    private boolean fetched = false;
    private boolean hasNext;
    private final Deserializer deserializer;
    private final int[] selectedFields;
    private final List<? extends StructField> structFields;
    private final StructObjectInspector structObjectInspector;
    private final DataFormatConverters.DataFormatConverter[] converters;
    private final HiveShim hiveShim;
    private final GenericRowData row;

    public HiveMapredSplitReader(JobConf jobConf, List<String> partitionKeys, DataType[] fieldTypes, int[] selectedFields, HiveTableInputSplit split, HiveShim hiveShim) throws IOException {
        InputFormat mapredInputFormat;
        HiveTablePartition hiveTablePartition = split.getHiveTablePartition();
        StorageDescriptor sd = hiveTablePartition.getStorageDescriptor();
        jobConf.set("mapreduce.input.fileinputformat.inputdir", sd.getLocation());
        try {
            mapredInputFormat = (InputFormat)Class.forName(sd.getInputFormat(), true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new FlinkHiveException("Unable to instantiate the hadoop input format", e);
        }
        ReflectionUtils.setConf((Object)mapredInputFormat, (Configuration)jobConf);
        if (mapredInputFormat instanceof Configurable) {
            ((Configurable)mapredInputFormat).setConf((Configuration)jobConf);
        } else if (mapredInputFormat instanceof JobConfigurable) {
            ((JobConfigurable)mapredInputFormat).configure(jobConf);
        }
        this.recordReader = mapredInputFormat.getRecordReader(split.getHadoopInputSplit(), jobConf, (Reporter)new HadoopDummyReporter());
        if (this.recordReader instanceof Configurable) {
            ((Configurable)this.recordReader).setConf((Configuration)jobConf);
        }
        this.key = (Writable)this.recordReader.createKey();
        this.value = (Writable)this.recordReader.createValue();
        try {
            this.deserializer = (Deserializer)Class.forName(sd.getSerdeInfo().getSerializationLib()).newInstance();
            Configuration conf = new Configuration();
            SerDeUtils.initializeSerDe(this.deserializer, conf, hiveTablePartition.getTableProps(), null);
            this.structObjectInspector = (StructObjectInspector)this.deserializer.getObjectInspector();
            this.structFields = this.structObjectInspector.getAllStructFieldRefs();
        }
        catch (Exception e) {
            throw new FlinkHiveException("Error happens when deserialize from storage file.", e);
        }
        this.selectedFields = selectedFields;
        this.converters = (DataFormatConverters.DataFormatConverter[])Arrays.stream(selectedFields).mapToObj(i -> fieldTypes[i]).map(DataFormatConverters::getConverterForDataType).toArray(DataFormatConverters.DataFormatConverter[]::new);
        this.hiveShim = hiveShim;
        this.row = new GenericRowData(selectedFields.length);
        if (!partitionKeys.isEmpty()) {
            for (int i2 = 0; i2 < selectedFields.length; ++i2) {
                if (selectedFields[i2] < this.structFields.size()) continue;
                String partition = partitionKeys.get(selectedFields[i2] - this.structFields.size());
                this.row.setField(i2, this.converters[i2].toInternal(hiveTablePartition.getPartitionSpec().get(partition)));
            }
        }
    }

    @Override
    public boolean reachedEnd() throws IOException {
        if (!this.fetched) {
            this.hasNext = this.recordReader.next((Object)this.key, (Object)this.value);
            this.fetched = true;
        }
        return !this.hasNext;
    }

    @Override
    public RowData nextRecord(RowData reuse) throws IOException {
        if (this.reachedEnd()) {
            return null;
        }
        try {
            Object hiveRowStruct = this.deserializer.deserialize(this.value);
            for (int i = 0; i < this.selectedFields.length; ++i) {
                if (this.selectedFields[i] >= this.structFields.size()) continue;
                StructField structField = this.structFields.get(this.selectedFields[i]);
                Object object = HiveInspectors.toFlinkObject(structField.getFieldObjectInspector(), this.structObjectInspector.getStructFieldData(hiveRowStruct, structField), this.hiveShim);
                this.row.setField(i, this.converters[i].toInternal(object));
            }
        }
        catch (Exception e) {
            LOG.error("Error happens when converting hive data type to flink data type.");
            throw new FlinkHiveException(e);
        }
        this.fetched = false;
        return this.row;
    }

    @Override
    public void close() throws IOException {
        if (this.recordReader != null) {
            this.recordReader.close();
            this.recordReader = null;
        }
    }
}

