/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connectors.hive.read.PartitionDiscovery;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.metastore.api.Partition;

public class DirectoryMonitorDiscovery
implements PartitionDiscovery {
    @Override
    public List<Tuple2<Partition, Long>> fetchPartitions(PartitionDiscovery.Context context, long previousTimestamp) throws Exception {
        FileStatus[] statuses = DirectoryMonitorDiscovery.getFileStatusRecurse(context.tableLocation(), context.partitionKeys().size(), context.fileSystem());
        List<Tuple2<List<String>, Long>> partValueList = DirectoryMonitorDiscovery.suitablePartitions(context, previousTimestamp, statuses);
        ArrayList<Tuple2<Partition, Long>> partitions = new ArrayList<Tuple2<Partition, Long>>();
        for (Tuple2<List<String>, Long> tuple2 : partValueList) {
            context.getPartition((List)tuple2.f0).ifPresent(partition -> partitions.add(new Tuple2(partition, tuple2.f1)));
        }
        return partitions;
    }

    @VisibleForTesting
    static List<Tuple2<List<String>, Long>> suitablePartitions(PartitionDiscovery.Context context, long previousTimestamp, FileStatus[] statuses) {
        ArrayList<Tuple2<List<String>, Long>> partValueList = new ArrayList<Tuple2<List<String>, Long>>();
        for (FileStatus status : statuses) {
            List partValues = PartitionPathUtils.extractPartitionValues((Path)new Path(status.getPath().toString()));
            long timestamp = context.extractTimestamp(context.partitionKeys(), partValues, () -> TimestampData.fromTimestamp((Timestamp)new Timestamp(status.getModificationTime())).getMillisecond());
            if (timestamp < previousTimestamp) continue;
            partValueList.add((Tuple2<List<String>, Long>)new Tuple2((Object)partValues, (Object)timestamp));
        }
        return partValueList;
    }

    private static FileStatus[] getFileStatusRecurse(org.apache.hadoop.fs.Path path, int expectLevel, FileSystem fs) {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        try {
            FileStatus fileStatus = fs.getFileStatus(path);
            DirectoryMonitorDiscovery.listStatusRecursively(fs, fileStatus, 0, expectLevel, result);
        }
        catch (IOException ignore) {
            return new FileStatus[0];
        }
        return result.toArray(new FileStatus[0]);
    }

    private static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, int level, int expectLevel, List<FileStatus> results) throws IOException {
        if (expectLevel == level) {
            results.add(fileStatus);
            return;
        }
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath())) {
                DirectoryMonitorDiscovery.listStatusRecursively(fs, stat, level + 1, expectLevel, results);
            }
        }
    }
}

