/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;

public class HiveTablePartition
implements Serializable {
    private static final long serialVersionUID = 4145470177119940673L;
    private final StorageDescriptor storageDescriptor;
    private final Map<String, Object> partitionSpec;
    private final Properties tableProps;

    public HiveTablePartition(StorageDescriptor storageDescriptor, Properties tableProps) {
        this(storageDescriptor, new LinkedHashMap<String, Object>(), tableProps);
    }

    public HiveTablePartition(StorageDescriptor storageDescriptor, Map<String, Object> partitionSpec, Properties tableProps) {
        this.storageDescriptor = (StorageDescriptor)Preconditions.checkNotNull((Object)storageDescriptor, (String)"storageDescriptor can not be null");
        this.partitionSpec = (Map)Preconditions.checkNotNull(partitionSpec, (String)"partitionSpec can not be null");
        this.tableProps = (Properties)Preconditions.checkNotNull((Object)tableProps, (String)"tableProps can not be null");
    }

    public StorageDescriptor getStorageDescriptor() {
        return this.storageDescriptor;
    }

    public Map<String, Object> getPartitionSpec() {
        return this.partitionSpec;
    }

    public Properties getTableProps() {
        return this.tableProps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTablePartition that = (HiveTablePartition)o;
        return Objects.equals(this.storageDescriptor, that.storageDescriptor) && Objects.equals(this.partitionSpec, that.partitionSpec) && Objects.equals(this.tableProps, that.tableProps);
    }

    public int hashCode() {
        return Objects.hash(this.storageDescriptor, this.partitionSpec, this.tableProps);
    }

    public String toString() {
        return "HiveTablePartition{storageDescriptor=" + this.storageDescriptor + ", partitionSpec=" + this.partitionSpec + ", tableProps=" + this.tableProps + '}';
    }
}

