/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.List;
import java.util.Map;
import org.apache.flink.connectors.hive.HiveOptions;
import org.apache.flink.connectors.hive.HiveTableSink;
import org.apache.flink.connectors.hive.HiveTableSource;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.JobConf;

public class HiveTableFactory
implements TableSourceFactory<RowData>,
TableSinkFactory {
    private final HiveConf hiveConf;

    public HiveTableFactory(HiveConf hiveConf) {
        this.hiveConf = (HiveConf)((Object)Preconditions.checkNotNull((Object)((Object)hiveConf), (String)"hiveConf cannot be null"));
    }

    public Map<String, String> requiredContext() {
        throw new UnsupportedOperationException();
    }

    public List<String> supportedProperties() {
        throw new UnsupportedOperationException();
    }

    public TableSource<RowData> createTableSource(TableSourceFactory.Context context) {
        CatalogTable table = (CatalogTable)Preconditions.checkNotNull((Object)context.getTable());
        Preconditions.checkArgument((boolean)(table instanceof CatalogTableImpl));
        boolean isGeneric = Boolean.parseBoolean((String)table.getProperties().get("is_generic"));
        if (!isGeneric) {
            return new HiveTableSource(new JobConf((Configuration)this.hiveConf), context.getConfiguration(), context.getObjectIdentifier().toObjectPath(), table);
        }
        return TableFactoryUtil.findAndCreateTableSource((TableSourceFactory.Context)context);
    }

    public TableSink createTableSink(TableSinkFactory.Context context) {
        CatalogTable table = (CatalogTable)Preconditions.checkNotNull((Object)context.getTable());
        Preconditions.checkArgument((boolean)(table instanceof CatalogTableImpl));
        boolean isGeneric = Boolean.parseBoolean((String)table.getProperties().get("is_generic"));
        if (!isGeneric) {
            return new HiveTableSink((Boolean)context.getConfiguration().get(HiveOptions.TABLE_EXEC_HIVE_FALLBACK_MAPRED_WRITER), context.isBounded(), new JobConf((Configuration)this.hiveConf), context.getObjectIdentifier(), table);
        }
        return TableFactoryUtil.findAndCreateTableSink((TableSinkFactory.Context)context);
    }
}

