/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.filesystem.RowPartitionComputer;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.functions.hive.conversion.HiveObjectConversion;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class HiveRowPartitionComputer
extends RowPartitionComputer {
    private static final long serialVersionUID = 1L;
    private final HiveObjectConversion[] partColConversions;

    HiveRowPartitionComputer(HiveShim hiveShim, String defaultPartValue, String[] columnNames, DataType[] columnTypes, String[] partitionColumns) {
        super(defaultPartValue, columnNames, partitionColumns);
        this.partColConversions = new HiveObjectConversion[this.partitionIndexes.length];
        for (int i = 0; i < this.partColConversions.length; ++i) {
            DataType partColType = columnTypes[this.partitionIndexes[i]];
            ObjectInspector objectInspector = HiveInspectors.getObjectInspector(partColType);
            this.partColConversions[i] = HiveInspectors.getConversion(objectInspector, partColType.getLogicalType(), hiveShim);
        }
    }

    public LinkedHashMap<String, String> generatePartValues(Row in) throws Exception {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionIndexes.length; ++i) {
            String partitionValue;
            int index = this.partitionIndexes[i];
            Object field = in.getField(index);
            String string = partitionValue = field != null ? this.partColConversions[i].toHiveObject(field).toString() : null;
            if (StringUtils.isEmpty(partitionValue)) {
                partitionValue = this.defaultPartValue;
            }
            partSpec.put(this.partitionColumns[i], partitionValue);
        }
        return partSpec;
    }
}

