/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.filesystem.RowDataPartitionComputer;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.functions.hive.conversion.HiveObjectConversion;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class HiveRowDataPartitionComputer
extends RowDataPartitionComputer {
    private final DataFormatConverters.DataFormatConverter[] partitionConverters;
    private final HiveObjectConversion[] hiveObjectConversions;

    public HiveRowDataPartitionComputer(HiveShim hiveShim, String defaultPartValue, String[] columnNames, DataType[] columnTypes, String[] partitionColumns) {
        super(defaultPartValue, columnNames, columnTypes, partitionColumns);
        this.partitionConverters = (DataFormatConverters.DataFormatConverter[])Arrays.stream(this.partitionTypes).map(TypeConversions::fromLogicalToDataType).map(DataFormatConverters::getConverterForDataType).toArray(DataFormatConverters.DataFormatConverter[]::new);
        this.hiveObjectConversions = new HiveObjectConversion[this.partitionIndexes.length];
        for (int i = 0; i < this.hiveObjectConversions.length; ++i) {
            DataType partColType = columnTypes[this.partitionIndexes[i]];
            ObjectInspector objectInspector = HiveInspectors.getObjectInspector(partColType);
            this.hiveObjectConversions[i] = HiveInspectors.getConversion(objectInspector, partColType.getLogicalType(), hiveShim);
        }
    }

    public LinkedHashMap<String, String> generatePartValues(RowData in) {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionIndexes.length; ++i) {
            String partitionValue;
            Object field = this.partitionConverters[i].toExternal(in, this.partitionIndexes[i]);
            String string = partitionValue = field != null ? this.hiveObjectConversions[i].toHiveObject(field).toString() : null;
            if (StringUtils.isEmpty(partitionValue)) {
                partitionValue = this.defaultPartValue;
            }
            partSpec.put(this.partitionColumns[i], partitionValue);
        }
        return partSpec;
    }
}

