/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.IndexMetadataChangeTask;
import org.apache.hadoop.hive.ql.index.IndexMetadataChangeWork;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.index.IndexWhereProcessor;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public final class IndexUtils {
    private static final Log LOG = LogFactory.getLog((String)IndexWhereProcessor.class.getName());

    private IndexUtils() {
    }

    public static Set<Partition> checkPartitionsCoveredByIndex(TableScanOperator tableScan, ParseContext pctx, List<Index> indexes) throws HiveException {
        Hive hive = Hive.get(pctx.getConf());
        PrunedPartitionList queryPartitionList = pctx.getOpToPartList().get(tableScan);
        Set<Partition> queryPartitions = queryPartitionList.getPartitions();
        if (queryPartitions == null || queryPartitions.isEmpty()) {
            return null;
        }
        for (Partition part : queryPartitions) {
            if (IndexUtils.containsPartition(hive, part, indexes)) continue;
            return null;
        }
        return queryPartitions;
    }

    private static boolean containsPartition(Hive hive, Partition part, List<Index> indexes) throws HiveException {
        LinkedHashMap<String, String> partSpec = part.getSpec();
        if (partSpec.isEmpty()) {
            return IndexUtils.isIndexTableFresh(hive, indexes, part.getTable());
        }
        for (Index index : indexes) {
            String[] qualified = Utilities.getDbTableName(index.getDbName(), index.getIndexTableName());
            Table indexTable = hive.getTable(qualified[0], qualified[1]);
            Partition matchingPartition = hive.getPartition(indexTable, partSpec, false);
            if (matchingPartition == null) {
                LOG.info((Object)("Index table " + indexTable + "did not contain built partition that matched " + partSpec));
                return false;
            }
            if (IndexUtils.isIndexPartitionFresh(hive, index, part)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIndexPartitionFresh(Hive hive, Index index, Partition part) throws HiveException {
        LOG.info((Object)"checking index staleness...");
        try {
            FileStatus[] parts;
            String indexTs = index.getParameters().get(part.getSpec().toString());
            if (indexTs == null) {
                return false;
            }
            FileSystem partFs = part.getDataLocation().getFileSystem((Configuration)hive.getConf());
            for (FileStatus status : parts = partFs.listStatus(part.getDataLocation(), FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (status.getModificationTime() <= Long.parseLong(indexTs)) continue;
                LOG.info((Object)("Index is stale on partition '" + part.getName() + "'. Modified time (" + status.getModificationTime() + ") for '" + status.getPath() + "' is higher than index creation time (" + indexTs + ")."));
                return false;
            }
        }
        catch (IOException e) {
            throw new HiveException("Failed to grab timestamp information from partition '" + part.getName() + "': " + e.getMessage(), e);
        }
        return true;
    }

    private static boolean isIndexTableFresh(Hive hive, List<Index> indexes, Table src) throws HiveException {
        if (indexes == null || indexes.size() == 0) {
            return false;
        }
        for (Index index : indexes) {
            LOG.info((Object)"checking index staleness...");
            try {
                FileStatus[] srcs;
                String indexTs = index.getParameters().get("base_timestamp");
                if (indexTs == null) {
                    return false;
                }
                FileSystem srcFs = src.getPath().getFileSystem((Configuration)hive.getConf());
                for (FileStatus status : srcs = srcFs.listStatus(src.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                    if (status.getModificationTime() <= Long.parseLong(indexTs)) continue;
                    LOG.info((Object)("Index is stale on table '" + src.getTableName() + "'. Modified time (" + status.getModificationTime() + ") for '" + status.getPath() + "' is higher than index creation time (" + indexTs + ")."));
                    return false;
                }
            }
            catch (IOException e) {
                throw new HiveException("Failed to grab timestamp information from table '" + src.getTableName() + "': " + e.getMessage(), e);
            }
        }
        return true;
    }

    public static List<Index> getIndexes(Table baseTableMetaData, List<String> matchIndexTypes) throws SemanticException {
        List<Index> indexesOnTable;
        ArrayList<Index> matchingIndexes = new ArrayList<Index>();
        try {
            indexesOnTable = IndexUtils.getAllIndexes(baseTableMetaData, (short)-1);
        }
        catch (HiveException e) {
            throw new SemanticException("Error accessing metastore", e);
        }
        for (Index index : indexesOnTable) {
            String indexType = index.getIndexHandlerClass();
            if (!matchIndexTypes.contains(indexType)) continue;
            matchingIndexes.add(index);
        }
        return matchingIndexes;
    }

    public static List<Index> getAllIndexes(Table table, short max) throws HiveException {
        Hive hive = Hive.get();
        return hive.getIndexes(table.getTTable().getDbName(), table.getTTable().getTableName(), max);
    }

    public static Task<?> createRootTask(HiveConf builderConf, Set<ReadEntity> inputs, Set<WriteEntity> outputs, StringBuilder command, LinkedHashMap<String, String> partSpec, String indexTableName, String dbName) {
        HiveConf.setBoolVar(builderConf, HiveConf.ConfVars.HIVEOPTINDEXFILTER, false);
        Driver driver = new Driver(builderConf);
        driver.compile(command.toString(), false);
        Task<? extends Serializable> rootTask = driver.getPlan().getRootTasks().get(0);
        inputs.addAll(driver.getPlan().getInputs());
        outputs.addAll(driver.getPlan().getOutputs());
        IndexMetadataChangeWork indexMetaChange = new IndexMetadataChangeWork(partSpec, indexTableName, dbName);
        IndexMetadataChangeTask indexMetaChangeTsk = (IndexMetadataChangeTask)TaskFactory.get(indexMetaChange, builderConf, new Task[0]);
        indexMetaChangeTsk.setWork(indexMetaChange);
        rootTask.addDependentTask(indexMetaChangeTsk);
        return rootTask;
    }
}

