/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.hive.shaded.parquet.HadoopReadOptions;
import org.apache.flink.hive.shaded.parquet.ParquetReadOptions;
import org.apache.flink.hive.shaded.parquet.Preconditions;
import org.apache.flink.hive.shaded.parquet.compression.CompressionCodecFactory;
import org.apache.flink.hive.shaded.parquet.filter.UnboundRecordFilter;
import org.apache.flink.hive.shaded.parquet.filter2.compat.FilterCompat;
import org.apache.flink.hive.shaded.parquet.hadoop.InternalParquetRecordReader;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetFileReader;
import org.apache.flink.hive.shaded.parquet.hadoop.api.ReadSupport;
import org.apache.flink.hive.shaded.parquet.hadoop.util.HadoopInputFile;
import org.apache.flink.hive.shaded.parquet.hadoop.util.HiddenFileFilter;
import org.apache.flink.hive.shaded.parquet.io.InputFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class ParquetReader<T>
implements Closeable {
    private final ReadSupport<T> readSupport;
    private final Iterator<InputFile> filesIterator;
    private final ParquetReadOptions options;
    private InternalParquetRecordReader<T> reader;

    @Deprecated
    public ParquetReader(Path file, ReadSupport<T> readSupport) throws IOException {
        this(new Configuration(), file, readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport) throws IOException {
        this(conf, file, readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public ParquetReader(Path file, ReadSupport<T> readSupport, UnboundRecordFilter unboundRecordFilter) throws IOException {
        this(new Configuration(), file, readSupport, FilterCompat.get(unboundRecordFilter));
    }

    @Deprecated
    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport, UnboundRecordFilter unboundRecordFilter) throws IOException {
        this(conf, file, readSupport, FilterCompat.get(unboundRecordFilter));
    }

    private ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport, FilterCompat.Filter filter) throws IOException {
        this(Collections.singletonList(HadoopInputFile.fromPath(file, conf)), HadoopReadOptions.builder(conf).withRecordFilter(Preconditions.checkNotNull(filter, "filter")).build(), readSupport);
    }

    private ParquetReader(List<InputFile> files, ParquetReadOptions options, ReadSupport<T> readSupport) throws IOException {
        this.readSupport = readSupport;
        this.options = options;
        this.filesIterator = files.iterator();
    }

    public T read() throws IOException {
        try {
            if (this.reader != null && this.reader.nextKeyValue()) {
                return this.reader.getCurrentValue();
            }
            this.initReader();
            return this.reader == null ? null : (T)this.read();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void initReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.filesIterator.hasNext()) {
            InputFile file = this.filesIterator.next();
            ParquetFileReader fileReader = ParquetFileReader.open(file, this.options);
            this.reader = new InternalParquetRecordReader<T>(this.readSupport, this.options.getRecordFilter());
            this.reader.initialize(fileReader, this.options);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static <T> Builder<T> read(InputFile file) throws IOException {
        return new Builder(file);
    }

    public static <T> Builder<T> builder(ReadSupport<T> readSupport, Path path) {
        return new Builder(readSupport, path);
    }

    public static class Builder<T> {
        private final ReadSupport<T> readSupport;
        private final InputFile file;
        private final Path path;
        private FilterCompat.Filter filter = null;
        protected Configuration conf;
        private ParquetReadOptions.Builder optionsBuilder;

        @Deprecated
        private Builder(ReadSupport<T> readSupport, Path path) {
            this.readSupport = Preconditions.checkNotNull(readSupport, "readSupport");
            this.file = null;
            this.path = Preconditions.checkNotNull(path, "path");
            this.conf = new Configuration();
            this.optionsBuilder = HadoopReadOptions.builder(this.conf);
        }

        @Deprecated
        protected Builder(Path path) {
            this.readSupport = null;
            this.file = null;
            this.path = Preconditions.checkNotNull(path, "path");
            this.conf = new Configuration();
            this.optionsBuilder = HadoopReadOptions.builder(this.conf);
        }

        protected Builder(InputFile file) {
            this.readSupport = null;
            this.file = Preconditions.checkNotNull(file, "file");
            this.path = null;
            this.conf = file instanceof HadoopInputFile ? ((HadoopInputFile)file).getConfiguration() : new Configuration();
            this.optionsBuilder = HadoopReadOptions.builder(this.conf);
        }

        public Builder<T> withConf(Configuration conf) {
            this.conf = Preconditions.checkNotNull(conf, "conf");
            this.optionsBuilder = HadoopReadOptions.builder(conf);
            if (this.filter != null) {
                this.optionsBuilder.withRecordFilter(this.filter);
            }
            return this;
        }

        public Builder<T> withFilter(FilterCompat.Filter filter) {
            this.filter = filter;
            this.optionsBuilder.withRecordFilter(filter);
            return this;
        }

        public Builder<T> useSignedStringMinMax(boolean useSignedStringMinMax) {
            this.optionsBuilder.useSignedStringMinMax(useSignedStringMinMax);
            return this;
        }

        public Builder<T> useSignedStringMinMax() {
            this.optionsBuilder.useSignedStringMinMax();
            return this;
        }

        public Builder<T> useStatsFilter(boolean useStatsFilter) {
            this.optionsBuilder.useStatsFilter(useStatsFilter);
            return this;
        }

        public Builder<T> useStatsFilter() {
            this.optionsBuilder.useStatsFilter();
            return this;
        }

        public Builder<T> useDictionaryFilter(boolean useDictionaryFilter) {
            this.optionsBuilder.useDictionaryFilter(useDictionaryFilter);
            return this;
        }

        public Builder<T> useDictionaryFilter() {
            this.optionsBuilder.useDictionaryFilter();
            return this;
        }

        public Builder<T> useRecordFilter(boolean useRecordFilter) {
            this.optionsBuilder.useRecordFilter(useRecordFilter);
            return this;
        }

        public Builder<T> useRecordFilter() {
            this.optionsBuilder.useRecordFilter();
            return this;
        }

        public Builder<T> withFileRange(long start, long end) {
            this.optionsBuilder.withRange(start, end);
            return this;
        }

        public Builder<T> withCodecFactory(CompressionCodecFactory codecFactory) {
            this.optionsBuilder.withCodecFactory(codecFactory);
            return this;
        }

        public Builder<T> set(String key, String value) {
            this.optionsBuilder.set(key, value);
            return this;
        }

        protected ReadSupport<T> getReadSupport() {
            Preconditions.checkArgument(this.readSupport != null, "[BUG] Classes that extend Builder should override getReadSupport()");
            return this.readSupport;
        }

        public ParquetReader<T> build() throws IOException {
            ParquetReadOptions options = this.optionsBuilder.build();
            if (this.path != null) {
                FileSystem fs = this.path.getFileSystem(this.conf);
                FileStatus stat = fs.getFileStatus(this.path);
                if (stat.isFile()) {
                    return new ParquetReader(Collections.singletonList(HadoopInputFile.fromStatus(stat, this.conf)), options, this.getReadSupport());
                }
                ArrayList<HadoopInputFile> files = new ArrayList<HadoopInputFile>();
                for (FileStatus fileStatus : fs.listStatus(this.path, (PathFilter)HiddenFileFilter.INSTANCE)) {
                    files.add(HadoopInputFile.fromStatus(fileStatus, this.conf));
                }
                return new ParquetReader(files, options, this.getReadSupport());
            }
            return new ParquetReader(Collections.singletonList(this.file), options, this.getReadSupport());
        }
    }
}

