/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.write;

import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import org.apache.flink.connectors.hive.write.HiveWriterFactory;
import org.apache.flink.formats.hadoop.bulk.HadoopPathBasedBulkWriter;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.Writable;

public class HiveBulkWriterFactory
implements HadoopPathBasedBulkWriter.Factory<RowData> {
    private static final long serialVersionUID = 1L;
    private final HiveWriterFactory factory;

    public HiveBulkWriterFactory(HiveWriterFactory factory) {
        this.factory = factory;
    }

    @Override
    public HadoopPathBasedBulkWriter<RowData> create(Path targetPath, final Path inProgressPath) throws IOException {
        final FileSinkOperator.RecordWriter recordWriter = this.factory.createRecordWriter(inProgressPath);
        final Function<RowData, Writable> rowConverter = this.factory.createRowDataConverter();
        final FileSystem fs = FileSystem.get((URI)inProgressPath.toUri(), (Configuration)this.factory.getJobConf());
        return new HadoopPathBasedBulkWriter<RowData>(){

            @Override
            public long getSize() throws IOException {
                return fs.getFileStatus(inProgressPath).getLen();
            }

            @Override
            public void dispose() {
                try {
                    recordWriter.close(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void addElement(RowData element) throws IOException {
                recordWriter.write((Writable)rowConverter.apply(element));
            }

            public void flush() {
            }

            public void finish() throws IOException {
                recordWriter.close(false);
            }
        };
    }
}

