/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.google.common.collect.ImmutableSet;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Set;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ExprNodeConverter
extends RexVisitorImpl<ExprNodeDesc> {
    private final String tabAlias;
    private final String columnAlias;
    private final RelDataType inputRowType;
    private final RelDataType outputRowType;
    private final ImmutableSet<Integer> inputVCols;
    private WindowingSpec.WindowFunctionSpec wfs;
    private final RelDataTypeFactory dTFactory;
    protected final Log LOG = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public ExprNodeConverter(String tabAlias, RelDataType inputRowType, Set<Integer> vCols, RelDataTypeFactory dTFactory) {
        this(tabAlias, null, inputRowType, null, vCols, dTFactory);
    }

    public ExprNodeConverter(String tabAlias, String columnAlias, RelDataType inputRowType, RelDataType outputRowType, Set<Integer> inputVCols, RelDataTypeFactory dTFactory) {
        super(true);
        this.tabAlias = tabAlias;
        this.columnAlias = columnAlias;
        this.inputRowType = inputRowType;
        this.outputRowType = outputRowType;
        this.inputVCols = ImmutableSet.copyOf(inputVCols);
        this.dTFactory = dTFactory;
    }

    public WindowingSpec.WindowFunctionSpec getWindowFunctionSpec() {
        return this.wfs;
    }

    public ExprNodeDesc visitInputRef(RexInputRef inputRef) {
        RelDataTypeField f = (RelDataTypeField)this.inputRowType.getFieldList().get(inputRef.getIndex());
        return new ExprNodeColumnDesc(TypeConverter.convert(f.getType()), f.getName(), this.tabAlias, this.inputVCols.contains(inputRef.getIndex()));
    }

    public ExprNodeDesc visitCall(RexCall call) {
        GenericUDF hiveUdf;
        ExprNodeGenericFuncDesc gfDesc = null;
        if (!this.deep) {
            return null;
        }
        LinkedList<ExprNodeDesc> args = new LinkedList<ExprNodeDesc>();
        for (RexNode operand : call.operands) {
            args.add((ExprNodeDesc)operand.accept((RexVisitor)this));
        }
        if (call.isA(SqlKind.CAST) && call.operands.size() == 1 && SqlTypeUtil.equalSansNullability((RelDataTypeFactory)this.dTFactory, (RelDataType)call.getType(), (RelDataType)((RexNode)call.operands.get(0)).getType())) {
            return (ExprNodeDesc)args.get(0);
        }
        if (ASTConverter.isFlat(call)) {
            hiveUdf = SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), 2);
            ArrayList<ExprNodeDesc> tmpExprArgs = new ArrayList<ExprNodeDesc>();
            tmpExprArgs.addAll(args.subList(0, 2));
            try {
                gfDesc = ExprNodeGenericFuncDesc.newInstance(hiveUdf, tmpExprArgs);
            }
            catch (UDFArgumentException e) {
                this.LOG.error((Object)e);
                throw new RuntimeException(e);
            }
            for (int i = 2; i < call.operands.size(); ++i) {
                tmpExprArgs = new ArrayList();
                tmpExprArgs.add(gfDesc);
                tmpExprArgs.add((ExprNodeDesc)args.get(i));
                try {
                    gfDesc = ExprNodeGenericFuncDesc.newInstance(hiveUdf, tmpExprArgs);
                    continue;
                }
                catch (UDFArgumentException e) {
                    this.LOG.error((Object)e);
                    throw new RuntimeException(e);
                }
            }
        } else {
            hiveUdf = SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), args.size());
            if (hiveUdf == null) {
                throw new RuntimeException("Cannot find UDF for " + call.getType() + " " + call.getOperator() + "[" + call.getOperator().getKind() + "]/" + args.size());
            }
            try {
                gfDesc = ExprNodeGenericFuncDesc.newInstance(hiveUdf, args);
            }
            catch (UDFArgumentException e) {
                this.LOG.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        return gfDesc;
    }

    public ExprNodeDesc visitLiteral(RexLiteral literal) {
        RelDataType lType = literal.getType();
        switch (literal.getType().getSqlTypeName()) {
            case BOOLEAN: {
                return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, RexLiteral.booleanValue((RexNode)literal));
            }
            case TINYINT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.byteTypeInfo, ((Number)literal.getValue3()).byteValue());
            }
            case SMALLINT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.shortTypeInfo, ((Number)literal.getValue3()).shortValue());
            }
            case INTEGER: {
                return new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, ((Number)literal.getValue3()).intValue());
            }
            case BIGINT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.longTypeInfo, ((Number)literal.getValue3()).longValue());
            }
            case FLOAT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.floatTypeInfo, Float.valueOf(((Number)literal.getValue3()).floatValue()));
            }
            case DOUBLE: {
                return new ExprNodeConstantDesc(TypeInfoFactory.doubleTypeInfo, ((Number)literal.getValue3()).doubleValue());
            }
            case DATE: {
                return new ExprNodeConstantDesc(TypeInfoFactory.dateTypeInfo, new Date(((Calendar)literal.getValue()).getTimeInMillis()));
            }
            case TIMESTAMP: {
                Object value = literal.getValue3();
                if (value instanceof Long) {
                    value = new Timestamp((Long)value);
                }
                return new ExprNodeConstantDesc(TypeInfoFactory.timestampTypeInfo, value);
            }
            case BINARY: {
                return new ExprNodeConstantDesc(TypeInfoFactory.binaryTypeInfo, literal.getValue3());
            }
            case DECIMAL: {
                return new ExprNodeConstantDesc(TypeInfoFactory.getDecimalTypeInfo(lType.getPrecision(), lType.getScale()), literal.getValue3());
            }
            case VARCHAR: {
                return new ExprNodeConstantDesc(TypeInfoFactory.getVarcharTypeInfo(lType.getPrecision()), new HiveVarchar((String)literal.getValue3(), lType.getPrecision()));
            }
            case CHAR: {
                return new ExprNodeConstantDesc(TypeInfoFactory.getCharTypeInfo(lType.getPrecision()), new HiveChar((String)literal.getValue3(), lType.getPrecision()));
            }
        }
        return new ExprNodeConstantDesc(TypeInfoFactory.voidTypeInfo, literal.getValue3());
    }

    public ExprNodeDesc visitOver(RexOver over) {
        if (!this.deep) {
            return null;
        }
        RexWindow window = over.getWindow();
        WindowingSpec.WindowSpec windowSpec = new WindowingSpec.WindowSpec();
        PTFInvocationSpec.PartitioningSpec partitioningSpec = this.getPSpec(window);
        windowSpec.setPartitioning(partitioningSpec);
        WindowingSpec.WindowFrameSpec windowFrameSpec = this.getWindowRange(window);
        windowSpec.setWindowFrame(windowFrameSpec);
        this.wfs = new WindowingSpec.WindowFunctionSpec();
        this.wfs.setWindowSpec(windowSpec);
        ASTConverter.Schema schema = new ASTConverter.Schema(this.tabAlias, this.inputRowType.getFieldList());
        ASTNode wUDAFAst = new ASTConverter.RexVisitor(schema).visitOver(over);
        this.wfs.setExpression(wUDAFAst);
        ASTNode nameNode = (ASTNode)wUDAFAst.getChild(0);
        this.wfs.setName(nameNode.getText());
        for (int i = 1; i < wUDAFAst.getChildCount() - 1; ++i) {
            ASTNode child = (ASTNode)wUDAFAst.getChild(i);
            this.wfs.addArg(child);
        }
        this.wfs.setAlias(this.columnAlias);
        RelDataTypeField f = this.outputRowType.getField(this.columnAlias, false, false);
        return new ExprNodeColumnDesc(TypeConverter.convert(f.getType()), this.columnAlias, this.tabAlias, false);
    }

    private PTFInvocationSpec.PartitioningSpec getPSpec(RexWindow window) {
        PTFInvocationSpec.PartitionExpression exprSpec;
        PTFInvocationSpec.PartitioningSpec partitioning = new PTFInvocationSpec.PartitioningSpec();
        ASTConverter.Schema schema = new ASTConverter.Schema(this.tabAlias, this.inputRowType.getFieldList());
        if (window.partitionKeys != null && !window.partitionKeys.isEmpty()) {
            PTFInvocationSpec.PartitionSpec pSpec = new PTFInvocationSpec.PartitionSpec();
            for (RexNode pk : window.partitionKeys) {
                exprSpec = new PTFInvocationSpec.PartitionExpression();
                ASTNode astNode = (ASTNode)pk.accept((RexVisitor)new ASTConverter.RexVisitor(schema));
                exprSpec.setExpression(astNode);
                pSpec.addExpression(exprSpec);
            }
            partitioning.setPartSpec(pSpec);
        }
        if (window.orderKeys != null && !window.orderKeys.isEmpty()) {
            PTFInvocationSpec.OrderSpec oSpec = new PTFInvocationSpec.OrderSpec();
            for (RexFieldCollation ok : window.orderKeys) {
                exprSpec = new PTFInvocationSpec.OrderExpression();
                PTFInvocationSpec.Order order = ok.getDirection() == RelFieldCollation.Direction.ASCENDING ? PTFInvocationSpec.Order.ASC : PTFInvocationSpec.Order.DESC;
                ((PTFInvocationSpec.OrderExpression)exprSpec).setOrder(order);
                ASTNode astNode = (ASTNode)((RexNode)ok.left).accept((RexVisitor)new ASTConverter.RexVisitor(schema));
                exprSpec.setExpression(astNode);
                oSpec.addExpression((PTFInvocationSpec.OrderExpression)exprSpec);
            }
            partitioning.setOrderSpec(oSpec);
        }
        return partitioning;
    }

    private WindowingSpec.WindowFrameSpec getWindowRange(RexWindow window) {
        WindowingSpec.WindowFrameSpec windowFrame = new WindowingSpec.WindowFrameSpec();
        WindowingSpec.BoundarySpec start = null;
        RexWindowBound ub = window.getUpperBound();
        if (ub != null) {
            start = this.getWindowBound(ub, window.isRows());
        }
        WindowingSpec.BoundarySpec end = null;
        RexWindowBound lb = window.getLowerBound();
        if (lb != null) {
            end = this.getWindowBound(lb, window.isRows());
        }
        if (start != null || end != null) {
            if (start != null) {
                windowFrame.setStart(start);
            }
            if (end != null) {
                windowFrame.setEnd(end);
            }
        }
        return windowFrame;
    }

    private WindowingSpec.BoundarySpec getWindowBound(RexWindowBound wb, boolean isRows) {
        WindowingSpec.BoundarySpec boundarySpec;
        if (wb.isCurrentRow()) {
            boundarySpec = new WindowingSpec.CurrentRowSpec();
        } else {
            WindowingSpec.Direction direction = wb.isPreceding() ? WindowingSpec.Direction.PRECEDING : WindowingSpec.Direction.FOLLOWING;
            int amt = wb.isUnbounded() ? WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT : RexLiteral.intValue((RexNode)wb.getOffset());
            boundarySpec = isRows ? new WindowingSpec.RangeBoundarySpec(direction, amt) : new WindowingSpec.ValueBoundarySpec(direction, amt);
        }
        return boundarySpec;
    }
}

