/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.runtime.ClassicToken;
import org.antlr.runtime.tree.Tree;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.commons.io.FileUtils;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.planner.delegation.hive.HiveParserTypeCheckProcFactory;
import org.apache.flink.table.planner.delegation.hive.HiveParserUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseDriver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseException;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNodeOrigin;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserContext;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserDefaultGraphWalker;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExprNodeColumnListDesc;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserPTFInvocationSpec;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserPlannerContext;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQB;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBExpr;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBParseInfo;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQueryState;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserStorageFormat;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSubQueryUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeCheckCtx;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserUnparseTranslator;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserWindowingSpec;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserDDLSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserErrorMsg;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserSemanticAnalyzer.class);
    public static final String DUMMY_TABLE = "_dummy_table";
    public static final String SUBQUERY_TAG_1 = "-subquery1";
    public static final String SUBQUERY_TAG_2 = "-subquery2";
    public static final int AUTOGEN_COLALIAS_PRFX_MAXLENGTH = 20;
    public static final String VALUES_TMP_TABLE_NAME_PREFIX = "Values__Tmp__Table__";
    private HiveParserQB qb;
    private HiveParserASTNode ast;
    private final HashMap<String, SplitSample> nameToSplitSample;
    Map<String, PrunedPartitionList> prunedPartitions;
    public List<FieldSchema> resultSchema;
    protected CreateViewDesc createVwDesc;
    protected ArrayList<String> viewsExpanded;
    protected HiveParserASTNode viewSelect;
    public final HiveParserUnparseTranslator unparseTranslator;
    private final GlobalLimitCtx globalLimitCtx;
    private final String autogenColAliasPrfxLbl;
    private final boolean autogenColAliasPrfxIncludeFuncName;
    private final Map<String, ReadEntity> viewAliasToInput;
    private boolean mergeIsDirect;
    protected boolean noscan;
    protected boolean partialscan;
    public volatile boolean disableJoinMerge = false;
    protected final boolean defaultJoinMerge;
    final Map<String, HiveParserBaseSemanticAnalyzer.CTEClause> aliasToCTEs;
    ArrayList<String> ctesExpanded;
    protected HiveParserBaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite;
    Map<String, Table> tabNameToTabObject;
    public ColumnAccessInfo columnAccessInfo;
    private final HiveConf conf;
    public HiveParserContext ctx;
    QueryProperties queryProperties;
    private final HiveShim hiveShim;
    private final Hive db;
    protected HashSet<ReadEntity> inputs = new LinkedHashSet<ReadEntity>();
    private final HiveParserQueryState queryState;
    private final FrameworkConfig frameworkConfig;
    private final RelOptCluster cluster;
    private final HiveParserBaseSemanticAnalyzer.CTEClause rootClause = new HiveParserBaseSemanticAnalyzer.CTEClause(null, null);

    public HiveParserSemanticAnalyzer(HiveParserQueryState queryState, HiveShim hiveShim, FrameworkConfig frameworkConfig, RelOptCluster cluster) throws SemanticException {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.hiveShim = hiveShim;
        try {
            this.db = Hive.get(this.conf);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        this.nameToSplitSample = new HashMap();
        this.prunedPartitions = new HashMap<String, PrunedPartitionList>();
        this.tabNameToTabObject = new HashMap<String, Table>();
        this.unparseTranslator = new HiveParserUnparseTranslator(this.conf);
        this.autogenColAliasPrfxLbl = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_AUTOGEN_COLUMNALIAS_PREFIX_LABEL);
        this.autogenColAliasPrfxIncludeFuncName = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTOGEN_COLUMNALIAS_PREFIX_INCLUDEFUNCNAME);
        this.queryProperties = new QueryProperties();
        this.aliasToCTEs = new HashMap<String, HiveParserBaseSemanticAnalyzer.CTEClause>();
        this.globalLimitCtx = new GlobalLimitCtx();
        this.viewAliasToInput = new HashMap<String, ReadEntity>();
        this.mergeIsDirect = true;
        this.partialscan = false;
        this.noscan = false;
        this.tabNameToTabObject = new HashMap<String, Table>();
        this.disableJoinMerge = this.defaultJoinMerge = !Boolean.parseBoolean(this.conf.get("hive.merge.nway.joins", "true"));
        this.frameworkConfig = frameworkConfig;
        this.cluster = cluster;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public void initCtx(HiveParserContext context) {
        this.ctx = context;
    }

    public QueryProperties getQueryProperties() {
        return this.queryProperties;
    }

    private void reset(boolean clearPartsCache) {
        if (clearPartsCache) {
            this.prunedPartitions.clear();
            this.mergeIsDirect = true;
        } else {
            this.mergeIsDirect = false;
        }
        this.tabNameToTabObject.clear();
        this.qb = null;
        this.ast = null;
        this.disableJoinMerge = this.defaultJoinMerge;
        this.aliasToCTEs.clear();
        this.nameToSplitSample.clear();
        this.resultSchema = null;
        this.createVwDesc = null;
        this.viewsExpanded = null;
        this.viewSelect = null;
        this.ctesExpanded = null;
        this.globalLimitCtx.disableOpt();
        this.viewAliasToInput.clear();
        this.unparseTranslator.clear();
        this.queryProperties.clear();
    }

    public void doPhase1QBExpr(HiveParserASTNode ast, HiveParserQBExpr qbexpr, String id, String alias) throws SemanticException {
        this.doPhase1QBExpr(ast, qbexpr, id, alias, false);
    }

    public void doPhase1QBExpr(HiveParserASTNode ast, HiveParserQBExpr qbexpr, String id, String alias, boolean insideView) throws SemanticException {
        assert (ast.getToken() != null);
        if (ast.getToken().getType() == 880) {
            HiveParserQB qb = new HiveParserQB(id, alias, true);
            qb.setInsideView(insideView);
            HiveParserBaseSemanticAnalyzer.Phase1Ctx ctx1 = HiveParserBaseSemanticAnalyzer.initPhase1Ctx();
            this.doPhase1(ast, qb, ctx1, null);
            qbexpr.setOpcode(HiveParserQBExpr.Opcode.NULLOP);
            qbexpr.setQB(qb);
        } else {
            int type = ast.getToken().getType();
            switch (type) {
                case 998: {
                    qbexpr.setOpcode(HiveParserQBExpr.Opcode.UNION);
                    break;
                }
                case 788: {
                    qbexpr.setOpcode(HiveParserQBExpr.Opcode.INTERSECTALL);
                    break;
                }
                case 789: {
                    qbexpr.setOpcode(HiveParserQBExpr.Opcode.INTERSECT);
                    break;
                }
                case 752: {
                    qbexpr.setOpcode(HiveParserQBExpr.Opcode.EXCEPTALL);
                    break;
                }
                case 753: {
                    qbexpr.setOpcode(HiveParserQBExpr.Opcode.EXCEPT);
                    break;
                }
                default: {
                    throw new SemanticException("Unsupported set operator type: " + type);
                }
            }
            assert (ast.getChild(0) != null);
            HiveParserQBExpr qbexpr1 = new HiveParserQBExpr(alias + SUBQUERY_TAG_1);
            this.doPhase1QBExpr((HiveParserASTNode)ast.getChild(0), qbexpr1, id + SUBQUERY_TAG_1, alias + SUBQUERY_TAG_1, insideView);
            qbexpr.setQBExpr1(qbexpr1);
            assert (ast.getChild(1) != null);
            HiveParserQBExpr qbexpr2 = new HiveParserQBExpr(alias + SUBQUERY_TAG_2);
            this.doPhase1QBExpr((HiveParserASTNode)ast.getChild(1), qbexpr2, id + SUBQUERY_TAG_2, alias + SUBQUERY_TAG_2, insideView);
            qbexpr.setQBExpr2(qbexpr2);
        }
    }

    private LinkedHashMap<String, HiveParserASTNode> doPhase1GetAggregationsFromSelect(HiveParserASTNode selExpr, HiveParserQB qb, String dest) throws SemanticException {
        LinkedHashMap<String, HiveParserASTNode> aggregationTrees = new LinkedHashMap<String, HiveParserASTNode>();
        ArrayList<HiveParserASTNode> wdwFns = new ArrayList<HiveParserASTNode>();
        for (int i = 0; i < selExpr.getChildCount(); ++i) {
            HiveParserASTNode function = (HiveParserASTNode)selExpr.getChild(i);
            if (function.getType() == 905 || function.getType() == 946) {
                function = (HiveParserASTNode)function.getChild(0);
            }
            this.doPhase1GetAllAggregations(function, aggregationTrees, wdwFns);
        }
        for (HiveParserASTNode wdwFn : wdwFns) {
            HiveParserWindowingSpec spec = qb.getWindowingSpec(dest);
            if (spec == null) {
                this.queryProperties.setHasWindowing(true);
                spec = new HiveParserWindowingSpec();
                qb.addDestToWindowingSpec(dest, spec);
            }
            HashMap<String, HiveParserASTNode> wExprsInDest = qb.getParseInfo().getWindowingExprsForClause(dest);
            int wColIdx = spec.getWindowExpressions() == null ? 0 : spec.getWindowExpressions().size();
            HiveParserWindowingSpec.WindowFunctionSpec wFnSpec = HiveParserBaseSemanticAnalyzer.processWindowFunction(wdwFn, (HiveParserASTNode)wdwFn.getChild(wdwFn.getChildCount() - 1));
            if (wExprsInDest != null && wExprsInDest.containsKey(wFnSpec.getExpression().toStringTree())) continue;
            wFnSpec.setAlias(wFnSpec.getName() + "_window_" + wColIdx);
            spec.addWindowFunction(wFnSpec);
            qb.getParseInfo().addWindowingExprToClause(dest, wFnSpec.getExpression());
        }
        return aggregationTrees;
    }

    private void doPhase1GetColumnAliasesFromSelect(HiveParserASTNode selectExpr, HiveParserQBParseInfo qbp) {
        for (int i = 0; i < selectExpr.getChildCount(); ++i) {
            HiveParserASTNode selExpr = (HiveParserASTNode)selectExpr.getChild(i);
            if (selExpr.getToken().getType() != 905 || selExpr.getChildCount() != 2) continue;
            String columnAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(selExpr.getChild(1).getText());
            qbp.setExprToColumnAlias((HiveParserASTNode)selExpr.getChild(0), columnAlias);
        }
    }

    private void doPhase1GetAllAggregations(HiveParserASTNode expressionTree, HashMap<String, HiveParserASTNode> aggregations, List<HiveParserASTNode> wdwFns) throws SemanticException {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 946) {
            return;
        }
        if (exprTokenType == 766 || exprTokenType == 767 || exprTokenType == 768) {
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(expressionTree.getChildCount() - 1).getType() == 1021) {
                wdwFns.add(expressionTree);
                this.doPhase1GetAllAggregations((HiveParserASTNode)expressionTree.getChild(expressionTree.getChildCount() - 1), aggregations, wdwFns);
                return;
            }
            if (expressionTree.getChild(0).getType() == 24) {
                String functionName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText());
                SqlOperator sqlOperator = HiveParserUtils.getAnySqlOperator(functionName, this.frameworkConfig.getOperatorTable());
                if (sqlOperator == null) {
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(functionName));
                }
                if (FunctionRegistry.impliesOrder(functionName)) {
                    throw new SemanticException(ErrorMsg.MISSING_OVER_CLAUSE.getMsg(functionName));
                }
                if (HiveParserUtils.isUDAF(sqlOperator)) {
                    if (HiveParserBaseSemanticAnalyzer.containsLeadLagUDF(expressionTree)) {
                        throw new SemanticException(ErrorMsg.MISSING_OVER_CLAUSE.getMsg(functionName));
                    }
                    aggregations.put(expressionTree.toStringTree(), expressionTree);
                    if (!HiveParserUtils.isNative(sqlOperator)) {
                        this.unparseTranslator.addIdentifierTranslation((HiveParserASTNode)expressionTree.getChild(0));
                    }
                    return;
                }
            }
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            this.doPhase1GetAllAggregations((HiveParserASTNode)expressionTree.getChild(i), aggregations, wdwFns);
        }
    }

    private String processTable(HiveParserQB qb, HiveParserASTNode tabref) throws SemanticException {
        HiveParserASTNode sampleClause;
        int[] indexes = HiveParserBaseSemanticAnalyzer.findTabRefIdxs(tabref);
        int aliasIndex = indexes[0];
        int propsIndex = indexes[1];
        int tsampleIndex = indexes[2];
        int ssampleIndex = indexes[3];
        HiveParserASTNode tableTree = (HiveParserASTNode)tabref.getChild(0);
        String tabIdName = HiveParserBaseSemanticAnalyzer.getUnescapedName(tableTree).toLowerCase();
        String alias = HiveParserBaseSemanticAnalyzer.findSimpleTableName(tabref, aliasIndex);
        if (propsIndex >= 0) {
            Tree propsAST = tabref.getChild(propsIndex);
            HashMap<String, String> props = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)propsAST.getChild(0));
            if ("TRUE".equals(props.get("insideView"))) {
                qb.getAliasInsideView().add(alias.toLowerCase());
            }
            qb.setTabProps(alias, props);
        }
        if (qb.exists(alias)) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.AMBIGUOUS_TABLE_ALIAS, tabref.getChild(aliasIndex)));
        }
        if (tsampleIndex >= 0) {
            sampleClause = (HiveParserASTNode)tabref.getChild(tsampleIndex);
            ArrayList<HiveParserASTNode> sampleCols = new ArrayList<HiveParserASTNode>();
            if (sampleClause.getChildCount() > 2) {
                for (int i = 2; i < sampleClause.getChildCount(); ++i) {
                    sampleCols.add((HiveParserASTNode)sampleClause.getChild(i));
                }
            }
            if (sampleCols.size() > 2) {
                throw new SemanticException(HiveParserUtils.generateErrorMessage((HiveParserASTNode)tabref.getChild(0), ErrorMsg.SAMPLE_RESTRICTION.getMsg()));
            }
            qb.getParseInfo().setTabSample(alias);
            if (this.unparseTranslator.isEnabled()) {
                for (HiveParserASTNode sampleCol : sampleCols) {
                    this.unparseTranslator.addIdentifierTranslation((HiveParserASTNode)sampleCol.getChild(0));
                }
            }
        } else if (ssampleIndex >= 0) {
            SplitSample sample;
            sampleClause = (HiveParserASTNode)tabref.getChild(ssampleIndex);
            Tree type = sampleClause.getChild(0);
            Tree numerator = sampleClause.getChild(1);
            String value = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(numerator.getText());
            if (type.getType() == 861) {
                double percent = Double.parseDouble(value);
                if (percent < 0.0 || percent > 100.0) {
                    throw new SemanticException(HiveParserUtils.generateErrorMessage((HiveParserASTNode)numerator, "Sampling percentage should be between 0 and 100"));
                }
                int seedNum = this.conf.getIntVar(HiveConf.ConfVars.HIVESAMPLERANDOMNUM);
                sample = new SplitSample(percent, seedNum);
            } else if (type.getType() == 902) {
                sample = new SplitSample(Integer.parseInt(value));
            } else {
                assert (type.getType() == 810);
                long length = Integer.parseInt(value.substring(0, value.length() - 1));
                char last = value.charAt(value.length() - 1);
                if (last == 'k' || last == 'K') {
                    length <<= 10;
                } else if (last == 'm' || last == 'M') {
                    length <<= 20;
                } else if (last == 'g' || last == 'G') {
                    length <<= 30;
                }
                int seedNum = this.conf.getIntVar(HiveConf.ConfVars.HIVESAMPLERANDOMNUM);
                sample = new SplitSample(length, seedNum);
            }
            String aliasId = HiveParserBaseSemanticAnalyzer.getAliasId(alias, qb);
            this.nameToSplitSample.put(aliasId, sample);
        }
        qb.setTabAlias(alias, tabIdName);
        if (qb.isInsideView()) {
            qb.getAliasInsideView().add(alias.toLowerCase());
        }
        qb.addAlias(alias);
        qb.getParseInfo().setSrcForAlias(alias, tableTree);
        if (!this.aliasToCTEs.containsKey(tabIdName)) {
            this.unparseTranslator.addTableNameTranslation(tableTree, SessionState.get().getCurrentDatabase());
            if (aliasIndex != 0) {
                this.unparseTranslator.addIdentifierTranslation((HiveParserASTNode)tabref.getChild(aliasIndex));
            }
        }
        return alias;
    }

    public Map<String, SplitSample> getNameToSplitSampleMap() {
        return this.nameToSplitSample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HiveParserASTNode genValuesTempTable(HiveParserASTNode originalFrom, HiveParserQB qb) throws SemanticException {
        List fromChildren = originalFrom.getChildren();
        HiveParserASTNode virtualTableRef = (HiveParserASTNode)fromChildren.get(0);
        Preconditions.checkArgument((virtualTableRef.getToken().getType() == 1017 ? 1 : 0) != 0, (Object)("Expected first child of TOK_VIRTUAL_TABLE to be TOK_VIRTUAL_TABREF but was " + virtualTableRef.getName()));
        List virtualTableRefChildren = virtualTableRef.getChildren();
        HiveParserASTNode tabName = (HiveParserASTNode)virtualTableRefChildren.get(0);
        if (tabName.getToken().getType() != 695) {
            throw new SemanticException(ErrorMsg.VALUES_TABLE_CONSTRUCTOR_NOT_SUPPORTED.getMsg());
        }
        HiveParserASTNode valuesTable = (HiveParserASTNode)fromChildren.get(1);
        Preconditions.checkArgument((valuesTable.getToken().getType() == 1012 ? 1 : 0) != 0, (Object)("Expected second child of TOK_VIRTUAL_TABLE to be TOK_VALUE_TABLE but was " + valuesTable.getName()));
        SessionState ss = SessionState.get();
        String tableName = (VALUES_TMP_TABLE_NAME_PREFIX + ss.getNextValuesTempTableSuffix()).toLowerCase();
        List rows = valuesTable.getChildren();
        ArrayList valuesData = new ArrayList(rows.size());
        try {
            ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
            boolean firstRow = true;
            for (Node n : rows) {
                HiveParserASTNode row = (HiveParserASTNode)n;
                Preconditions.checkArgument((row.getToken().getType() == 1013 ? 1 : 0) != 0, (Object)("Expected child of TOK_VALUE_TABLE to be TOK_VALUE_ROW but was " + row.getName()));
                List columns = row.getChildren();
                ArrayList<String> data = new ArrayList<String>(columns.size());
                int nextColNum = 1;
                for (Node n1 : columns) {
                    HiveParserASTNode column = (HiveParserASTNode)n1;
                    if (firstRow) {
                        fields.add(new FieldSchema("tmp_values_col" + nextColNum++, "string", ""));
                    }
                    data.add(HiveParserBaseSemanticAnalyzer.unparseExprForValuesClause(column));
                }
                firstRow = false;
                valuesData.add(data);
            }
            Table table = this.db.newTable(tableName);
            table.setSerializationLib(this.conf.getVar(HiveConf.ConfVars.HIVEDEFAULTSERDE));
            HiveTableUtil.setStorageFormat(table.getSd(), "TextFile", this.conf);
            table.setFields(fields);
            File dataLocation = Files.createTempDirectory(tableName, new FileAttribute[0]).toFile();
            try {
                table.setDataLocation(new Path(dataLocation.toURI().toString(), tableName));
                table.getTTable().setTemporary(true);
                table.setStoredAsSubDirectories(false);
                this.db.createTable(table, false);
            }
            finally {
                FileUtils.deleteQuietly((File)dataLocation);
            }
            qb.getValuesTableToData().put(tableName, valuesData);
        }
        catch (Exception e) {
            throw new SemanticException("Failed to create temp table for VALUES", e);
        }
        ClassicToken t = new ClassicToken(981);
        HiveParserASTNode tabRef = new HiveParserASTNode(t);
        t = new ClassicToken(980);
        HiveParserASTNode tabNameNode = new HiveParserASTNode(t);
        tabRef.addChild(tabNameNode);
        t = new ClassicToken(24, tableName);
        HiveParserASTNode identifier = new HiveParserASTNode(t);
        tabNameNode.addChild(identifier);
        return tabRef;
    }

    private String processSubQuery(HiveParserQB qb, HiveParserASTNode subq) throws SemanticException {
        if (subq.getChildCount() != 2) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.NO_SUBQUERY_ALIAS, subq));
        }
        HiveParserASTNode subqref = (HiveParserASTNode)subq.getChild(0);
        String alias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(subq.getChild(1).getText());
        HiveParserQBExpr qbexpr = new HiveParserQBExpr(alias);
        this.doPhase1QBExpr(subqref, qbexpr, qb.getId(), alias, qb.isInsideView());
        if (qb.exists(alias)) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.AMBIGUOUS_TABLE_ALIAS, subq.getChild(1)));
        }
        qb.setSubqAlias(alias, qbexpr);
        qb.addAlias(alias);
        this.unparseTranslator.addIdentifierTranslation((HiveParserASTNode)subq.getChild(1));
        return alias;
    }

    private void processCTE(HiveParserQB qb, HiveParserASTNode ctes) throws SemanticException {
        int numCTEs = ctes.getChildCount();
        for (int i = 0; i < numCTEs; ++i) {
            HiveParserASTNode cte = (HiveParserASTNode)ctes.getChild(i);
            HiveParserASTNode cteQry = (HiveParserASTNode)cte.getChild(0);
            String alias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(cte.getChild(1).getText());
            String qName = qb.getId() == null ? "" : qb.getId() + ":";
            if (this.aliasToCTEs.containsKey(qName = qName + alias.toLowerCase())) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.AMBIGUOUS_TABLE_ALIAS, cte.getChild(1)));
            }
            this.aliasToCTEs.put(qName, new HiveParserBaseSemanticAnalyzer.CTEClause(qName, cteQry));
        }
    }

    private HiveParserBaseSemanticAnalyzer.CTEClause findCTEFromName(HiveParserQB qb, String cteName) {
        StringBuilder qId = new StringBuilder();
        if (qb.getId() != null) {
            qId.append(qb.getId());
        }
        while (qId.length() > 0) {
            String nm = qId + ":" + cteName;
            HiveParserBaseSemanticAnalyzer.CTEClause cte = this.aliasToCTEs.get(nm);
            if (cte != null) {
                return cte;
            }
            int lastIndex = qId.lastIndexOf(":");
            lastIndex = Math.max(lastIndex, 0);
            qId.setLength(lastIndex);
        }
        return this.aliasToCTEs.get(cteName);
    }

    private void addCTEAsSubQuery(HiveParserQB qb, String cteName, String cteAlias) throws SemanticException {
        cteAlias = cteAlias == null ? cteName : cteAlias;
        HiveParserBaseSemanticAnalyzer.CTEClause cte = this.findCTEFromName(qb, cteName);
        HiveParserASTNode cteQryNode = cte.cteNode;
        HiveParserQBExpr cteQBExpr = new HiveParserQBExpr(cteAlias);
        this.doPhase1QBExpr(cteQryNode, cteQBExpr, qb.getId(), cteAlias);
        qb.rewriteCTEToSubq(cteAlias, cteName, cteQBExpr);
    }

    private void processJoin(HiveParserQB qb, HiveParserASTNode join) throws SemanticException {
        int numChildren = join.getChildCount();
        if (numChildren != 2 && numChildren != 3 && join.getToken().getType() != 1002) {
            throw new SemanticException(HiveParserUtils.generateErrorMessage(join, "Join with multiple children"));
        }
        this.queryProperties.incrementJoinCount(HiveParserUtils.isOuterJoinToken(join));
        for (int num = 0; num < numChildren; ++num) {
            HiveParserASTNode child = (HiveParserASTNode)join.getChild(num);
            if (child.getToken().getType() == 981) {
                this.processTable(qb, child);
                continue;
            }
            if (child.getToken().getType() == 945) {
                this.processSubQuery(qb, child);
                continue;
            }
            if (child.getToken().getType() == 879) {
                String inputAlias;
                this.queryProperties.setHasPTF(true);
                this.processPTF(qb, child);
                HiveParserPTFInvocationSpec ptfInvocationSpec = qb.getPTFInvocationSpec(child);
                String string = inputAlias = ptfInvocationSpec == null ? null : ptfInvocationSpec.getFunction().getAlias();
                if (inputAlias != null) continue;
                throw new SemanticException(HiveParserUtils.generateErrorMessage(child, "PTF invocation in a Join must have an alias"));
            }
            if (child.getToken().getType() == 806 || child.getToken().getType() == 807) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.LATERAL_VIEW_WITH_JOIN, join));
            }
            if (!HiveParserUtils.isJoinToken(child)) continue;
            this.processJoin(qb, child);
        }
    }

    private String processLateralView(HiveParserQB qb, HiveParserASTNode lateralView) throws SemanticException {
        String alias;
        int numChildren = lateralView.getChildCount();
        assert (numChildren == 2);
        HiveParserASTNode next = (HiveParserASTNode)lateralView.getChild(1);
        switch (next.getToken().getType()) {
            case 981: {
                alias = this.processTable(qb, next);
                break;
            }
            case 945: {
                alias = this.processSubQuery(qb, next);
                break;
            }
            case 806: 
            case 807: {
                alias = this.processLateralView(qb, next);
                break;
            }
            default: {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.LATERAL_VIEW_INVALID_CHILD, lateralView));
            }
        }
        alias = alias.toLowerCase();
        qb.getParseInfo().addLateralViewForAlias(alias, lateralView);
        qb.addAlias(alias);
        return alias;
    }

    public boolean doPhase1(HiveParserASTNode ast, HiveParserQB qb, HiveParserBaseSemanticAnalyzer.Phase1Ctx ctx1, HiveParserPlannerContext plannerCtx) throws SemanticException {
        boolean phase1Result = true;
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        boolean skipRecursion = false;
        if (ast.getToken() != null) {
            skipRecursion = true;
            switch (ast.getToken().getType()) {
                case 904: {
                    qb.countSelDi();
                }
                case 903: {
                    qb.countSel();
                    qbp.setSelExprForClause(ctx1.dest, ast);
                    int posn = 0;
                    if (((HiveParserASTNode)ast.getChild(0)).getToken().getType() == 344) {
                        HiveASTParseDriver pd = new HiveASTParseDriver();
                        String queryHintStr = ast.getChild(0).getText();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("QUERY HINT: " + queryHintStr);
                        }
                        try {
                            HiveParserASTNode hintNode = pd.parseHint(queryHintStr);
                            qbp.setHints(hintNode);
                            ++posn;
                        }
                        catch (HiveASTParseException e) {
                            throw new SemanticException("failed to parse query hint: " + e.getMessage(), e);
                        }
                    }
                    if (ast.getChild(posn).getChild(0).getType() == 992) {
                        this.queryProperties.setUsesScript(true);
                    }
                    LinkedHashMap<String, HiveParserASTNode> aggregations = this.doPhase1GetAggregationsFromSelect(ast, qb, ctx1.dest);
                    this.doPhase1GetColumnAliasesFromSelect(ast, qbp);
                    qbp.setAggregationExprsForClause(ctx1.dest, aggregations);
                    qbp.setDistinctFuncExprsForClause(ctx1.dest, HiveParserBaseSemanticAnalyzer.doPhase1GetDistinctFuncExprs(aggregations));
                    break;
                }
                case 1018: {
                    qbp.setWhrExprForClause(ctx1.dest, ast);
                    if (HiveParserSubQueryUtils.findSubQueries((HiveParserASTNode)ast.getChild(0)).isEmpty()) break;
                    this.queryProperties.setFilterWithSubQuery(true);
                    break;
                }
                case 786: {
                    String currentDatabase = SessionState.get().getCurrentDatabase();
                    String tabName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0).getChild(0), currentDatabase);
                    qbp.addInsertIntoTable(tabName, ast);
                    this.handleTokDestination(ctx1, ast, qbp, plannerCtx);
                    break;
                }
                case 737: {
                    this.handleTokDestination(ctx1, ast, qbp, plannerCtx);
                    break;
                }
                case 764: {
                    HiveParserASTNode frm;
                    int childCount = ast.getChildCount();
                    if (childCount != 1) {
                        throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, "Multiple Children " + childCount));
                    }
                    if (!qbp.getIsSubQ()) {
                        qbp.setQueryFromExpr(ast);
                    }
                    if ((frm = (HiveParserASTNode)ast.getChild(0)).getToken().getType() == 981) {
                        this.processTable(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 1016) {
                        HiveParserASTNode newFrom = this.genValuesTempTable(frm, qb);
                        ast.setChild(0, newFrom);
                        this.processTable(qb, newFrom);
                        break;
                    }
                    if (frm.getToken().getType() == 945) {
                        this.processSubQuery(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 806 || frm.getToken().getType() == 807) {
                        this.queryProperties.setHasLateralViews(true);
                        this.processLateralView(qb, frm);
                        break;
                    }
                    if (HiveParserUtils.isJoinToken(frm)) {
                        this.processJoin(qb, frm);
                        qbp.setJoinExpr(frm);
                        break;
                    }
                    if (frm.getToken().getType() != 879) break;
                    this.queryProperties.setHasPTF(true);
                    this.processPTF(qb, frm);
                    break;
                }
                case 705: {
                    this.queryProperties.setHasClusterBy(true);
                    qbp.setClusterByExprForClause(ctx1.dest, ast);
                    break;
                }
                case 741: {
                    this.queryProperties.setHasDistributeBy(true);
                    qbp.setDistributeByExprForClause(ctx1.dest, ast);
                    if (qbp.getClusterByForClause(ctx1.dest) != null) {
                        throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_DISTRIBUTEBY_CONFLICT.getMsg()));
                    }
                    if (qbp.getOrderByForClause(ctx1.dest) == null) break;
                    throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, ErrorMsg.ORDERBY_DISTRIBUTEBY_CONFLICT.getMsg()));
                }
                case 938: {
                    this.queryProperties.setHasSortBy(true);
                    qbp.setSortByExprForClause(ctx1.dest, ast);
                    if (qbp.getClusterByForClause(ctx1.dest) != null) {
                        throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_SORTBY_CONFLICT.getMsg()));
                    }
                    if (qbp.getOrderByForClause(ctx1.dest) == null) break;
                    throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, ErrorMsg.ORDERBY_SORTBY_CONFLICT.getMsg()));
                }
                case 855: {
                    this.queryProperties.setHasOrderBy(true);
                    qbp.setOrderByExprForClause(ctx1.dest, ast);
                    if (qbp.getClusterByForClause(ctx1.dest) == null) break;
                    throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_ORDERBY_CONFLICT.getMsg()));
                }
                case 721: 
                case 775: 
                case 776: 
                case 901: {
                    this.queryProperties.setHasGroupBy(true);
                    if (qbp.getJoinExpr() != null) {
                        this.queryProperties.setHasJoinFollowedByGroupBy(true);
                    }
                    if (qbp.getSelForClause(ctx1.dest).getToken().getType() == 904) {
                        throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, ErrorMsg.SELECT_DISTINCT_WITH_GROUPBY.getMsg()));
                    }
                    qbp.setGroupByExprForClause(ctx1.dest, ast);
                    skipRecursion = true;
                    if (ast.getToken().getType() == 901) {
                        qbp.getDestRollups().add(ctx1.dest);
                        break;
                    }
                    if (ast.getToken().getType() == 721) {
                        qbp.getDestCubes().add(ctx1.dest);
                        break;
                    }
                    if (ast.getToken().getType() != 776) break;
                    qbp.getDestGroupingSets().add(ctx1.dest);
                    break;
                }
                case 778: {
                    qbp.setHavingExprForClause(ctx1.dest, ast);
                    qbp.addAggregationExprsForClause(ctx1.dest, this.doPhase1GetAggregationsFromSelect(ast, qb, ctx1.dest));
                    break;
                }
                case 326: {
                    if (!qb.hasWindowingSpec(ctx1.dest)) {
                        throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, "Query has no Cluster/Distribute By; but has a Window definition"));
                    }
                    HiveParserBaseSemanticAnalyzer.handleQueryWindowClauses(qb, ctx1, ast);
                    break;
                }
                case 812: {
                    if (ast.getChildCount() == 2) {
                        qbp.setDestLimit(ctx1.dest, new Integer(ast.getChild(0).getText()), new Integer(ast.getChild(1).getText()));
                        break;
                    }
                    qbp.setDestLimit(ctx1.dest, 0, new Integer(ast.getChild(0).getText()));
                    break;
                }
                case 694: {
                    String tableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0).getChild(0)).toLowerCase();
                    qb.setTabAlias(tableName, tableName);
                    qb.addAlias(tableName);
                    qb.getParseInfo().setIsAnalyzeCommand(true);
                    qb.getParseInfo().setNoScanAnalyzeCommand(this.noscan);
                    qb.getParseInfo().setPartialScanAnalyzeCommand(this.partialscan);
                    HiveConf.setVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
                    HiveConf.setVar(this.conf, HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
                    break;
                }
                case 998: {
                    if (!qbp.getIsSubQ()) {
                        throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, ErrorMsg.UNION_NOTIN_SUBQ.getMsg()));
                    }
                    skipRecursion = false;
                    break;
                }
                case 785: {
                    HiveParserASTNode destination = (HiveParserASTNode)ast.getChild(0);
                    Tree tab = destination.getChild(0);
                    if (destination.getChildCount() == 2 && tab.getChildCount() == 2 && destination.getChild(1).getType() == 780) {
                        Table table;
                        String name = tab.getChild(0).getChild(0).getText();
                        Tree partitions = tab.getChild(1);
                        int numChildren = partitions.getChildCount();
                        HashMap<String, String> partition = new HashMap<String, String>();
                        for (int i = 0; i < numChildren; ++i) {
                            String partitionName = partitions.getChild(i).getChild(0).getText();
                            Tree pvalue = partitions.getChild(i).getChild(1);
                            if (pvalue == null) break;
                            String partitionVal = HiveParserBaseSemanticAnalyzer.stripQuotes(pvalue.getText());
                            partition.put(partitionName, partitionVal);
                        }
                        if (numChildren != partition.size()) {
                            throw new SemanticException(ErrorMsg.INSERT_INTO_DYNAMICPARTITION_IFNOTEXISTS.getMsg(partition.toString()));
                        }
                        try {
                            table = this.getTableObjectByName(name);
                        }
                        catch (HiveException ex) {
                            throw new SemanticException(ex);
                        }
                        try {
                            Partition parMetaData = this.db.getPartition(table, partition, false);
                            if (parMetaData != null) {
                                phase1Result = false;
                                skipRecursion = true;
                                LOG.info("Partition already exists so insert into overwrite skipped for partition : " + parMetaData.toString());
                                break;
                            }
                        }
                        catch (HiveException e) {
                            LOG.info("Error while getting metadata : ", (Throwable)e);
                        }
                        HiveParserBaseSemanticAnalyzer.validatePartSpec(table, partition, (HiveParserASTNode)tab, this.conf, false, this.frameworkConfig, this.cluster);
                    }
                    skipRecursion = false;
                    break;
                }
                case 806: 
                case 807: {
                    assert (ast.getChildCount() == 1);
                    qb.getParseInfo().getDestToLateralView().put(ctx1.dest, ast);
                    break;
                }
                case 720: {
                    this.processCTE(qb, ast);
                    break;
                }
                default: {
                    skipRecursion = false;
                }
            }
        }
        if (!skipRecursion) {
            int childCount = ast.getChildCount();
            for (int childPos = 0; childPos < childCount && phase1Result; ++childPos) {
                phase1Result = this.doPhase1((HiveParserASTNode)ast.getChild(childPos), qb, ctx1, plannerCtx);
            }
        }
        return phase1Result;
    }

    private void handleTokDestination(HiveParserBaseSemanticAnalyzer.Phase1Ctx ctx1, HiveParserASTNode ast, HiveParserQBParseInfo qbp, HiveParserPlannerContext plannerCtx) throws SemanticException {
        ctx1.dest = this.ctx.getDestNamePrefix(ast).toString() + ctx1.nextNum;
        ++ctx1.nextNum;
        boolean isTmpFileDest = false;
        if (ast.getChildCount() > 0 && ast.getChild(0) instanceof HiveParserASTNode) {
            HiveParserASTNode ch = (HiveParserASTNode)ast.getChild(0);
            if (ch.getToken().getType() == 739 && ch.getChildCount() > 0 && ch.getChild(0) instanceof HiveParserASTNode) {
                isTmpFileDest = (ch = (HiveParserASTNode)ch.getChild(0)).getToken().getType() == 990;
            } else if (ast.getToken().getType() == 737 && ast.getChild(0).getType() == 952) {
                String fullTableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0).getChild(0), SessionState.get().getCurrentDatabase());
                qbp.getInsertOverwriteTables().put(fullTableName, ast);
            }
        }
        if (qbp.getIsSubQ() && !isTmpFileDest) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.NO_INSERT_INSUBQUERY, ast));
        }
        qbp.setDestForClause(ctx1.dest, (HiveParserASTNode)ast.getChild(0));
        this.handleInsertStatementSpecPhase1(ast, qbp, ctx1);
        if (qbp.getClauseNamesForDest().size() == 2) {
            this.queryProperties.setMultiDestQuery(true);
        }
        if (plannerCtx != null && !this.queryProperties.hasMultiDestQuery()) {
            plannerCtx.setInsertToken(ast, isTmpFileDest);
        } else if (plannerCtx != null && qbp.getClauseNamesForDest().size() == 2) {
            plannerCtx.resetToken();
            plannerCtx.setMultiInsertToken((HiveParserASTNode)qbp.getQueryFrom().getChild(0));
        }
    }

    private void handleInsertStatementSpecPhase1(HiveParserASTNode ast, HiveParserQBParseInfo qbp, HiveParserBaseSemanticAnalyzer.Phase1Ctx ctx1) throws SemanticException {
        HiveParserASTNode tabColName = (HiveParserASTNode)ast.getChild(1);
        if (ast.getType() == 786 && tabColName != null && tabColName.getType() == 956) {
            Table targetTable;
            ArrayList<String> targetColNames = new ArrayList<String>();
            for (Node col : tabColName.getChildren()) {
                assert (((HiveParserASTNode)col).getType() == 24) : "expected token 24 found " + ((HiveParserASTNode)col).getType();
                targetColNames.add(((HiveParserASTNode)col).getText());
            }
            String fullTableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0).getChild(0), SessionState.get().getCurrentDatabase());
            qbp.setDestSchemaForClause(ctx1.dest, targetColNames);
            HashSet<String> targetColumns = new HashSet<String>(targetColNames);
            if (targetColNames.size() != targetColumns.size()) {
                throw new SemanticException(HiveParserUtils.generateErrorMessage(tabColName, "Duplicate column name detected in " + fullTableName + " table schema specification"));
            }
            try {
                targetTable = this.db.getTable(fullTableName, false);
            }
            catch (HiveException ex) {
                LOG.error("Error processing HiveASTParser.TOK_DESTINATION: " + ex.getMessage(), (Throwable)ex);
                throw new SemanticException(ex);
            }
            if (targetTable == null) {
                throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, "Unable to access metadata for table " + fullTableName));
            }
            for (FieldSchema f : targetTable.getCols()) {
                targetColumns.remove(f.getName());
            }
            if (!targetColumns.isEmpty()) {
                HiveParserASTNode tokTab;
                HiveParserASTNode tokPartSpec;
                ArrayList<String> dynamicPartitionColumns = new ArrayList<String>();
                if (ast.getChild(0) != null && ast.getChild(0).getType() == 952 && (tokPartSpec = (HiveParserASTNode)(tokTab = (HiveParserASTNode)ast.getChild(0)).getFirstChildWithType(859)) != null) {
                    for (Node n : tokPartSpec.getChildren()) {
                        HiveParserASTNode tokPartVal = null;
                        if (n instanceof HiveParserASTNode) {
                            tokPartVal = (HiveParserASTNode)n;
                        }
                        if (tokPartVal == null || tokPartVal.getType() != 860 || tokPartVal.getChildCount() != 1) continue;
                        assert (tokPartVal.getChild(0).getType() == 24) : "Expected column name; found tokType=" + tokPartVal.getType();
                        dynamicPartitionColumns.add(tokPartVal.getChild(0).getText());
                    }
                }
                for (String colName : dynamicPartitionColumns) {
                    targetColumns.remove(colName);
                }
                if (!targetColumns.isEmpty()) {
                    throw new SemanticException(HiveParserUtils.generateErrorMessage(tabColName, "'" + (targetColumns.size() == 1 ? targetColumns.iterator().next() : targetColumns) + "' in insert schema specification " + (targetColumns.size() == 1 ? "is" : "are") + " not found among regular columns of " + fullTableName + " nor dynamic partition columns."));
                }
            }
        }
    }

    public void getMaterializationMetadata(HiveParserQB qb) throws SemanticException {
        try {
            this.gatherCTEReferences(qb, this.rootClause);
            int threshold = Integer.parseInt(this.conf.get("hive.optimize.cte.materialize.threshold", "-1"));
            for (HiveParserBaseSemanticAnalyzer.CTEClause cte : new HashSet<HiveParserBaseSemanticAnalyzer.CTEClause>(this.aliasToCTEs.values())) {
                if (threshold < 0 || cte.reference < threshold) continue;
                cte.materialize = true;
            }
        }
        catch (HiveException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            if (e instanceof SemanticException) {
                throw (SemanticException)e;
            }
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private void gatherCTEReferences(HiveParserQBExpr qbexpr, HiveParserBaseSemanticAnalyzer.CTEClause parent) throws HiveException {
        if (qbexpr.getOpcode() == HiveParserQBExpr.Opcode.NULLOP) {
            this.gatherCTEReferences(qbexpr.getQB(), parent);
        } else {
            this.gatherCTEReferences(qbexpr.getQBExpr1(), parent);
            this.gatherCTEReferences(qbexpr.getQBExpr2(), parent);
        }
    }

    private void gatherCTEReferences(HiveParserQB qb, HiveParserBaseSemanticAnalyzer.CTEClause current) throws HiveException {
        for (String alias : qb.getTabAliases()) {
            String tabName = qb.getTabNameForAlias(alias);
            String cteName = tabName.toLowerCase();
            HiveParserBaseSemanticAnalyzer.CTEClause cte = this.findCTEFromName(qb, cteName);
            if (cte == null) continue;
            if (this.ctesExpanded.contains(cteName)) {
                throw new SemanticException("Recursive cte " + cteName + " detected (cycle: " + org.apache.commons.lang3.StringUtils.join(this.ctesExpanded, " -> ") + " -> " + cteName + ").");
            }
            ++cte.reference;
            current.parents.add(cte);
            if (cte.qbExpr != null) continue;
            cte.qbExpr = new HiveParserQBExpr(cteName);
            this.doPhase1QBExpr(cte.cteNode, cte.qbExpr, qb.getId(), cteName);
            this.ctesExpanded.add(cteName);
            this.gatherCTEReferences(cte.qbExpr, cte);
            this.ctesExpanded.remove(this.ctesExpanded.size() - 1);
        }
        for (String alias : qb.getSubqAliases()) {
            this.gatherCTEReferences(qb.getSubqForAlias(alias), current);
        }
    }

    public void getMetaData(HiveParserQB qb) throws SemanticException {
        this.getMetaData(qb, false);
    }

    public void getMetaData(HiveParserQB qb, boolean enableMaterialization) throws SemanticException {
        try {
            if (enableMaterialization) {
                this.getMaterializationMetadata(qb);
            }
            this.getMetaData(qb, null);
        }
        catch (HiveException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            if (e instanceof SemanticException) {
                throw (SemanticException)e;
            }
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private void getMetaData(HiveParserQBExpr qbexpr, ReadEntity parentInput) throws HiveException {
        if (qbexpr.getOpcode() == HiveParserQBExpr.Opcode.NULLOP) {
            this.getMetaData(qbexpr.getQB(), parentInput);
        } else {
            this.getMetaData(qbexpr.getQBExpr1(), parentInput);
            this.getMetaData(qbexpr.getQBExpr2(), parentInput);
        }
    }

    private void getMetaData(HiveParserQB qb, ReadEntity parentInput) throws HiveException {
        LOG.info("Get metadata for source tables");
        ArrayList<String> tabAliases = new ArrayList<String>(qb.getTabAliases());
        HashMap<String, ObjectPair<String, ReadEntity>> aliasToViewInfo = new HashMap<String, ObjectPair<String, ReadEntity>>();
        HashMap<String, String> sqAliasToCTEName = new HashMap<String, String>();
        for (String alias : tabAliases) {
            HiveParserBaseSemanticAnalyzer.CTEClause cte;
            String tabName = qb.getTabNameForAlias(alias);
            String cteName = tabName.toLowerCase();
            Table tab = this.db.getTable(tabName, false);
            if ((tab == null || tab.getDbName().equals(SessionState.get().getCurrentDatabase())) && (cte = this.findCTEFromName(qb, cteName)) != null) {
                if (!cte.materialize) {
                    this.addCTEAsSubQuery(qb, cteName, alias);
                    sqAliasToCTEName.put(alias, cteName);
                    continue;
                }
                throw new SemanticException("Materializing CTE is not supported at the moment");
            }
            if (tab == null) {
                HiveParserASTNode src = qb.getParseInfo().getSrcForAlias(alias);
                if (null != src) {
                    throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_TABLE, src));
                }
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(alias));
            }
            if (tab.isView()) {
                if (qb.getParseInfo().isAnalyzeCommand()) {
                    throw new SemanticException(ErrorMsg.ANALYZE_VIEW.getMsg());
                }
                String fullViewName = tab.getDbName() + "." + tab.getTableName();
                if (this.viewsExpanded.contains(fullViewName)) {
                    throw new SemanticException("Recursive view " + fullViewName + " detected (cycle: " + org.apache.commons.lang3.StringUtils.join(this.viewsExpanded, " -> ") + " -> " + fullViewName + ").");
                }
                this.replaceViewReferenceWithDefinition(qb, tab, tabName, alias);
                if (qb.isInsideView() && parentInput == null) {
                    parentInput = PlanUtils.getParentViewInfo(HiveParserBaseSemanticAnalyzer.getAliasId(alias, qb), this.viewAliasToInput);
                }
                ReadEntity viewInput = new ReadEntity(tab, parentInput, !qb.isInsideView());
                viewInput = PlanUtils.addInput(this.inputs, viewInput);
                aliasToViewInfo.put(alias, new ObjectPair<String, ReadEntity>(fullViewName, viewInput));
                String aliasId = HiveParserBaseSemanticAnalyzer.getAliasId(alias, qb);
                if (aliasId != null) {
                    aliasId = aliasId.replace(SUBQUERY_TAG_1, "").replace(SUBQUERY_TAG_2, "");
                }
                this.viewAliasToInput.put(aliasId, viewInput);
                continue;
            }
            if (!InputFormat.class.isAssignableFrom(tab.getInputFormatClass())) {
                throw new SemanticException(HiveParserUtils.generateErrorMessage(qb.getParseInfo().getSrcForAlias(alias), ErrorMsg.INVALID_INPUT_FORMAT_TYPE.getMsg()));
            }
            qb.getMetaData().setSrcForAlias(alias, tab);
            if (qb.getParseInfo().isAnalyzeCommand()) {
                HiveParserQBParseInfo qbpi;
                HiveParserBaseSemanticAnalyzer.TableSpec ts = new HiveParserBaseSemanticAnalyzer.TableSpec(this.db, this.conf, (HiveParserASTNode)this.ast.getChild(0), true, this.noscan, this.frameworkConfig, this.cluster);
                if (ts.specType == HiveParserBaseSemanticAnalyzer.TableSpec.SpecType.DYNAMIC_PARTITION) {
                    try {
                        ts.partitions = this.db.getPartitionsByNames(ts.tableHandle, ts.partSpec);
                    }
                    catch (HiveException e) {
                        throw new SemanticException(HiveParserUtils.generateErrorMessage(qb.getParseInfo().getSrcForAlias(alias), "Cannot get partitions for " + ts.partSpec), e);
                    }
                }
                if ((qbpi = qb.getParseInfo()).isPartialScanAnalyzeCommand()) {
                    Class<? extends InputFormat> inputFormatClass = null;
                    switch (ts.specType) {
                        case TABLE_ONLY: 
                        case DYNAMIC_PARTITION: {
                            inputFormatClass = ts.tableHandle.getInputFormatClass();
                            break;
                        }
                        case STATIC_PARTITION: {
                            inputFormatClass = ts.partHandle.getInputFormatClass();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    if (!inputFormatClass.equals(RCFileInputFormat.class) && !inputFormatClass.equals(OrcInputFormat.class)) {
                        throw new SemanticException("ANALYZE TABLE PARTIALSCAN doesn't support non-RCfile.");
                    }
                }
                qb.getParseInfo().addTableSpec(alias, ts);
            }
            ReadEntity parentViewInfo = PlanUtils.getParentViewInfo(HiveParserBaseSemanticAnalyzer.getAliasId(alias, qb), this.viewAliasToInput);
            if (HiveParserUtils.isValuesTempTable(alias)) continue;
            HiveParserUtils.addInput(this.inputs, new ReadEntity(tab, parentViewInfo, parentViewInfo == null), this.mergeIsDirect);
        }
        LOG.info("Get metadata for subqueries");
        for (String alias : qb.getSubqAliases()) {
            boolean wasView = aliasToViewInfo.containsKey(alias);
            boolean wasCTE = sqAliasToCTEName.containsKey(alias);
            ReadEntity newParentInput = null;
            if (wasView) {
                this.viewsExpanded.add((String)((ObjectPair)aliasToViewInfo.get(alias)).getFirst());
                newParentInput = (ReadEntity)((ObjectPair)aliasToViewInfo.get(alias)).getSecond();
            } else if (wasCTE) {
                this.ctesExpanded.add((String)sqAliasToCTEName.get(alias));
            }
            HiveParserQBExpr qbexpr = qb.getSubqForAlias(alias);
            this.getMetaData(qbexpr, newParentInput);
            if (wasView) {
                this.viewsExpanded.remove(this.viewsExpanded.size() - 1);
                continue;
            }
            if (!wasCTE) continue;
            this.ctesExpanded.remove(this.ctesExpanded.size() - 1);
        }
        HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams rowFormatParams = new HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams();
        HiveParserStorageFormat storageFormat = new HiveParserStorageFormat(this.conf);
        LOG.info("Get metadata for destination tables");
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        block18: for (String name : qbp.getClauseNamesForDest()) {
            HiveParserASTNode ast = qbp.getDestForClause(name);
            switch (ast.getToken().getType()) {
                case 952: {
                    HiveParserBaseSemanticAnalyzer.TableSpec ts = new HiveParserBaseSemanticAnalyzer.TableSpec(this.db, this.conf, ast, this.frameworkConfig, this.cluster);
                    if (ts.tableHandle.isView() || this.hiveShim.isMaterializedView(ts.tableHandle)) {
                        throw new SemanticException(ErrorMsg.DML_AGAINST_VIEW.getMsg());
                    }
                    Class<? extends OutputFormat> outputFormatClass = ts.tableHandle.getOutputFormatClass();
                    if (!ts.tableHandle.isNonNative() && !HiveOutputFormat.class.isAssignableFrom(outputFormatClass)) {
                        throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE, ast, "The class is " + outputFormatClass.toString()));
                    }
                    boolean isTableWrittenTo = qb.getParseInfo().isInsertIntoTable(ts.tableHandle.getDbName(), ts.tableHandle.getTableName());
                    assert (isTableWrittenTo |= qb.getParseInfo().getInsertOverwriteTables().get(HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0), ts.tableHandle.getDbName())) != null) : "Inconsistent data structure detected: we are writing to " + ts.tableHandle + " in " + name + " but it's not in isInsertIntoTable() or getInsertOverwriteTables()";
                    if (ts.specType != HiveParserBaseSemanticAnalyzer.TableSpec.SpecType.STATIC_PARTITION) {
                        qb.getMetaData().setDestForAlias(name, ts.tableHandle);
                        if (ts.partSpec != null && ts.partSpec.size() > 0) {
                            qb.getMetaData().setPartSpecForAlias(name, ts.partSpec);
                        }
                    } else {
                        qb.getMetaData().setDestForAlias(name, ts.partHandle);
                    }
                    if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESTATSAUTOGATHER)) continue block18;
                    qb.getParseInfo().addTableSpec(ts.tableName.toLowerCase(), ts);
                    continue block18;
                }
                case 739: {
                    String fname = HiveParserBaseSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
                    if (!qb.getParseInfo().getIsSubQ() && ((HiveParserASTNode)ast.getChild(0)).getToken().getType() == 990) {
                        if (qb.isCTAS() || qb.isMaterializedView()) {
                            Path location;
                            qb.setIsQuery(false);
                            if (qb.getTableDesc() != null && qb.getTableDesc().getLocation() != null) {
                                location = new Path(qb.getTableDesc().getLocation());
                            } else {
                                String tableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
                                String[] names = Utilities.getDbTableName(tableName);
                                try {
                                    String destTableDb;
                                    Warehouse wh = new Warehouse(this.conf);
                                    String string = destTableDb = qb.getTableDesc() != null ? qb.getTableDesc().getDatabaseName() : null;
                                    if (destTableDb == null) {
                                        destTableDb = names[0];
                                    }
                                    location = wh.getDatabasePath(this.db.getDatabase(destTableDb));
                                }
                                catch (MetaException e) {
                                    throw new SemanticException(e);
                                }
                            }
                            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                                HiveParserBaseSemanticAnalyzer.TableSpec ts = new HiveParserBaseSemanticAnalyzer.TableSpec(this.db, this.conf, this.ast, this.frameworkConfig, this.cluster);
                                qb.getParseInfo().addTableSpec(ts.tableName.toLowerCase(), ts);
                            }
                        } else {
                            qb.setIsQuery(true);
                        }
                    }
                    boolean isDfsFile = true;
                    if (ast.getChildCount() >= 2 && ast.getChild(1).getText().toLowerCase().equals("local")) {
                        isDfsFile = false;
                    }
                    qb.getMetaData().setDestForAlias(name, fname, isDfsFile);
                    CreateTableDesc directoryDesc = new CreateTableDesc();
                    boolean directoryDescIsSet = false;
                    int numCh = ast.getChildCount();
                    block19: for (int num = 1; num < numCh; ++num) {
                        HiveParserASTNode child = (HiveParserASTNode)ast.getChild(num);
                        if (child == null) continue;
                        if (storageFormat.fillStorageFormat(child)) {
                            directoryDesc.setOutputFormat(storageFormat.getOutputFormat());
                            directoryDesc.setSerName(storageFormat.getSerde());
                            directoryDescIsSet = true;
                            continue;
                        }
                        switch (child.getToken().getType()) {
                            case 968: {
                                rowFormatParams.analyzeRowFormat(child);
                                directoryDesc.setFieldDelim(rowFormatParams.fieldDelim);
                                directoryDesc.setLineDelim(rowFormatParams.lineDelim);
                                directoryDesc.setCollItemDelim(rowFormatParams.collItemDelim);
                                directoryDesc.setMapKeyDelim(rowFormatParams.mapKeyDelim);
                                directoryDesc.setFieldEscape(rowFormatParams.fieldEscape);
                                directoryDesc.setNullFormat(rowFormatParams.nullFormat);
                                directoryDescIsSet = true;
                                continue block19;
                            }
                            case 974: {
                                HiveParserASTNode serdeChild = (HiveParserASTNode)child.getChild(0);
                                storageFormat.setSerde(HiveParserBaseSemanticAnalyzer.unescapeSQLString(serdeChild.getChild(0).getText()));
                                directoryDesc.setSerName(storageFormat.getSerde());
                                if (serdeChild.getChildCount() > 1) {
                                    directoryDesc.setSerdeProps(new HashMap<String, String>());
                                    HiveParserBaseSemanticAnalyzer.readProps((HiveParserASTNode)serdeChild.getChild(1).getChild(0), directoryDesc.getSerdeProps());
                                }
                                directoryDescIsSet = true;
                            }
                        }
                    }
                    if (!directoryDescIsSet) continue block18;
                    qb.setDirectoryDesc(directoryDesc);
                    continue block18;
                }
            }
            throw new SemanticException(HiveParserUtils.generateErrorMessage(ast, "Unknown Token Type " + ast.getToken().getType()));
        }
    }

    private void replaceViewReferenceWithDefinition(HiveParserQB qb, Table tab, String tabName, String alias) throws SemanticException {
        HiveParserASTNode viewTree;
        HiveParserASTNodeOrigin viewOrigin = new HiveParserASTNodeOrigin("VIEW", tab.getTableName(), tab.getViewExpandedText(), alias, qb.getParseInfo().getSrcForAlias(alias));
        try {
            String viewText = tab.getViewExpandedText();
            viewTree = HiveASTParseUtils.parse(viewText, this.ctx, tab.getCompleteName());
            Dispatcher nodeOriginDispatcher = (nd, stack, nodeOutputs) -> {
                ((HiveParserASTNode)nd).setOrigin(viewOrigin);
                return null;
            };
            HiveParserDefaultGraphWalker nodeOriginTagger = new HiveParserDefaultGraphWalker(nodeOriginDispatcher);
            nodeOriginTagger.startWalking(Collections.singleton(viewTree), null);
        }
        catch (HiveASTParseException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        HiveParserQBExpr qbexpr = new HiveParserQBExpr(alias);
        this.doPhase1QBExpr(viewTree, qbexpr, qb.getId(), alias, true);
        if (!this.skipAuthorization() && !qb.isInsideView() && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED) || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS)) {
            qb.rewriteViewToSubq(alias, tabName, qbexpr, tab);
        } else {
            qb.rewriteViewToSubq(alias, tabName, qbexpr, null);
        }
    }

    private boolean skipAuthorization() {
        return true;
    }

    public Integer genColListRegex(String colRegex, String tabAlias, HiveParserASTNode sel, ArrayList<ExprNodeDesc> colList, HashSet<ColumnInfo> excludeCols, HiveParserRowResolver input, HiveParserRowResolver colSrcRR, Integer pos, HiveParserRowResolver output, List<String> aliases, boolean ensureUniqueCols) throws SemanticException {
        Pattern regex;
        if (colSrcRR == null) {
            colSrcRR = input;
        }
        if (tabAlias != null && !colSrcRR.hasTableAlias(tabAlias)) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_TABLE_ALIAS, sel));
        }
        try {
            regex = Pattern.compile(colRegex, 2);
        }
        catch (PatternSyntaxException e) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_COLUMN, sel, e.getMessage()));
        }
        StringBuilder replacementText = new StringBuilder();
        int matched = 0;
        if (!aliases.contains("")) {
            aliases.add("");
        }
        HashMap<ColumnInfo, ColumnInfo> inputColsProcessed = new HashMap<ColumnInfo, ColumnInfo>();
        if (colSrcRR.getNamedJoinInfo() != null) {
            LinkedHashMap<String, ColumnInfo> leftMap = colSrcRR.getFieldMap(colSrcRR.getNamedJoinInfo().getAliases().get(0));
            LinkedHashMap<String, ColumnInfo> rightMap = colSrcRR.getFieldMap(colSrcRR.getNamedJoinInfo().getAliases().get(1));
            LinkedHashMap<String, ColumnInfo> chosenMap = null;
            chosenMap = colSrcRR.getNamedJoinInfo().getHiveJoinType() != JoinType.RIGHTOUTER ? leftMap : rightMap;
            for (String columnName : colSrcRR.getNamedJoinInfo().getNamedColumns()) {
                for (Map.Entry entry : ((HashMap)chosenMap).entrySet()) {
                    ColumnInfo colInfo = (ColumnInfo)entry.getValue();
                    if (!columnName.equals(colInfo.getAlias())) continue;
                    String name = colInfo.getInternalName();
                    String[] tmp = colSrcRR.reverseLookup(name);
                    if (tabAlias != null && !tmp[0].equalsIgnoreCase(tabAlias) || colInfo.getIsVirtualCol() && colInfo.isHiddenVirtualCol()) continue;
                    ColumnInfo oColInfo = (ColumnInfo)inputColsProcessed.get(colInfo);
                    if (oColInfo == null) {
                        ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo.getType(), name, colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isSkewedCol());
                        colList.add(expr);
                        oColInfo = new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
                        inputColsProcessed.put(colInfo, oColInfo);
                    }
                    if (ensureUniqueCols) {
                        if (!output.putWithCheck(tmp[0], tmp[1], null, oColInfo)) {
                            throw new SemanticException("Cannot add column to RR: " + tmp[0] + "." + tmp[1] + " => " + oColInfo + " due to duplication, see previous warnings");
                        }
                    } else {
                        output.put(tmp[0], tmp[1], oColInfo);
                    }
                    pos = pos + 1;
                    ++matched;
                    if (!this.unparseTranslator.isEnabled()) continue;
                    if (replacementText.length() > 0) {
                        replacementText.append(", ");
                    }
                    replacementText.append(HiveUtils.unparseIdentifier(tmp[0], this.conf));
                    replacementText.append(".");
                    replacementText.append(HiveUtils.unparseIdentifier(tmp[1], this.conf));
                }
            }
        }
        for (String alias : aliases) {
            LinkedHashMap<String, ColumnInfo> fMap = colSrcRR.getFieldMap(alias);
            if (fMap == null) continue;
            for (Map.Entry entry : ((HashMap)fMap).entrySet()) {
                ColumnInfo oColInfo;
                ColumnInfo colInfo = (ColumnInfo)entry.getValue();
                if (colSrcRR.getNamedJoinInfo() != null && colSrcRR.getNamedJoinInfo().getNamedColumns().contains(colInfo.getAlias()) || excludeCols != null && excludeCols.contains(colInfo)) continue;
                String name = colInfo.getInternalName();
                String[] tmp = colSrcRR.reverseLookup(name);
                if (tabAlias != null && !tmp[0].equalsIgnoreCase(tabAlias) || colInfo.getIsVirtualCol() && colInfo.isHiddenVirtualCol() || !regex.matcher(tmp[1]).matches()) continue;
                if (input != colSrcRR) {
                    colInfo = input.get(tabAlias, tmp[1]);
                    if (colInfo == null) {
                        LOG.error("Cannot find colInfo for " + tabAlias + "." + tmp[1] + ", derived from [" + colSrcRR + "], in [" + input + "]");
                        throw new SemanticException(ErrorMsg.NON_KEY_EXPR_IN_GROUPBY, tmp[1]);
                    }
                    String oldCol = null;
                    if (LOG.isDebugEnabled()) {
                        oldCol = name + " => " + (tmp == null ? "null" : tmp[0] + "." + tmp[1]);
                    }
                    name = colInfo.getInternalName();
                    tmp = input.reverseLookup(name);
                    if (LOG.isDebugEnabled()) {
                        String newCol = name + " => " + (tmp == null ? "null" : tmp[0] + "." + tmp[1]);
                        LOG.debug("Translated [" + oldCol + "] to [" + newCol + "]");
                    }
                }
                if ((oColInfo = (ColumnInfo)inputColsProcessed.get(colInfo)) == null) {
                    ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo.getType(), name, colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isSkewedCol());
                    colList.add(expr);
                    oColInfo = new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
                    inputColsProcessed.put(colInfo, oColInfo);
                }
                if (ensureUniqueCols) {
                    if (!output.putWithCheck(tmp[0], tmp[1], null, oColInfo)) {
                        throw new SemanticException("Cannot add column to RR: " + tmp[0] + "." + tmp[1] + " => " + oColInfo + " due to duplication, see previous warnings");
                    }
                } else {
                    output.put(tmp[0], tmp[1], oColInfo);
                }
                Integer n = pos;
                Integer n2 = pos = Integer.valueOf(pos + 1);
                ++matched;
                if (!this.unparseTranslator.isEnabled()) continue;
                if (replacementText.length() > 0) {
                    replacementText.append(", ");
                }
                replacementText.append(HiveUtils.unparseIdentifier(tmp[0], this.conf));
                replacementText.append(".");
                replacementText.append(HiveUtils.unparseIdentifier(tmp[1], this.conf));
            }
        }
        if (matched == 0) {
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_COLUMN, sel));
        }
        if (this.unparseTranslator.isEnabled()) {
            this.unparseTranslator.addTranslation(sel, replacementText.toString());
        }
        return pos;
    }

    public String recommendName(ExprNodeDesc exp, String colAlias) {
        if (!colAlias.startsWith(this.autogenColAliasPrfxLbl)) {
            return null;
        }
        String column = ExprNodeDescUtils.recommendInputName(exp);
        if (column != null && !column.startsWith(this.autogenColAliasPrfxLbl)) {
            return column;
        }
        return null;
    }

    public String getAutogenColAliasPrfxLbl() {
        return this.autogenColAliasPrfxLbl;
    }

    public boolean autogenColAliasPrfxIncludeFuncName() {
        return this.autogenColAliasPrfxIncludeFuncName;
    }

    public void checkExpressionsForGroupingSet(List<HiveParserASTNode> grpByExprs, List<HiveParserASTNode> distinctGrpByExprs, Map<String, HiveParserASTNode> aggregationTrees, HiveParserRowResolver inputRowResolver) throws SemanticException {
        HashSet<String> colNamesGroupByExprs = new HashSet<String>();
        HashSet<String> colNamesGroupByDistinctExprs = new HashSet<String>();
        HashSet<String> colNamesAggregateParameters = new HashSet<String>();
        for (HiveParserASTNode hiveParserASTNode : grpByExprs) {
            HiveParserUtils.extractColumns(colNamesGroupByExprs, this.genExprNodeDesc(hiveParserASTNode, inputRowResolver));
        }
        if (!distinctGrpByExprs.isEmpty()) {
            for (HiveParserASTNode hiveParserASTNode : distinctGrpByExprs) {
                for (int i = 1; i < hiveParserASTNode.getChildCount(); ++i) {
                    HiveParserASTNode parameter = (HiveParserASTNode)hiveParserASTNode.getChild(i);
                    ExprNodeDesc distExprNode = this.genExprNodeDesc(parameter, inputRowResolver);
                    HiveParserUtils.extractColumns(colNamesGroupByDistinctExprs, distExprNode);
                }
                if (!HiveParserUtils.hasCommonElement(colNamesGroupByExprs, colNamesGroupByDistinctExprs)) continue;
                throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_EXPRESSION_INVALID.getMsg());
            }
        }
        for (Map.Entry entry : aggregationTrees.entrySet()) {
            HiveParserASTNode value = (HiveParserASTNode)entry.getValue();
            for (int i = 1; i < value.getChildCount(); ++i) {
                HiveParserASTNode paraExpr = (HiveParserASTNode)value.getChild(i);
                ExprNodeDesc paraExprNode = this.genExprNodeDesc(paraExpr, inputRowResolver);
                HiveParserUtils.extractColumns(colNamesAggregateParameters, paraExprNode);
            }
            if (!HiveParserUtils.hasCommonElement(colNamesGroupByExprs, colNamesAggregateParameters)) continue;
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_EXPRESSION_INVALID.getMsg());
        }
    }

    public void init(boolean clearPartsCache) {
        this.reset(clearPartsCache);
        this.qb = new HiveParserQB(null, null, false);
    }

    private Table getTableObjectByName(String tableName) throws HiveException {
        if (!this.tabNameToTabObject.containsKey(tableName)) {
            Table table = this.db.getTable(tableName);
            this.tabNameToTabObject.put(tableName, table);
            return table;
        }
        return this.tabNameToTabObject.get(tableName);
    }

    public boolean genResolvedParseTree(HiveParserASTNode ast, HiveParserPlannerContext plannerCtx) throws SemanticException {
        this.ast = ast;
        this.viewsExpanded = new ArrayList();
        this.ctesExpanded = new ArrayList();
        this.queryState.setCommandType(HiveOperation.QUERY);
        HiveParserBaseSemanticAnalyzer.Phase1Ctx ctx1 = HiveParserBaseSemanticAnalyzer.initPhase1Ctx();
        if (!this.doPhase1(ast, this.qb, ctx1, plannerCtx)) {
            return false;
        }
        LOG.info("Completed phase 1 of Semantic Analysis");
        this.getMetaData(this.qb, this.createVwDesc == null);
        LOG.info("Completed getting MetaData in Semantic Analysis");
        plannerCtx.setParseTreeAttr(ast, ctx1);
        return true;
    }

    public ExprNodeDesc genExprNodeDesc(HiveParserASTNode expr, HiveParserRowResolver input) throws SemanticException {
        return this.genExprNodeDesc(expr, input, true, false);
    }

    public ExprNodeDesc genExprNodeDesc(HiveParserASTNode expr, HiveParserRowResolver input, HiveParserRowResolver outerRR, Map<HiveParserASTNode, RelNode> subqueryToRelNode, boolean useCaching) throws SemanticException {
        HiveParserTypeCheckCtx tcCtx = new HiveParserTypeCheckCtx(input, useCaching, false, this.frameworkConfig, this.cluster);
        tcCtx.setOuterRR(outerRR);
        tcCtx.setSubqueryToRelNode(subqueryToRelNode);
        return this.genExprNodeDesc(expr, input, tcCtx);
    }

    private ExprNodeDesc genExprNodeDesc(HiveParserASTNode expr, HiveParserRowResolver input, boolean useCaching, boolean foldExpr) throws SemanticException {
        HiveParserTypeCheckCtx tcCtx = new HiveParserTypeCheckCtx(input, useCaching, foldExpr, this.frameworkConfig, this.cluster);
        return this.genExprNodeDesc(expr, input, tcCtx);
    }

    public Map<HiveParserASTNode, ExprNodeDesc> genAllExprNodeDesc(HiveParserASTNode expr, HiveParserRowResolver input) throws SemanticException {
        HiveParserTypeCheckCtx tcCtx = new HiveParserTypeCheckCtx(input, this.frameworkConfig, this.cluster);
        return this.genAllExprNodeDesc(expr, input, tcCtx);
    }

    public ExprNodeDesc genExprNodeDesc(HiveParserASTNode expr, HiveParserRowResolver input, HiveParserTypeCheckCtx tcCtx) throws SemanticException {
        ExprNodeDesc cached = null;
        if (tcCtx.isUseCaching()) {
            cached = this.getExprNodeDescCached(expr, input);
        }
        if (cached == null) {
            Map<HiveParserASTNode, ExprNodeDesc> allExprs = this.genAllExprNodeDesc(expr, input, tcCtx);
            return allExprs.get(expr);
        }
        return cached;
    }

    private ExprNodeDesc getExprNodeDescCached(HiveParserASTNode expr, HiveParserRowResolver input) throws SemanticException {
        ColumnInfo colInfo = input.getExpression(expr);
        if (colInfo != null) {
            HiveParserASTNode source = input.getExpressionSource(expr);
            if (source != null) {
                this.unparseTranslator.addCopyTranslation(expr, source);
            }
            return new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isSkewedCol());
        }
        return null;
    }

    public Map<HiveParserASTNode, ExprNodeDesc> genAllExprNodeDesc(HiveParserASTNode expr, HiveParserRowResolver input, HiveParserTypeCheckCtx tcCtx) throws SemanticException {
        tcCtx.setUnparseTranslator(this.unparseTranslator);
        Map<HiveParserASTNode, ExprNodeDesc> nodeOutputs = HiveParserTypeCheckProcFactory.genExprNode(expr, tcCtx);
        ExprNodeDesc desc = nodeOutputs.get(expr);
        if (desc == null) {
            String errMsg = tcCtx.getError();
            if (errMsg == null) {
                errMsg = "Error in parsing ";
            }
            throw new SemanticException(errMsg);
        }
        if (desc instanceof HiveParserExprNodeColumnListDesc) {
            throw new SemanticException("TOK_ALLCOLREF is not supported in current context");
        }
        if (!this.unparseTranslator.isEnabled()) {
            return nodeOutputs;
        }
        HashMap<ExprNodeColumnDesc, String> nodeToText = new HashMap<ExprNodeColumnDesc, String>();
        ArrayList<HiveParserASTNode> fieldDescList = new ArrayList<HiveParserASTNode>();
        for (Map.Entry<HiveParserASTNode, ExprNodeDesc> entry : nodeOutputs.entrySet()) {
            if (!(entry.getValue() instanceof ExprNodeColumnDesc)) {
                if (!(entry.getValue() instanceof ExprNodeFieldDesc)) continue;
                fieldDescList.add(entry.getKey());
                continue;
            }
            HiveParserASTNode node = entry.getKey();
            ExprNodeColumnDesc columnDesc = (ExprNodeColumnDesc)entry.getValue();
            if (columnDesc.getTabAlias() == null || columnDesc.getTabAlias().length() == 0) continue;
            String[] tmp = input.reverseLookup(columnDesc.getColumn());
            if (tmp[0] != null && columnDesc.getTabAlias() != null && !tmp[0].equals(columnDesc.getTabAlias()) && tcCtx.getOuterRR() != null) {
                tmp = tcCtx.getOuterRR().reverseLookup(columnDesc.getColumn());
            }
            StringBuilder replacementText = new StringBuilder();
            replacementText.append(HiveUtils.unparseIdentifier(tmp[0], this.conf));
            replacementText.append(".");
            replacementText.append(HiveUtils.unparseIdentifier(tmp[1], this.conf));
            nodeToText.put(columnDesc, replacementText.toString());
            this.unparseTranslator.addTranslation(node, replacementText.toString());
        }
        for (HiveParserASTNode node : fieldDescList) {
            Map<HiveParserASTNode, String> map = this.translateFieldDesc(node);
            for (Map.Entry<HiveParserASTNode, String> entry : map.entrySet()) {
                this.unparseTranslator.addTranslation(entry.getKey(), entry.getValue());
            }
        }
        return nodeOutputs;
    }

    private Map<HiveParserASTNode, String> translateFieldDesc(HiveParserASTNode node) {
        HashMap<HiveParserASTNode, String> map = new HashMap<HiveParserASTNode, String>();
        if (node.getType() == 16) {
            for (Node child : node.getChildren()) {
                map.putAll(this.translateFieldDesc((HiveParserASTNode)child));
            }
        } else if (node.getType() == 24) {
            map.put(node, HiveUtils.unparseIdentifier(node.getText(), this.conf));
        }
        return map;
    }

    public HiveParserQB getQB() {
        return this.qb;
    }

    public void setQB(HiveParserQB qb) {
        this.qb = qb;
    }

    private HiveParserPTFInvocationSpec.PTFInputSpec processPTFSource(HiveParserQB qb, HiveParserASTNode inputNode) throws SemanticException {
        HiveParserPTFInvocationSpec.PTFInputSpec qInSpec = null;
        int type = inputNode.getType();
        switch (type) {
            case 981: {
                String alias = this.processTable(qb, inputNode);
                qInSpec = new HiveParserPTFInvocationSpec.PTFQueryInputSpec();
                ((HiveParserPTFInvocationSpec.PTFQueryInputSpec)qInSpec).setType(PTFInvocationSpec.PTFQueryInputType.TABLE);
                ((HiveParserPTFInvocationSpec.PTFQueryInputSpec)qInSpec).setSource(alias);
                break;
            }
            case 945: {
                String alias = this.processSubQuery(qb, inputNode);
                qInSpec = new HiveParserPTFInvocationSpec.PTFQueryInputSpec();
                ((HiveParserPTFInvocationSpec.PTFQueryInputSpec)qInSpec).setType(PTFInvocationSpec.PTFQueryInputType.SUBQUERY);
                ((HiveParserPTFInvocationSpec.PTFQueryInputSpec)qInSpec).setSource(alias);
                break;
            }
            case 879: {
                qInSpec = this.processPTFChain(qb, inputNode);
                break;
            }
            default: {
                throw new SemanticException(HiveParserUtils.generateErrorMessage(inputNode, "Unknown input type to PTF"));
            }
        }
        qInSpec.setAstNode(inputNode);
        return qInSpec;
    }

    private HiveParserPTFInvocationSpec.PartitionedTableFunctionSpec processPTFChain(HiveParserQB qb, HiveParserASTNode ptf) throws SemanticException {
        HiveParserASTNode pSpecNode;
        int childCount = ptf.getChildCount();
        if (childCount < 2) {
            throw new SemanticException(HiveParserUtils.generateErrorMessage(ptf, "Not enough Children " + childCount));
        }
        HiveParserPTFInvocationSpec.PartitionedTableFunctionSpec ptfSpec = new HiveParserPTFInvocationSpec.PartitionedTableFunctionSpec();
        ptfSpec.setAstNode(ptf);
        HiveParserASTNode nameNode = (HiveParserASTNode)ptf.getChild(0);
        ptfSpec.setName(nameNode.getText());
        int inputIdx = 1;
        HiveParserASTNode secondChild = (HiveParserASTNode)ptf.getChild(1);
        if (secondChild.getType() == 24) {
            ptfSpec.setAlias(secondChild.getText());
            ++inputIdx;
        }
        HiveParserASTNode inputNode = (HiveParserASTNode)ptf.getChild(inputIdx);
        ptfSpec.setInput(this.processPTFSource(qb, inputNode));
        int argStartIdx = inputIdx + 1;
        int pSpecIdx = inputIdx + 1;
        HiveParserASTNode hiveParserASTNode = pSpecNode = ptf.getChildCount() > inputIdx ? (HiveParserASTNode)ptf.getChild(pSpecIdx) : null;
        if (pSpecNode != null && pSpecNode.getType() == 857) {
            HiveParserPTFInvocationSpec.PartitioningSpec partitioning = HiveParserBaseSemanticAnalyzer.processPTFPartitionSpec(pSpecNode);
            ptfSpec.setPartitioning(partitioning);
            ++argStartIdx;
        }
        for (int i = argStartIdx; i < ptf.getChildCount(); ++i) {
            ptfSpec.addArg((HiveParserASTNode)ptf.getChild(i));
        }
        return ptfSpec;
    }

    private void processPTF(HiveParserQB qb, HiveParserASTNode ptf) throws SemanticException {
        HiveParserPTFInvocationSpec.PartitionedTableFunctionSpec ptfSpec = this.processPTFChain(qb, ptf);
        if (ptfSpec.getAlias() != null) {
            qb.addAlias(ptfSpec.getAlias());
        }
        HiveParserPTFInvocationSpec spec = new HiveParserPTFInvocationSpec();
        spec.setFunction(ptfSpec);
        qb.addPTFNodeToSpec(ptf, spec);
    }
}

