/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.planner.delegation.ParserFactory;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.delegation.hive.HiveParser;

public class HiveParserFactory
implements ParserFactory {
    public Parser create(CatalogManager catalogManager, PlannerContext plannerContext) {
        return new HiveParser(catalogManager, () -> plannerContext.createFlinkPlanner(catalogManager.getCurrentCatalog(), catalogManager.getCurrentDatabase()), () -> ((PlannerContext)plannerContext).createCalciteParser(), plannerContext);
    }

    public Map<String, String> optionalContext() {
        DescriptorProperties properties = new DescriptorProperties();
        return properties.asMap();
    }

    public Map<String, String> requiredContext() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(TableConfigOptions.TABLE_SQL_DIALECT.key(), SqlDialect.HIVE.name().toLowerCase());
        return properties.asMap();
    }

    public List<String> supportedProperties() {
        return Collections.singletonList(TableConfigOptions.TABLE_SQL_DIALECT.key());
    }
}

